/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPackageImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeParameterImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaValueParameterImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaElementCollectionFromPsiArrayUtil {
    private JavaElementCollectionFromPsiArrayUtil() {
    }

    @NotNull
    private static <Psi, Java> Collection<Java> convert(@NotNull Psi[] elements, @NotNull Factory<Psi, Java> factory) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        if (elements.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
            }
            return list;
        }
        ArrayList<Java> result = new ArrayList<Java>(elements.length);
        for (Psi element : elements) {
            result.add(factory.create(element));
        }
        ArrayList<Java> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "convert"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<JavaClass> classes(@NotNull PsiClass[] classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        Collection<JavaClass> collection = JavaElementCollectionFromPsiArrayUtil.convert(classes, Factories.CLASSES);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classes"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaPackage> packages(@NotNull PsiPackage[] packages) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "packages"));
        }
        Collection<JavaPackage> collection = JavaElementCollectionFromPsiArrayUtil.convert(packages, Factories.PACKAGES);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "packages"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaMethod> methods(@NotNull PsiMethod[] methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "methods"));
        }
        Collection<JavaMethod> collection = JavaElementCollectionFromPsiArrayUtil.convert(methods, Factories.METHODS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "methods"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaField> fields(@NotNull PsiField[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "fields"));
        }
        Collection<JavaField> collection = JavaElementCollectionFromPsiArrayUtil.convert(fields, Factories.FIELDS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "fields"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaValueParameter> valueParameters(@NotNull PsiParameter[] parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "valueParameters"));
        }
        Collection<JavaValueParameter> collection = JavaElementCollectionFromPsiArrayUtil.convert(parameters, Factories.VALUE_PARAMETERS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "valueParameters"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaTypeParameter> typeParameters(@NotNull PsiTypeParameter[] typeParameters) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "typeParameters"));
        }
        Collection<JavaTypeParameter> collection = JavaElementCollectionFromPsiArrayUtil.convert(typeParameters, Factories.TYPE_PARAMETERS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "typeParameters"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaType> types(@NotNull PsiType[] types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "types"));
        }
        Collection<JavaType> collection = JavaElementCollectionFromPsiArrayUtil.convert(types, Factories.TYPES);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "types"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaClassifierType> classifierTypes(@NotNull PsiClassType[] classTypes) {
        if (classTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classifierTypes"));
        }
        Collection<JavaClassifierType> collection = JavaElementCollectionFromPsiArrayUtil.convert(classTypes, Factories.CLASSIFIER_TYPES);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "classifierTypes"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaAnnotation> annotations(@NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "annotations"));
        }
        Collection<JavaAnnotation> collection = JavaElementCollectionFromPsiArrayUtil.convert(annotations, Factories.ANNOTATIONS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "annotations"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaAnnotationArgument> namelessAnnotationArguments(@NotNull PsiAnnotationMemberValue[] memberValues) {
        if (memberValues == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namelessAnnotationArguments"));
        }
        Collection<JavaAnnotationArgument> collection = JavaElementCollectionFromPsiArrayUtil.convert(memberValues, Factories.NAMELESS_ANNOTATION_ARGUMENTS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namelessAnnotationArguments"));
        }
        return collection;
    }

    @NotNull
    public static Collection<JavaAnnotationArgument> namedAnnotationArguments(@NotNull PsiNameValuePair[] nameValuePairs) {
        if (nameValuePairs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namedAnnotationArguments"));
        }
        Collection<JavaAnnotationArgument> collection = JavaElementCollectionFromPsiArrayUtil.convert(nameValuePairs, Factories.NAMED_ANNOTATION_ARGUMENTS);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil", "namedAnnotationArguments"));
        }
        return collection;
    }

    private static class Factories {
        private static final Factory<PsiClass, JavaClassImpl> CLASSES = new Factory<PsiClass, JavaClassImpl>(){

            @Override
            @NotNull
            public JavaClassImpl create(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$1", "create"));
                }
                JavaClassImpl javaClassImpl = new JavaClassImpl(psiClass);
                if (javaClassImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$1", "create"));
                }
                return javaClassImpl;
            }
        };
        private static final Factory<PsiPackage, JavaPackageImpl> PACKAGES = new Factory<PsiPackage, JavaPackageImpl>(){

            @Override
            @NotNull
            public JavaPackageImpl create(@NotNull PsiPackage psiPackage) {
                if (psiPackage == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$2", "create"));
                }
                JavaPackageImpl javaPackageImpl = new JavaPackageImpl(psiPackage);
                if (javaPackageImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$2", "create"));
                }
                return javaPackageImpl;
            }
        };
        private static final Factory<PsiMethod, JavaMethodImpl> METHODS = new Factory<PsiMethod, JavaMethodImpl>(){

            @Override
            @NotNull
            public JavaMethodImpl create(@NotNull PsiMethod psiMethod) {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$3", "create"));
                }
                JavaMethodImpl javaMethodImpl = new JavaMethodImpl(psiMethod);
                if (javaMethodImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$3", "create"));
                }
                return javaMethodImpl;
            }
        };
        private static final Factory<PsiField, JavaFieldImpl> FIELDS = new Factory<PsiField, JavaFieldImpl>(){

            @Override
            @NotNull
            public JavaFieldImpl create(@NotNull PsiField psiField) {
                if (psiField == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$4", "create"));
                }
                JavaFieldImpl javaFieldImpl = new JavaFieldImpl(psiField);
                if (javaFieldImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$4", "create"));
                }
                return javaFieldImpl;
            }
        };
        private static final Factory<PsiParameter, JavaValueParameterImpl> VALUE_PARAMETERS = new Factory<PsiParameter, JavaValueParameterImpl>(){

            @Override
            @NotNull
            public JavaValueParameterImpl create(@NotNull PsiParameter psiParameter) {
                if (psiParameter == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$5", "create"));
                }
                JavaValueParameterImpl javaValueParameterImpl = new JavaValueParameterImpl(psiParameter);
                if (javaValueParameterImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$5", "create"));
                }
                return javaValueParameterImpl;
            }
        };
        private static final Factory<PsiTypeParameter, JavaTypeParameterImpl> TYPE_PARAMETERS = new Factory<PsiTypeParameter, JavaTypeParameterImpl>(){

            @Override
            @NotNull
            public JavaTypeParameterImpl create(@NotNull PsiTypeParameter psiTypeParameter) {
                if (psiTypeParameter == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$6", "create"));
                }
                JavaTypeParameterImpl javaTypeParameterImpl = new JavaTypeParameterImpl(psiTypeParameter);
                if (javaTypeParameterImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$6", "create"));
                }
                return javaTypeParameterImpl;
            }
        };
        private static final Factory<PsiType, JavaTypeImpl<?>> TYPES = new Factory<PsiType, JavaTypeImpl<?>>(){

            @Override
            @NotNull
            public JavaTypeImpl<?> create(@NotNull PsiType psiType) {
                if (psiType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$7", "create"));
                }
                JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(psiType);
                if (javaTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$7", "create"));
                }
                return javaTypeImpl;
            }
        };
        private static final Factory<PsiClassType, JavaClassifierTypeImpl> CLASSIFIER_TYPES = new Factory<PsiClassType, JavaClassifierTypeImpl>(){

            @Override
            @NotNull
            public JavaClassifierTypeImpl create(@NotNull PsiClassType psiClassType) {
                if (psiClassType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$8", "create"));
                }
                JavaClassifierTypeImpl javaClassifierTypeImpl = new JavaClassifierTypeImpl(psiClassType);
                if (javaClassifierTypeImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$8", "create"));
                }
                return javaClassifierTypeImpl;
            }
        };
        private static final Factory<PsiAnnotation, JavaAnnotationImpl> ANNOTATIONS = new Factory<PsiAnnotation, JavaAnnotationImpl>(){

            @Override
            @NotNull
            public JavaAnnotationImpl create(@NotNull PsiAnnotation psiAnnotation) {
                if (psiAnnotation == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$9", "create"));
                }
                JavaAnnotationImpl javaAnnotationImpl = new JavaAnnotationImpl(psiAnnotation);
                if (javaAnnotationImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$9", "create"));
                }
                return javaAnnotationImpl;
            }
        };
        private static final Factory<PsiAnnotationMemberValue, JavaAnnotationArgument> NAMELESS_ANNOTATION_ARGUMENTS = new Factory<PsiAnnotationMemberValue, JavaAnnotationArgument>(){

            @Override
            @NotNull
            public JavaAnnotationArgument create(@NotNull PsiAnnotationMemberValue psiAnnotationMemberValue) {
                if (psiAnnotationMemberValue == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$10", "create"));
                }
                JavaAnnotationArgument javaAnnotationArgument = JavaAnnotationArgumentImpl.create(psiAnnotationMemberValue, null);
                if (javaAnnotationArgument == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$10", "create"));
                }
                return javaAnnotationArgument;
            }
        };
        private static final Factory<PsiNameValuePair, JavaAnnotationArgument> NAMED_ANNOTATION_ARGUMENTS = new Factory<PsiNameValuePair, JavaAnnotationArgument>(){

            @Override
            @NotNull
            public JavaAnnotationArgument create(@NotNull PsiNameValuePair psiNameValuePair) {
                if (psiNameValuePair == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$11", "create"));
                }
                String name = psiNameValuePair.getName();
                PsiAnnotationMemberValue value = psiNameValuePair.getValue();
                assert (value != null) : "Annotation argument value cannot be null: " + name;
                JavaAnnotationArgument javaAnnotationArgument = JavaAnnotationArgumentImpl.create(value, name == null ? null : Name.identifier(name));
                if (javaAnnotationArgument == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaElementCollectionFromPsiArrayUtil$Factories$11", "create"));
                }
                return javaAnnotationArgument;
            }
        };

        private Factories() {
        }
    }

    private static interface Factory<Psi, Java> {
        @NotNull
        public Java create(@NotNull Psi var1);
    }
}

