/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionCodeFragment;
import org.jetbrains.jet.lang.psi.JetExpressionCodeFragmentImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionType;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUnparsingUtils;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeCodeFragment;
import org.jetbrains.jet.lang.psi.JetTypeCodeFragmentImpl;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgument;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.plugin.JetFileType;

public class JetPsiFactory {
    @NotNull
    public static ASTNode createValNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = 1");
        ASTNode aSTNode = property.getValOrVarNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createValNode"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode createVarNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "var x = 1");
        ASTNode aSTNode = property.getValOrVarNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createVarNode"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode createValOrVarNode(Project project, String text) {
        ASTNode aSTNode = JetPsiFactory.createParameterList(project, "(" + text + " int x)").getParameters().get(0).getValOrVarNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createValOrVarNode"));
        }
        return aSTNode;
    }

    @NotNull
    public static JetExpression createExpression(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = " + text);
        JetExpression jetExpression = property.getInitializer();
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createExpression"));
        }
        return jetExpression;
    }

    @NotNull
    public static JetValueArgumentList createCallArguments(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = foo" + text);
        JetExpression initializer = property.getInitializer();
        JetCallExpression callExpression = (JetCallExpression)initializer;
        JetValueArgumentList jetValueArgumentList = callExpression.getValueArgumentList();
        if (jetValueArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createCallArguments"));
        }
        return jetValueArgumentList;
    }

    @NotNull
    public static JetTypeArgumentList createTypeArguments(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x = foo" + text + "()");
        JetExpression initializer = property.getInitializer();
        JetCallExpression callExpression = (JetCallExpression)initializer;
        JetTypeArgumentList jetTypeArgumentList = callExpression.getTypeArgumentList();
        if (jetTypeArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createTypeArguments"));
        }
        return jetTypeArgumentList;
    }

    @NotNull
    public static JetTypeReference createType(Project project, String type) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x : " + type);
        JetTypeReference jetTypeReference = property.getTypeRef();
        if (jetTypeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createType"));
        }
        return jetTypeReference;
    }

    @NotNull
    public static PsiElement createStar(Project project) {
        PsiElement star = JetPsiFactory.createType(project, "List<*>").findElementAt(5);
        assert (star != null);
        PsiElement psiElement = star;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createStar"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createComma(Project project) {
        PsiElement comma = JetPsiFactory.createType(project, "T<X, Y>").findElementAt(3);
        assert (comma != null);
        PsiElement psiElement = comma;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createComma"));
        }
        return psiElement;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createColonAndWhiteSpaces(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x : Int");
        Pair<PsiElement, PsiElement> pair = Pair.create(property.findElementAt(5), property.findElementAt(7));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createColonAndWhiteSpaces"));
        }
        return pair;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createTypeWhiteSpaceAndColon(Project project, String type) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x: " + type);
        Pair<PsiElement, PsiElement> pair = Pair.create(property.findElementAt(5), property.getTypeRef());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createTypeWhiteSpaceAndColon"));
        }
        return pair;
    }

    @NotNull
    public static ASTNode createColonNode(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x: Int");
        ASTNode aSTNode = property.getNode().findChildByType(JetTokens.COLON);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createColonNode"));
        }
        return aSTNode;
    }

    @NotNull
    public static PsiElement createSemicolon(Project project) {
        JetProperty property = JetPsiFactory.createProperty(project, "val x: Int;");
        PsiElement semicolon = property.findElementAt(10);
        assert (semicolon != null);
        PsiElement psiElement = semicolon;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createSemicolon"));
        }
        return psiElement;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createWhitespaceAndArrow(Project project) {
        JetFunctionType functionType = (JetFunctionType)JetPsiFactory.createType(project, "() -> Int").getTypeElement();
        assert (functionType != null);
        Pair<PsiElement, PsiElement> pair = Pair.create(functionType.findElementAt(2), functionType.findElementAt(3));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createWhitespaceAndArrow"));
        }
        return pair;
    }

    @NotNull
    public static PsiElement createWhiteSpace(Project project) {
        PsiElement psiElement = JetPsiFactory.createWhiteSpace(project, " ");
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createWhiteSpace"));
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement createWhiteSpace(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, "val" + text + "x");
        PsiElement psiElement = property.findElementAt(3);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createWhiteSpace"));
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createNewLine(Project project) {
        PsiElement psiElement = JetPsiFactory.createWhiteSpace(project, "\n");
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createNewLine"));
        }
        return psiElement;
    }

    @NotNull
    public static JetClass createClass(Project project, String text) {
        JetClass jetClass = JetPsiFactory.createDeclaration(project, text, JetClass.class);
        if (jetClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createClass"));
        }
        return jetClass;
    }

    @NotNull
    public static JetFile createFile(Project project, String text) {
        JetFile jetFile = JetPsiFactory.createFile(project, "dummy.kt", text);
        if (jetFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createFile"));
        }
        return jetFile;
    }

    @NotNull
    public static JetFile createFile(Project project, String fileName, String text) {
        JetFile jetFile = (JetFile)PsiFileFactory.getInstance(project).createFileFromText(fileName, JetFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), false);
        if (jetFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createFile"));
        }
        return jetFile;
    }

    @NotNull
    public static JetFile createPhysicalFile(Project project, String fileName, String text) {
        JetFile jetFile = (JetFile)PsiFileFactory.getInstance(project).createFileFromText(fileName, JetFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (jetFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createPhysicalFile"));
        }
        return jetFile;
    }

    @NotNull
    public static JetProperty createProperty(Project project, String name, String type, boolean isVar, @Nullable String initializer) {
        String text = (isVar ? "var " : "val ") + name + (type != null ? ":" + type : "") + (initializer == null ? "" : " = " + initializer);
        JetProperty jetProperty = JetPsiFactory.createProperty(project, text);
        if (jetProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createProperty"));
        }
        return jetProperty;
    }

    @NotNull
    public static JetProperty createProperty(Project project, String name, String type, boolean isVar) {
        JetProperty jetProperty = JetPsiFactory.createProperty(project, name, type, isVar, null);
        if (jetProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createProperty"));
        }
        return jetProperty;
    }

    @NotNull
    public static JetProperty createProperty(Project project, String text) {
        JetProperty jetProperty = JetPsiFactory.createDeclaration(project, text, JetProperty.class);
        if (jetProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createProperty"));
        }
        return jetProperty;
    }

    @NotNull
    public static <T> T createDeclaration(Project project, String text, Class<T> clazz) {
        JetDeclaration result;
        JetFile file = JetPsiFactory.createFile(project, text);
        List<JetDeclaration> dcls = file.getDeclarations();
        assert (dcls.size() == 1) : dcls.size() + " declarations in " + text;
        JetDeclaration jetDeclaration = result = dcls.get(0);
        if (jetDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createDeclaration"));
        }
        return (T)jetDeclaration;
    }

    @NotNull
    public static PsiElement createNameIdentifier(Project project, String name) {
        PsiElement psiElement = JetPsiFactory.createProperty(project, name, null, false).getNameIdentifier();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createNameIdentifier"));
        }
        return psiElement;
    }

    @NotNull
    public static JetSimpleNameExpression createSimpleName(Project project, String name) {
        JetSimpleNameExpression jetSimpleNameExpression = (JetSimpleNameExpression)JetPsiFactory.createProperty(project, name, null, false, name).getInitializer();
        if (jetSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createSimpleName"));
        }
        return jetSimpleNameExpression;
    }

    @NotNull
    public static PsiElement createIdentifier(Project project, String name) {
        PsiElement psiElement = JetPsiFactory.createSimpleName(project, name).getIdentifier();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createIdentifier"));
        }
        return psiElement;
    }

    @NotNull
    public static JetNamedFunction createFunction(Project project, String funDecl) {
        JetNamedFunction jetNamedFunction = JetPsiFactory.createDeclaration(project, funDecl, JetNamedFunction.class);
        if (jetNamedFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createFunction"));
        }
        return jetNamedFunction;
    }

    @NotNull
    public static JetModifierList createModifierList(Project project, JetKeywordToken modifier) {
        JetModifierList jetModifierList = JetPsiFactory.createModifierList(project, modifier.getValue());
        if (jetModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createModifierList"));
        }
        return jetModifierList;
    }

    @NotNull
    public static JetModifierList createModifierList(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, text + " val x");
        JetModifierList jetModifierList = property.getModifierList();
        if (jetModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createModifierList"));
        }
        return jetModifierList;
    }

    @NotNull
    public static JetAnnotation createAnnotation(Project project, String text) {
        JetProperty property = JetPsiFactory.createProperty(project, text + " val x");
        JetModifierList modifierList = property.getModifierList();
        assert (modifierList != null);
        JetAnnotation jetAnnotation = modifierList.getAnnotations().get(0);
        if (jetAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createAnnotation"));
        }
        return jetAnnotation;
    }

    @NotNull
    public static JetModifierList createConstructorModifierList(Project project, JetKeywordToken modifier) {
        JetClass aClass = JetPsiFactory.createClass(project, "class C " + modifier.getValue() + " (){}");
        JetModifierList jetModifierList = aClass.getPrimaryConstructorModifierList();
        if (jetModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createConstructorModifierList"));
        }
        return jetModifierList;
    }

    @NotNull
    public static JetExpression createEmptyBody(Project project) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo() {}");
        JetExpression jetExpression = function.getBodyExpression();
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createEmptyBody"));
        }
        return jetExpression;
    }

    @NotNull
    public static JetClassBody createEmptyClassBody(Project project) {
        JetClass aClass = JetPsiFactory.createClass(project, "class A(){}");
        JetClassBody jetClassBody = aClass.getBody();
        if (jetClassBody == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createEmptyClassBody"));
        }
        return jetClassBody;
    }

    @NotNull
    public static JetParameter createParameter(Project project, String name, String type) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo(" + name + " : " + type + ") {}");
        JetParameter jetParameter = function.getValueParameters().get(0);
        if (jetParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createParameter"));
        }
        return jetParameter;
    }

    @NotNull
    public static JetParameterList createParameterList(Project project, String text) {
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo" + text + "{}");
        JetParameterList jetParameterList = function.getValueParameterList();
        if (jetParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createParameterList"));
        }
        return jetParameterList;
    }

    @NotNull
    public static JetWhenEntry createWhenEntry(@NotNull Project project, @NotNull String entryText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createWhenEntry"));
        }
        if (entryText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createWhenEntry"));
        }
        JetNamedFunction function = JetPsiFactory.createFunction(project, "fun foo() { when(12) { " + entryText + " } }");
        JetWhenEntry whenEntry = PsiTreeUtil.findChildOfType(function, JetWhenEntry.class);
        assert (whenEntry != null) : "Couldn't generate when entry";
        assert (entryText.equals(whenEntry.getText())) : "Generate when entry text differs from the given text";
        JetWhenEntry jetWhenEntry = whenEntry;
        if (jetWhenEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createWhenEntry"));
        }
        return jetWhenEntry;
    }

    @NotNull
    public static JetStringTemplateEntryWithExpression createBlockStringTemplateEntry(@NotNull Project project, @NotNull JetExpression expression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBlockStringTemplateEntry"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBlockStringTemplateEntry"));
        }
        JetStringTemplateExpression stringTemplateExpression = (JetStringTemplateExpression)JetPsiFactory.createExpression(project, "\"${" + expression.getText() + "}\"");
        JetStringTemplateEntryWithExpression jetStringTemplateEntryWithExpression = (JetStringTemplateEntryWithExpression)stringTemplateExpression.getEntries()[0];
        if (jetStringTemplateEntryWithExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBlockStringTemplateEntry"));
        }
        return jetStringTemplateEntryWithExpression;
    }

    @NotNull
    public static JetImportDirective createImportDirective(Project project, @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createImportDirective"));
        }
        JetImportDirective jetImportDirective = JetPsiFactory.createImportDirective(project, new ImportPath(path));
        if (jetImportDirective == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createImportDirective"));
        }
        return jetImportDirective;
    }

    @NotNull
    public static JetImportDirective createImportDirective(Project project, @NotNull ImportPath importPath) {
        if (importPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createImportDirective"));
        }
        if (importPath.fqnPart().isRoot()) {
            throw new IllegalArgumentException("import path must not be empty");
        }
        StringBuilder importDirectiveBuilder = new StringBuilder("import ");
        importDirectiveBuilder.append(importPath.getPathStr());
        Name alias = importPath.getAlias();
        if (alias != null) {
            importDirectiveBuilder.append(" as ").append(alias.asString());
        }
        JetFile namespace = JetPsiFactory.createFile(project, importDirectiveBuilder.toString());
        JetImportDirective jetImportDirective = namespace.getImportDirectives().iterator().next();
        if (jetImportDirective == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createImportDirective"));
        }
        return jetImportDirective;
    }

    @NotNull
    public static PsiElement createPrimaryConstructor(Project project) {
        JetClass aClass = JetPsiFactory.createClass(project, "class A()");
        PsiElement psiElement = aClass.findElementAt(7).getParent();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createPrimaryConstructor"));
        }
        return psiElement;
    }

    @NotNull
    public static JetSimpleNameExpression createClassLabel(Project project, @NotNull String labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createClassLabel"));
        }
        JetThisExpression expression = (JetThisExpression)JetPsiFactory.createExpression(project, "this@" + labelName);
        JetSimpleNameExpression jetSimpleNameExpression = expression.getTargetLabel();
        if (jetSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createClassLabel"));
        }
        return jetSimpleNameExpression;
    }

    @NotNull
    public static JetExpression createFieldIdentifier(Project project, @NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createFieldIdentifier"));
        }
        JetExpression jetExpression = JetPsiFactory.createExpression(project, "$" + fieldName);
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createFieldIdentifier"));
        }
        return jetExpression;
    }

    @NotNull
    public static JetBinaryExpression createBinaryExpression(Project project, @NotNull String lhs, @NotNull String op, @NotNull String rhs) {
        if (lhs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBinaryExpression"));
        }
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBinaryExpression"));
        }
        if (rhs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBinaryExpression"));
        }
        JetBinaryExpression jetBinaryExpression = (JetBinaryExpression)JetPsiFactory.createExpression(project, lhs + " " + op + " " + rhs);
        if (jetBinaryExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBinaryExpression"));
        }
        return jetBinaryExpression;
    }

    @NotNull
    public static JetBinaryExpression createBinaryExpression(Project project, @Nullable JetExpression lhs, @NotNull String op, @Nullable JetExpression rhs) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBinaryExpression"));
        }
        JetBinaryExpression jetBinaryExpression = JetPsiFactory.createBinaryExpression(project, JetPsiUtil.getText(lhs), op, JetPsiUtil.getText(rhs));
        if (jetBinaryExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createBinaryExpression"));
        }
        return jetBinaryExpression;
    }

    @NotNull
    public static JetTypeCodeFragment createTypeCodeFragment(Project project, String text, PsiElement context) {
        JetTypeCodeFragmentImpl jetTypeCodeFragmentImpl = new JetTypeCodeFragmentImpl(project, "fragment.kt", text, context);
        if (jetTypeCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createTypeCodeFragment"));
        }
        return jetTypeCodeFragmentImpl;
    }

    @NotNull
    public static JetExpressionCodeFragment createExpressionCodeFragment(Project project, String text, PsiElement context) {
        JetExpressionCodeFragmentImpl jetExpressionCodeFragmentImpl = new JetExpressionCodeFragmentImpl(project, "fragment.kt", text, context);
        if (jetExpressionCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createExpressionCodeFragment"));
        }
        return jetExpressionCodeFragmentImpl;
    }

    @NotNull
    public static JetReturnExpression createReturn(Project project, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createReturn"));
        }
        JetReturnExpression jetReturnExpression = (JetReturnExpression)JetPsiFactory.createExpression(project, "return " + text);
        if (jetReturnExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createReturn"));
        }
        return jetReturnExpression;
    }

    @NotNull
    public static JetReturnExpression createReturn(Project project, @Nullable JetExpression expression) {
        JetReturnExpression jetReturnExpression = JetPsiFactory.createReturn(project, JetPsiUtil.getText(expression));
        if (jetReturnExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createReturn"));
        }
        return jetReturnExpression;
    }

    @NotNull
    public static JetIfExpression createIf(Project project, @Nullable JetExpression condition, @Nullable JetExpression thenExpr, @Nullable JetExpression elseExpr) {
        JetIfExpression jetIfExpression = (JetIfExpression)JetPsiFactory.createExpression(project, JetPsiUnparsingUtils.toIf(condition, thenExpr, elseExpr));
        if (jetIfExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createIf"));
        }
        return jetIfExpression;
    }

    @NotNull
    public static JetValueArgument createArgumentWithName(@NotNull Project project, @NotNull String name, @NotNull JetExpression argumentExpression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createArgumentWithName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createArgumentWithName"));
        }
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createArgumentWithName"));
        }
        JetValueArgument jetValueArgument = JetPsiFactory.createCallArguments(project, "(" + name + " = " + argumentExpression.getText() + ")").getArguments().get(0);
        if (jetValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createArgumentWithName"));
        }
        return jetValueArgument;
    }

    @NotNull
    public static JetExpression createFunctionBody(Project project, @NotNull String bodyText) {
        if (bodyText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createFunctionBody"));
        }
        JetNamedFunction func = JetPsiFactory.createFunction(project, "fun foo() {\n" + bodyText + "\n}");
        JetExpression jetExpression = func.getBodyExpression();
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createFunctionBody"));
        }
        return jetExpression;
    }

    @NotNull
    public static JetClassObject createEmptyClassObject(Project project) {
        JetClass klass = JetPsiFactory.createClass(project, "class foo { class object { } }");
        JetClassObject jetClassObject = klass.getClassObject();
        if (jetClassObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "createEmptyClassObject"));
        }
        return jetClassObject;
    }

    @NotNull
    public static JetBlockExpression wrapInABlock(final @NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory", "wrapInABlock"));
        }
        if (expression instanceof JetBlockExpression) {
            JetBlockExpression jetBlockExpression = (JetBlockExpression)expression;
            if (jetBlockExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "wrapInABlock"));
            }
            return jetBlockExpression;
        }
        JetNamedFunction function = JetPsiFactory.createFunction(expression.getProject(), "fun f() { " + expression.getText() + "}");
        JetBlockExpression block = (JetBlockExpression)function.getBodyExpression();
        assert (block != null);
        JetBlockExpression jetBlockExpression = new JetBlockExpression(block.getNode()){

            @Override
            @NotNull
            public List<JetElement> getStatements() {
                List<JetElement> list = Collections.singletonList(expression);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$1", "getStatements"));
                }
                return list;
            }
        };
        if (jetBlockExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory", "wrapInABlock"));
        }
        return jetBlockExpression;
    }

    public static class WhenBuilder {
        private final StringBuilder sb = new StringBuilder("when ");
        private boolean frozen = false;
        private boolean inCondition = false;

        public WhenBuilder() {
            this((String)null);
        }

        public WhenBuilder(@Nullable String subjectText) {
            if (subjectText != null) {
                this.sb.append("(").append(subjectText).append(") ");
            }
            this.sb.append("{\n");
        }

        public WhenBuilder(@Nullable JetExpression subject) {
            this(subject != null ? subject.getText() : null);
        }

        @NotNull
        public WhenBuilder condition(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "condition"));
            }
            assert (!this.frozen);
            if (!this.inCondition) {
                this.inCondition = true;
            } else {
                this.sb.append(", ");
            }
            this.sb.append(text);
            WhenBuilder whenBuilder = this;
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "condition"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder condition(@Nullable JetExpression expression) {
            WhenBuilder whenBuilder = this.condition(JetPsiUtil.getText(expression));
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "condition"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder pattern(@NotNull String typeReferenceText, boolean negated) {
            if (typeReferenceText == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "pattern"));
            }
            WhenBuilder whenBuilder = this.condition((negated ? "!is" : "is") + " " + typeReferenceText);
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "pattern"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder pattern(@Nullable JetTypeReference typeReference, boolean negated) {
            WhenBuilder whenBuilder = this.pattern(JetPsiUtil.getText(typeReference), negated);
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "pattern"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder range(@NotNull String argumentText, boolean negated) {
            if (argumentText == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "range"));
            }
            WhenBuilder whenBuilder = this.condition((negated ? "!in" : "in") + " " + argumentText);
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "range"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder range(@Nullable JetExpression argument, boolean negated) {
            WhenBuilder whenBuilder = this.range(JetPsiUtil.getText(argument), negated);
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "range"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder branchExpression(@NotNull String expressionText) {
            if (expressionText == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "branchExpression"));
            }
            assert (!this.frozen);
            assert (this.inCondition);
            this.inCondition = false;
            this.sb.append(" -> ").append(expressionText).append("\n");
            WhenBuilder whenBuilder = this;
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "branchExpression"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder branchExpression(@Nullable JetExpression expression) {
            WhenBuilder whenBuilder = this.branchExpression(JetPsiUtil.getText(expression));
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "branchExpression"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder entry(@NotNull String entryText) {
            if (entryText == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "entry"));
            }
            assert (!this.frozen);
            assert (!this.inCondition);
            this.sb.append(entryText).append("\n");
            WhenBuilder whenBuilder = this;
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "entry"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder entry(@Nullable JetWhenEntry whenEntry) {
            WhenBuilder whenBuilder = this.entry(JetPsiUtil.getText(whenEntry));
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "entry"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder elseEntry(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "elseEntry"));
            }
            WhenBuilder whenBuilder = this.entry("else -> " + text);
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "elseEntry"));
            }
            return whenBuilder;
        }

        @NotNull
        public WhenBuilder elseEntry(@Nullable JetExpression expression) {
            WhenBuilder whenBuilder = this.elseEntry(JetPsiUtil.getText(expression));
            if (whenBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "elseEntry"));
            }
            return whenBuilder;
        }

        @NotNull
        public JetWhenExpression toExpression(Project project) {
            if (!this.frozen) {
                this.sb.append("}");
                this.frozen = true;
            }
            JetWhenExpression jetWhenExpression = (JetWhenExpression)JetPsiFactory.createExpression(project, this.sb.toString());
            if (jetWhenExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$WhenBuilder", "toExpression"));
            }
            return jetWhenExpression;
        }
    }

    public static class IfChainBuilder {
        private final StringBuilder sb = new StringBuilder();
        private boolean first = true;
        private boolean frozen = false;

        @NotNull
        public IfChainBuilder ifBranch(@NotNull String conditionText, @NotNull String expressionText) {
            if (conditionText == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "ifBranch"));
            }
            if (expressionText == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "ifBranch"));
            }
            if (this.first) {
                this.first = false;
            } else {
                this.sb.append("else ");
            }
            this.sb.append("if (").append(conditionText).append(") ").append(expressionText).append("\n");
            IfChainBuilder ifChainBuilder = this;
            if (ifChainBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "ifBranch"));
            }
            return ifChainBuilder;
        }

        @NotNull
        public IfChainBuilder ifBranch(@NotNull JetExpression condition, @NotNull JetExpression expression) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "ifBranch"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "ifBranch"));
            }
            IfChainBuilder ifChainBuilder = this.ifBranch(condition.getText(), expression.getText());
            if (ifChainBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "ifBranch"));
            }
            return ifChainBuilder;
        }

        @NotNull
        public IfChainBuilder elseBranch(@NotNull String expressionText) {
            if (expressionText == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "elseBranch"));
            }
            this.sb.append("else ").append(expressionText);
            IfChainBuilder ifChainBuilder = this;
            if (ifChainBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "elseBranch"));
            }
            return ifChainBuilder;
        }

        @NotNull
        public IfChainBuilder elseBranch(@Nullable JetExpression expression) {
            IfChainBuilder ifChainBuilder = this.elseBranch(JetPsiUtil.getText(expression));
            if (ifChainBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "elseBranch"));
            }
            return ifChainBuilder;
        }

        @NotNull
        public JetIfExpression toExpression(Project project) {
            if (!this.frozen) {
                this.frozen = true;
            }
            JetIfExpression jetIfExpression = (JetIfExpression)JetPsiFactory.createExpression(project, this.sb.toString());
            if (jetIfExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiFactory$IfChainBuilder", "toExpression"));
            }
            return jetIfExpression;
        }
    }
}

