/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetElementImplStub;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.psi.stubs.PsiJetAnnotationStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetAnnotationElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;

public class JetAnnotationEntry
extends JetElementImplStub<PsiJetAnnotationStub>
implements JetCallElement {
    public JetAnnotationEntry(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public IStubElementType getElementType() {
        JetAnnotationElementType jetAnnotationElementType = JetStubElementTypes.ANNOTATION_ENTRY;
        if (jetAnnotationElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "getElementType"));
        }
        return jetAnnotationElementType;
    }

    public JetAnnotationEntry(@NotNull PsiJetAnnotationStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "<init>"));
        }
        super(stub, JetStubElementTypes.ANNOTATION_ENTRY);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "accept"));
        }
        visitor.visitAnnotationEntry(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "accept"));
        }
        return visitor.visitAnnotationEntry(this, data);
    }

    @IfNotParsed
    @Nullable
    public JetTypeReference getTypeReference() {
        JetConstructorCalleeExpression calleeExpression = this.getCalleeExpression();
        if (calleeExpression == null) {
            return null;
        }
        return calleeExpression.getTypeReference();
    }

    @Override
    public JetConstructorCalleeExpression getCalleeExpression() {
        return (JetConstructorCalleeExpression)this.findChildByType(JetNodeTypes.CONSTRUCTOR_CALLEE);
    }

    @Override
    public JetValueArgumentList getValueArgumentList() {
        return (JetValueArgumentList)this.findChildByType(JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        JetValueArgumentList list = this.getValueArgumentList();
        List<Object> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "getValueArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JetExpression> getFunctionLiteralArguments() {
        List<JetExpression> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "getFunctionLiteralArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        JetTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        if (typeArgumentList == null) {
            List<JetTypeProjection> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "getTypeArguments"));
            }
            return list;
        }
        List<JetTypeProjection> list = typeArgumentList.getArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetAnnotationEntry", "getTypeArguments"));
        }
        return list;
    }

    @Override
    public JetTypeArgumentList getTypeArgumentList() {
        JetTypeReference typeReference = this.getTypeReference();
        if (typeReference == null) {
            return null;
        }
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof JetUserType) {
            JetUserType userType = (JetUserType)typeElement;
            return userType.getTypeArgumentList();
        }
        return null;
    }
}

