/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements ValueParameterDescriptor {
    private Boolean hasDefaultValue;
    private final boolean declaresDefaultValue;
    private final JetType varargElementType;
    private final int index;
    private final ValueParameterDescriptor original;
    private final Set<ValueParameterDescriptor> overriddenDescriptors;
    private boolean overriddenDescriptorsLocked;
    private final Set<? extends ValueParameterDescriptor> readOnlyOverriddenDescriptors;

    public ValueParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, int index, @NotNull List<AnnotationDescriptor> annotations, @NotNull Name name, @NotNull JetType outType, boolean declaresDefaultValue, @Nullable JetType varargElementType) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations, name, outType);
        this.overriddenDescriptors = Sets.newLinkedHashSet();
        this.overriddenDescriptorsLocked = false;
        this.readOnlyOverriddenDescriptors = Collections.unmodifiableSet(this.overriddenDescriptors);
        this.original = this;
        this.index = index;
        this.declaresDefaultValue = declaresDefaultValue;
        this.varargElementType = varargElementType;
    }

    public ValueParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull ValueParameterDescriptor original, @NotNull List<AnnotationDescriptor> annotations, @NotNull JetType outType, @Nullable JetType varargElementType) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        if (outType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations, original.getName(), outType);
        this.overriddenDescriptors = Sets.newLinkedHashSet();
        this.overriddenDescriptorsLocked = false;
        this.readOnlyOverriddenDescriptors = Collections.unmodifiableSet(this.overriddenDescriptors);
        this.original = original;
        this.index = original.getIndex();
        this.declaresDefaultValue = original.declaresDefaultValue();
        this.varargElementType = varargElementType;
    }

    public void setType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "setType"));
        }
        this.setOutType(type);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasDefaultValue() {
        this.computeDefaultValuePresence();
        return this.hasDefaultValue;
    }

    @Override
    public boolean declaresDefaultValue() {
        return this.declaresDefaultValue && ((CallableMemberDescriptor)this.getContainingDeclaration()).getKind().isReal();
    }

    private void computeDefaultValuePresence() {
        if (this.hasDefaultValue != null) {
            return;
        }
        this.overriddenDescriptorsLocked = true;
        if (this.declaresDefaultValue) {
            this.hasDefaultValue = true;
        } else {
            for (ValueParameterDescriptor descriptor : this.overriddenDescriptors) {
                if (!descriptor.hasDefaultValue()) continue;
                this.hasDefaultValue = true;
                return;
            }
            this.hasDefaultValue = false;
        }
    }

    @Override
    @Nullable
    public JetType getVarargElementType() {
        return this.varargElementType;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor getOriginal() {
        ValueParameterDescriptor valueParameterDescriptor = this.original == this ? this : this.original.getOriginal();
        if (valueParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "getOriginal"));
        }
        return valueParameterDescriptor;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "substitute"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitValueParameterDescriptor(this, data);
    }

    @Override
    public boolean isVar() {
        return false;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor copy(@NotNull DeclarationDescriptor newOwner, @NotNull Name newName) {
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(newOwner, this.index, Lists.newArrayList(this.getAnnotations()), newName, this.getType(), this.declaresDefaultValue(), this.varargElementType);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "copy"));
        }
        return valueParameterDescriptorImpl;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = Visibilities.LOCAL;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @NotNull
    public Set<? extends ValueParameterDescriptor> getOverriddenDescriptors() {
        Set<? extends ValueParameterDescriptor> set = this.readOnlyOverriddenDescriptors;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "getOverriddenDescriptors"));
        }
        return set;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull ValueParameterDescriptor overridden) {
        if (overridden == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/ValueParameterDescriptorImpl", "addOverriddenDescriptor"));
        }
        assert (!this.overriddenDescriptorsLocked) : "Adding more overridden descriptors is not allowed at this point: the presence of the default value has already been calculated";
        this.overriddenDescriptors.add(overridden);
    }
}

