/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;

public class ReturnValueInstruction
extends AbstractJumpInstruction
implements JetElementInstruction {
    private final JetElement element;

    public ReturnValueInstruction(@NotNull JetExpression returnExpression, @NotNull Label targetLabel) {
        if (returnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnValueInstruction", "<init>"));
        }
        if (targetLabel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnValueInstruction", "<init>"));
        }
        super(targetLabel);
        this.element = returnExpression;
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitReturnValue(this);
    }

    public String toString() {
        return "ret(*) " + this.getTargetLabel();
    }

    @Override
    @NotNull
    public JetElement getElement() {
        JetElement jetElement = this.element;
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnValueInstruction", "getElement"));
        }
        return jetElement;
    }

    @Override
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel) {
        if (newLabel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnValueInstruction", "createCopy"));
        }
        return new ReturnValueInstruction((JetExpression)this.element, newLabel);
    }
}

