/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public final class PsiCodegenPredictor {
    private PsiCodegenPredictor() {
    }

    public static boolean checkPredictedNameFromPsi(@NotNull BindingTrace bindingTrace, @NotNull DeclarationDescriptor descriptor, JvmClassName nameFromDescriptors) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        PsiElement element = BindingContextUtils.descriptorToDeclaration(bindingTrace.getBindingContext(), descriptor);
        if (element instanceof JetDeclaration) {
            JvmClassName classNameFromPsi = PsiCodegenPredictor.getPredefinedJvmClassName((JetDeclaration)element);
            assert (classNameFromPsi == null || classNameFromPsi.equals(nameFromDescriptors)) : String.format("Invalid algorithm for getting qualified name from psi! Predicted: %s, actual %s\nElement: %s", classNameFromPsi, nameFromDescriptors, element.getText());
        }
        return true;
    }

    @Nullable
    public static JvmClassName getPredefinedJvmClassName(@NotNull JetFile jetFile, boolean withNamespace) {
        if (jetFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmClassName"));
        }
        String packageName = jetFile.getPackageName();
        if (packageName == null) {
            return null;
        }
        JvmClassName packageJvmName = JvmClassName.byFqNameWithoutInnerClasses(packageName);
        return !withNamespace ? packageJvmName : PsiCodegenPredictor.addPackageClass(packageJvmName);
    }

    @Nullable
    public static JvmClassName getPredefinedJvmClassName(@NotNull JetDeclaration declaration) {
        JvmClassName parentClassName;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmClassName"));
        }
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)declaration, JetDeclaration.class);
        if (parentDeclaration instanceof JetClassObject) {
            assert (declaration instanceof JetObjectDeclaration) : "Only object declarations can be children of JetClassObject: " + declaration;
            return PsiCodegenPredictor.getPredefinedJvmClassName(parentDeclaration);
        }
        JvmClassName jvmClassName = parentClassName = parentDeclaration != null ? PsiCodegenPredictor.getPredefinedJvmClassName(parentDeclaration) : PsiCodegenPredictor.getPredefinedJvmClassName((JetFile)declaration.getContainingFile(), false);
        if (parentClassName == null) {
            return null;
        }
        if (declaration instanceof JetClassObject) {
            return JvmClassName.byInternalName(parentClassName.getInternalName() + "$object");
        }
        if (declaration instanceof JetNamedDeclaration) {
            if (!PsiTreeUtil.instanceOf(declaration, JetClass.class, JetObjectDeclaration.class, JetNamedFunction.class, JetProperty.class) || declaration instanceof JetEnumEntry) {
                return null;
            }
            JetNamedDeclaration namedDeclaration = (JetNamedDeclaration)declaration;
            Name name = namedDeclaration.getNameAsName();
            if (name == null) {
                return null;
            }
            FqName fqName = parentClassName.getFqName();
            if (declaration instanceof JetNamedFunction) {
                if (parentDeclaration == null) {
                    JvmClassName packageClass = PsiCodegenPredictor.addPackageClass(parentClassName);
                    return JvmClassName.byInternalName(packageClass.getInternalName() + "$" + name.asString());
                }
                if (!(parentDeclaration instanceof JetClass) && !(parentDeclaration instanceof JetObjectDeclaration)) {
                    return null;
                }
            }
            if (declaration instanceof JetProperty) {
                return JvmClassName.byInternalName(parentClassName.getInternalName() + "$" + name.asString());
            }
            if (fqName.isRoot()) {
                return JvmClassName.byInternalName(name.asString());
            }
            return JvmClassName.byInternalName(parentDeclaration == null ? parentClassName.getInternalName() + "/" + name.asString() : parentClassName.getInternalName() + "$" + name.asString());
        }
        return null;
    }

    private static JvmClassName addPackageClass(JvmClassName packageName) {
        FqName name = packageName.getFqName();
        String packageClassName = PackageClassUtils.getPackageClassName(name);
        return name.isRoot() ? JvmClassName.byFqNameWithoutInnerClasses(packageClassName) : JvmClassName.byInternalName(packageName.getInternalName() + "/" + packageClassName);
    }

    public static boolean checkPredictedClassNameForFun(BindingContext bindingContext, @NotNull DeclarationDescriptor descriptor, ClassDescriptor classDescriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "checkPredictedClassNameForFun"));
        }
        PsiElement element = BindingContextUtils.descriptorToDeclaration(bindingContext, descriptor);
        PsiElement classDeclaration = BindingContextUtils.descriptorToDeclaration(bindingContext, classDescriptor);
        if (element instanceof JetNamedFunction && classDeclaration instanceof JetDeclaration) {
            JvmClassName classNameFromPsi = PsiCodegenPredictor.getPredefinedJvmClassName((JetDeclaration)classDeclaration);
            JvmClassName classNameForFun = PsiCodegenPredictor.getPredefinedJvmClassNameForFun((JetNamedFunction)element);
            assert (classNameForFun == null || classNameForFun.equals(classNameFromPsi)) : "Invalid algorithm for getting enclosing method name!";
        }
        return true;
    }

    @Nullable
    public static JvmClassName getPredefinedJvmClassNameForFun(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmClassNameForFun"));
        }
        PsiElement parent = function.getParent();
        if (parent instanceof JetFile) {
            return PsiCodegenPredictor.getPredefinedJvmClassName((JetFile)parent, true);
        }
        JetClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)function, JetClass.class, true, JetDeclaration.class);
        if (containingClass != null) {
            return PsiCodegenPredictor.getPredefinedJvmClassName(containingClass);
        }
        JetObjectDeclaration objectDeclaration = PsiTreeUtil.getParentOfType((PsiElement)function, JetObjectDeclaration.class, true, JetDeclaration.class);
        if (objectDeclaration != null) {
            if (objectDeclaration.getParent() instanceof JetClassObject) {
                return PsiCodegenPredictor.getPredefinedJvmClassName((JetClassObject)objectDeclaration.getParent());
            }
            return PsiCodegenPredictor.getPredefinedJvmClassName(objectDeclaration);
        }
        return null;
    }

    @Nullable
    public static JetFile getFileForNamespacePartName(@NotNull Collection<JetFile> allNamespaceFiles, @NotNull JvmClassName className) {
        if (allNamespaceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForNamespacePartName"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForNamespacePartName"));
        }
        for (JetFile file : allNamespaceFiles) {
            String internalName = NamespaceCodegen.getNamespacePartInternalName(file);
            JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
            if (!jvmClassName.equals(className)) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public static JetFile getFileForCodegenNamedClass(@NotNull BindingContext context, @NotNull Collection<JetFile> allNamespaceFiles, final @NotNull JvmClassName className) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        if (allNamespaceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        final Ref resultingDescriptor = Ref.create();
        DelegatingBindingTrace trace = new DelegatingBindingTrace(context, "trace in PsiCodegenPredictor"){

            @Override
            public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
                super.record(slice, key, value);
                if (slice == CodegenBinding.FQN && key instanceof DeclarationDescriptor && className.equals(value)) {
                    resultingDescriptor.set((DeclarationDescriptor)key);
                }
            }
        };
        CodegenBinding.initTrace(trace, allNamespaceFiles);
        return resultingDescriptor.isNull() ? null : BindingContextUtils.getContainingFile(trace.getBindingContext(), (DeclarationDescriptor)resultingDescriptor.get());
    }
}

