/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InferenceVariable {
    private boolean myCaptured;
    private Map<InferenceBound, List<PsiType>> myBounds = new HashMap<InferenceBound, List<PsiType>>();
    private PsiTypeParameter myParameter;
    private PsiType myInstantiation = PsiType.NULL;

    public PsiTypeParameter getParameter() {
        return this.myParameter;
    }

    public InferenceVariable(PsiTypeParameter parameter) {
        this.myParameter = parameter;
    }

    public PsiType getInstantiation() {
        return this.myInstantiation;
    }

    public void setInstantiation(PsiType instantiation) {
        this.myInstantiation = instantiation;
    }

    public boolean isCaptured() {
        return this.myCaptured;
    }

    public void setCaptured(boolean captured) {
        this.myCaptured = captured;
    }

    public boolean addBound(PsiType classType, InferenceBound inferenceBound) {
        int idx;
        List<PsiType> list = this.myBounds.get((Object)inferenceBound);
        if (list == null) {
            list = new ArrayList<PsiType>();
            this.myBounds.put(inferenceBound, list);
        }
        if ((idx = list.indexOf(classType)) < 0 || inferenceBound == InferenceBound.EQ && classType instanceof PsiCapturedWildcardType && list.get(idx) != classType) {
            list.add(classType);
            return true;
        }
        return false;
    }

    public List<PsiType> getBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? new ArrayList<PsiType>(bounds) : Collections.emptyList();
    }
}

