/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;

public final class ErrorReportingUtils {
    private ErrorReportingUtils() {
    }

    @NotNull
    public static RuntimeException reportErrorWithLocation(@NotNull JetExpression selector, @NotNull RuntimeException e) {
        return ErrorReportingUtils.reportErrorWithLocation(e, DiagnosticUtils.atLocation(selector));
    }

    @NotNull
    private static RuntimeException reportErrorWithLocation(@NotNull RuntimeException e, @NotNull String location) {
        throw new RuntimeException(e.getMessage() + " at " + location, e);
    }

    @NotNull
    public static String message(@NotNull PsiElement expression, @NotNull String messageText) {
        return messageText + " at " + DiagnosticUtils.atLocation(expression) + ".";
    }

    @NotNull
    public static String message(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor, @NotNull String explainingMessage) {
        return explainingMessage + " at " + DiagnosticUtils.atLocation(context, descriptor) + ".";
    }

    @NotNull
    public static String message(@NotNull PsiElement element) {
        return "Error at " + DiagnosticUtils.atLocation(element) + ".";
    }

    @NotNull
    public static RuntimeException reportErrorWithLocation(@NotNull RuntimeException e, @NotNull DeclarationDescriptor descriptor, @NotNull BindingContext bindingContext) {
        throw ErrorReportingUtils.reportErrorWithLocation(e, DiagnosticUtils.atLocation(bindingContext, descriptor));
    }
}

