/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class BackingFieldAccessTranslator
extends AbstractTranslator
implements CachedAccessTranslator {
    @NotNull
    private final PropertyDescriptor descriptor;

    static BackingFieldAccessTranslator newInstance(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        assert (JetPsiUtil.isBackingFieldReference(expression));
        DeclarationDescriptor referencedProperty = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression);
        assert (referencedProperty instanceof PropertyDescriptor);
        return new BackingFieldAccessTranslator((PropertyDescriptor)referencedProperty, context);
    }

    private BackingFieldAccessTranslator(@NotNull PropertyDescriptor descriptor, @NotNull TranslationContext context) {
        super(context);
        this.descriptor = descriptor;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return TranslationUtils.backingFieldReference(this.context(), this.descriptor);
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        return TranslationUtils.assignmentToBackingField(this.context(), this.descriptor, setTo);
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        return this;
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        return Collections.emptyList();
    }
}

