/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class InitializerUtils {
    private InitializerUtils() {
    }

    @NotNull
    public static JsStatement generateInitializerForProperty(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor, @NotNull JsExpression value) {
        if (context.isEcma5()) {
            return JsAstUtils.definePropertyDataDescriptor(descriptor, value, context).makeStmt();
        }
        return TranslationUtils.assignmentToBackingField(context, descriptor, value).makeStmt();
    }

    @Nullable
    public static JsStatement generateInitializerForDelegate(@NotNull TranslationContext context, @NotNull JetProperty property) {
        JetExpression delegate = property.getDelegateExpression();
        if (delegate != null) {
            JsExpression value = Translation.translateAsExpression(delegate, context);
            String name = property.getName();
            assert (name != null) : "Delegate property must have name";
            return JsAstUtils.defineSimpleProperty(Namer.getDelegateName(name), value, context);
        }
        return null;
    }

    public static void generate(@NotNull JetObjectDeclaration declaration, @NotNull List<JsStatement> initializers, @NotNull TranslationContext context) {
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(context.bindingContext(), declaration);
        JsExpression value = ClassTranslator.generateObjectLiteral(declaration, descriptor, context);
        initializers.add(InitializerUtils.create(descriptor, !(descriptor.getContainingDeclaration() instanceof NamespaceDescriptor), value, context));
    }

    private static JsStatement create(DeclarationDescriptor descriptor, boolean enumerable, JsExpression value, TranslationContext context) {
        JsExpression expression = context.isEcma5() ? JsAstUtils.defineProperty(descriptor.getName().asString(), JsAstUtils.createDataDescriptor(value, false, enumerable), context) : JsAstUtils.assignment(new JsNameRef(descriptor.getName().asString(), (JsExpression)JsLiteral.THIS), value);
        return expression.makeStmt();
    }

    public static JsExpression toDataDescriptor(JsExpression value, TranslationContext context) {
        return context.isEcma5() ? JsAstUtils.createDataDescriptor(value) : value;
    }

    public static JsPropertyInitializer createPropertyInitializer(Named named, JsExpression value, TranslationContext context) {
        return new JsPropertyInitializer(context.nameToLiteral(named), InitializerUtils.toDataDescriptor(value, context));
    }
}

