/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lexer;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.kdoc.lexer.KDocTokens;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetToken;

public interface JetTokens {
    public static final JetToken EOF = new JetToken("EOF");
    public static final JetToken BLOCK_COMMENT = new JetToken("BLOCK_COMMENT");
    public static final JetToken EOL_COMMENT = new JetToken("EOL_COMMENT");
    public static final JetToken SHEBANG_COMMENT = new JetToken("SHEBANG_COMMENT");
    public static final IElementType DOC_COMMENT = KDocTokens.KDOC;
    public static final IElementType WHITE_SPACE = TokenType.WHITE_SPACE;
    public static final JetToken INTEGER_LITERAL = new JetToken("INTEGER_LITERAL");
    public static final JetToken FLOAT_LITERAL = new JetToken("FLOAT_CONSTANT");
    public static final JetToken CHARACTER_LITERAL = new JetToken("CHARACTER_LITERAL");
    public static final JetToken CLOSING_QUOTE = new JetToken("CLOSING_QUOTE");
    public static final JetToken OPEN_QUOTE = new JetToken("OPEN_QUOTE");
    public static final JetToken REGULAR_STRING_PART = new JetToken("REGULAR_STRING_PART");
    public static final JetToken ESCAPE_SEQUENCE = new JetToken("ESCAPE_SEQUENCE");
    public static final JetToken SHORT_TEMPLATE_ENTRY_START = new JetToken("SHORT_TEMPLATE_ENTRY_START");
    public static final JetToken LONG_TEMPLATE_ENTRY_START = new JetToken("LONG_TEMPLATE_ENTRY_START");
    public static final JetToken LONG_TEMPLATE_ENTRY_END = new JetToken("LONG_TEMPLATE_ENTRY_END");
    public static final JetToken DANGLING_NEWLINE = new JetToken("DANGLING_NEWLINE");
    public static final JetKeywordToken PACKAGE_KEYWORD = JetKeywordToken.keyword("package");
    public static final JetKeywordToken AS_KEYWORD = JetKeywordToken.keyword("as");
    public static final JetKeywordToken TYPE_KEYWORD = JetKeywordToken.keyword("type");
    public static final JetKeywordToken CLASS_KEYWORD = JetKeywordToken.keyword("class");
    public static final JetKeywordToken THIS_KEYWORD = JetKeywordToken.keyword("this");
    public static final JetKeywordToken SUPER_KEYWORD = JetKeywordToken.keyword("super");
    public static final JetKeywordToken VAL_KEYWORD = JetKeywordToken.keyword("val");
    public static final JetKeywordToken VAR_KEYWORD = JetKeywordToken.keyword("var");
    public static final JetKeywordToken FUN_KEYWORD = JetKeywordToken.keyword("fun");
    public static final JetKeywordToken FOR_KEYWORD = JetKeywordToken.keyword("for");
    public static final JetKeywordToken NULL_KEYWORD = JetKeywordToken.keyword("null");
    public static final JetKeywordToken TRUE_KEYWORD = JetKeywordToken.keyword("true");
    public static final JetKeywordToken FALSE_KEYWORD = JetKeywordToken.keyword("false");
    public static final JetKeywordToken IS_KEYWORD = JetKeywordToken.keyword("is");
    public static final JetKeywordToken IN_KEYWORD = JetKeywordToken.keyword("in");
    public static final JetKeywordToken THROW_KEYWORD = JetKeywordToken.keyword("throw");
    public static final JetKeywordToken RETURN_KEYWORD = JetKeywordToken.keyword("return");
    public static final JetKeywordToken BREAK_KEYWORD = JetKeywordToken.keyword("break");
    public static final JetKeywordToken CONTINUE_KEYWORD = JetKeywordToken.keyword("continue");
    public static final JetKeywordToken OBJECT_KEYWORD = JetKeywordToken.keyword("object");
    public static final JetKeywordToken IF_KEYWORD = JetKeywordToken.keyword("if");
    public static final JetKeywordToken TRY_KEYWORD = JetKeywordToken.keyword("try");
    public static final JetKeywordToken ELSE_KEYWORD = JetKeywordToken.keyword("else");
    public static final JetKeywordToken WHILE_KEYWORD = JetKeywordToken.keyword("while");
    public static final JetKeywordToken DO_KEYWORD = JetKeywordToken.keyword("do");
    public static final JetKeywordToken WHEN_KEYWORD = JetKeywordToken.keyword("when");
    public static final JetKeywordToken TRAIT_KEYWORD = JetKeywordToken.keyword("trait");
    public static final JetKeywordToken CAPITALIZED_THIS_KEYWORD = JetKeywordToken.keyword("This");
    public static final JetToken AS_SAFE = JetKeywordToken.keyword("AS_SAFE");
    public static final JetToken IDENTIFIER = new JetToken("IDENTIFIER");
    public static final JetToken LABEL_IDENTIFIER = new JetToken("LABEL_IDENTIFIER");
    public static final JetToken FIELD_IDENTIFIER = new JetToken("FIELD_IDENTIFIER");
    public static final JetToken LBRACKET = new JetToken("LBRACKET");
    public static final JetToken RBRACKET = new JetToken("RBRACKET");
    public static final JetToken LBRACE = new JetToken("LBRACE");
    public static final JetToken RBRACE = new JetToken("RBRACE");
    public static final JetToken LPAR = new JetToken("LPAR");
    public static final JetToken RPAR = new JetToken("RPAR");
    public static final JetToken DOT = new JetToken("DOT");
    public static final JetToken PLUSPLUS = new JetToken("PLUSPLUS");
    public static final JetToken MINUSMINUS = new JetToken("MINUSMINUS");
    public static final JetToken MUL = new JetToken("MUL");
    public static final JetToken PLUS = new JetToken("PLUS");
    public static final JetToken MINUS = new JetToken("MINUS");
    public static final JetToken EXCL = new JetToken("EXCL");
    public static final JetToken DIV = new JetToken("DIV");
    public static final JetToken PERC = new JetToken("PERC");
    public static final JetToken LT = new JetToken("LT");
    public static final JetToken GT = new JetToken("GT");
    public static final JetToken LTEQ = new JetToken("LTEQ");
    public static final JetToken GTEQ = new JetToken("GTEQ");
    public static final JetToken EQEQEQ = new JetToken("EQEQEQ");
    public static final JetToken ARROW = new JetToken("ARROW");
    public static final JetToken DOUBLE_ARROW = new JetToken("DOUBLE_ARROW");
    public static final JetToken EXCLEQEQEQ = new JetToken("EXCLEQEQEQ");
    public static final JetToken EQEQ = new JetToken("EQEQ");
    public static final JetToken EXCLEQ = new JetToken("EXCLEQ");
    public static final JetToken EXCLEXCL = new JetToken("EXCLEXCL");
    public static final JetToken ANDAND = new JetToken("ANDAND");
    public static final JetToken OROR = new JetToken("OROR");
    public static final JetToken SAFE_ACCESS = new JetToken("SAFE_ACCESS");
    public static final JetToken ELVIS = new JetToken("ELVIS");
    public static final JetToken QUEST = new JetToken("QUEST");
    public static final JetToken COLONCOLON = new JetToken("COLONCOLON");
    public static final JetToken COLON = new JetToken("COLON");
    public static final JetToken SEMICOLON = new JetToken("SEMICOLON");
    public static final JetToken RANGE = new JetToken("RANGE");
    public static final JetToken EQ = new JetToken("EQ");
    public static final JetToken MULTEQ = new JetToken("MULTEQ");
    public static final JetToken DIVEQ = new JetToken("DIVEQ");
    public static final JetToken PERCEQ = new JetToken("PERCEQ");
    public static final JetToken PLUSEQ = new JetToken("PLUSEQ");
    public static final JetToken MINUSEQ = new JetToken("MINUSEQ");
    public static final JetToken NOT_IN = JetKeywordToken.keyword("NOT_IN");
    public static final JetToken NOT_IS = JetKeywordToken.keyword("NOT_IS");
    public static final JetToken HASH = new JetToken("HASH");
    public static final JetToken AT = new JetToken("AT");
    public static final JetToken ATAT = new JetToken("ATAT");
    public static final JetToken IDE_TEMPLATE_START = new JetToken("IDE_TEMPLATE_START");
    public static final JetToken IDE_TEMPLATE_END = new JetToken("IDE_TEMPLATE_END");
    public static final TokenSet LABELS = TokenSet.create(AT, ATAT, LABEL_IDENTIFIER);
    public static final JetToken COMMA = new JetToken("COMMA");
    public static final JetToken EOL_OR_SEMICOLON = new JetToken("EOL_OR_SEMICOLON");
    public static final JetKeywordToken IMPORT_KEYWORD = JetKeywordToken.softKeyword("import");
    public static final JetKeywordToken WHERE_KEYWORD = JetKeywordToken.softKeyword("where");
    public static final JetKeywordToken BY_KEYWORD = JetKeywordToken.softKeyword("by");
    public static final JetKeywordToken GET_KEYWORD = JetKeywordToken.softKeyword("get");
    public static final JetKeywordToken SET_KEYWORD = JetKeywordToken.softKeyword("set");
    public static final JetKeywordToken ABSTRACT_KEYWORD = JetKeywordToken.softKeyword("abstract");
    public static final JetKeywordToken ENUM_KEYWORD = JetKeywordToken.softKeyword("enum");
    public static final JetKeywordToken OPEN_KEYWORD = JetKeywordToken.softKeyword("open");
    public static final JetKeywordToken INNER_KEYWORD = JetKeywordToken.softKeyword("inner");
    public static final JetKeywordToken ANNOTATION_KEYWORD = JetKeywordToken.softKeyword("annotation");
    public static final JetKeywordToken OVERRIDE_KEYWORD = JetKeywordToken.softKeyword("override");
    public static final JetKeywordToken PRIVATE_KEYWORD = JetKeywordToken.softKeyword("private");
    public static final JetKeywordToken PUBLIC_KEYWORD = JetKeywordToken.softKeyword("public");
    public static final JetKeywordToken INTERNAL_KEYWORD = JetKeywordToken.softKeyword("internal");
    public static final JetKeywordToken PROTECTED_KEYWORD = JetKeywordToken.softKeyword("protected");
    public static final JetKeywordToken CATCH_KEYWORD = JetKeywordToken.softKeyword("catch");
    public static final JetKeywordToken OUT_KEYWORD = JetKeywordToken.softKeyword("out");
    public static final JetKeywordToken VARARG_KEYWORD = JetKeywordToken.softKeyword("vararg");
    public static final JetKeywordToken INLINE_KEYWORD = JetKeywordToken.softKeyword("inline");
    public static final JetKeywordToken REIFIED_KEYWORD = JetKeywordToken.softKeyword("reified");
    public static final JetKeywordToken FINALLY_KEYWORD = JetKeywordToken.softKeyword("finally");
    public static final JetKeywordToken FINAL_KEYWORD = JetKeywordToken.softKeyword("final");
    public static final TokenSet KEYWORDS = TokenSet.create(PACKAGE_KEYWORD, AS_KEYWORD, TYPE_KEYWORD, CLASS_KEYWORD, TRAIT_KEYWORD, THIS_KEYWORD, SUPER_KEYWORD, VAL_KEYWORD, VAR_KEYWORD, FUN_KEYWORD, FOR_KEYWORD, NULL_KEYWORD, TRUE_KEYWORD, FALSE_KEYWORD, IS_KEYWORD, IN_KEYWORD, THROW_KEYWORD, RETURN_KEYWORD, BREAK_KEYWORD, CONTINUE_KEYWORD, OBJECT_KEYWORD, IF_KEYWORD, ELSE_KEYWORD, WHILE_KEYWORD, DO_KEYWORD, TRY_KEYWORD, WHEN_KEYWORD, NOT_IN, NOT_IS, CAPITALIZED_THIS_KEYWORD, AS_SAFE);
    public static final TokenSet SOFT_KEYWORDS = TokenSet.create(IMPORT_KEYWORD, WHERE_KEYWORD, BY_KEYWORD, GET_KEYWORD, SET_KEYWORD, ABSTRACT_KEYWORD, ENUM_KEYWORD, OPEN_KEYWORD, INNER_KEYWORD, ANNOTATION_KEYWORD, OVERRIDE_KEYWORD, PRIVATE_KEYWORD, PUBLIC_KEYWORD, INTERNAL_KEYWORD, PROTECTED_KEYWORD, CATCH_KEYWORD, FINALLY_KEYWORD, OUT_KEYWORD, FINAL_KEYWORD, VARARG_KEYWORD, INLINE_KEYWORD, REIFIED_KEYWORD);
    public static final TokenSet MODIFIER_KEYWORDS = TokenSet.create(ABSTRACT_KEYWORD, ENUM_KEYWORD, OPEN_KEYWORD, INNER_KEYWORD, ANNOTATION_KEYWORD, OVERRIDE_KEYWORD, PRIVATE_KEYWORD, PUBLIC_KEYWORD, INTERNAL_KEYWORD, PROTECTED_KEYWORD, OUT_KEYWORD, IN_KEYWORD, FINAL_KEYWORD, VARARG_KEYWORD, INLINE_KEYWORD, REIFIED_KEYWORD);
    public static final TokenSet VISIBILITY_MODIFIERS = TokenSet.create(PRIVATE_KEYWORD, PUBLIC_KEYWORD, INTERNAL_KEYWORD, PROTECTED_KEYWORD);
    public static final TokenSet WHITESPACES = TokenSet.create(TokenType.WHITE_SPACE);
    public static final TokenSet COMMENTS = TokenSet.create(EOL_COMMENT, BLOCK_COMMENT, DOC_COMMENT, SHEBANG_COMMENT);
    public static final TokenSet WHITE_SPACE_OR_COMMENT_BIT_SET = TokenSet.orSet(COMMENTS, TokenSet.create(WHITE_SPACE));
    public static final TokenSet STRINGS = TokenSet.create(CHARACTER_LITERAL, REGULAR_STRING_PART);
    public static final TokenSet OPERATIONS = TokenSet.create(AS_KEYWORD, AS_SAFE, IS_KEYWORD, IN_KEYWORD, DOT, PLUSPLUS, MINUSMINUS, EXCLEXCL, MUL, PLUS, MINUS, EXCL, DIV, PERC, LT, GT, LTEQ, GTEQ, EQEQEQ, EXCLEQEQEQ, EQEQ, EXCLEQ, ANDAND, OROR, SAFE_ACCESS, ELVIS, COLON, RANGE, EQ, MULTEQ, DIVEQ, PERCEQ, PLUSEQ, MINUSEQ, NOT_IN, NOT_IS, IDENTIFIER, LABEL_IDENTIFIER, ATAT, AT);
    public static final TokenSet AUGMENTED_ASSIGNMENTS = TokenSet.create(PLUSEQ, MINUSEQ, MULTEQ, PERCEQ, DIVEQ);
    public static final TokenSet ALL_ASSIGNMENTS = TokenSet.create(EQ, PLUSEQ, MINUSEQ, MULTEQ, PERCEQ, DIVEQ);
}

