/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;

public class TypeUnifier {
    @NotNull
    public static UnificationResult unify(@NotNull TypeProjection knownProjection, @NotNull TypeProjection projectWithVariables, @NotNull Predicate<TypeConstructor> isVariable) {
        UnificationResultImpl result = new UnificationResultImpl();
        TypeUnifier.doUnify(knownProjection, projectWithVariables, isVariable, result);
        return result;
    }

    private static void doUnify(TypeProjection knownProjection, TypeProjection projectWithVariables, Predicate<TypeConstructor> isVariable, UnificationResultImpl result) {
        boolean structuralMismatch;
        Variance withVariablesProjectionKind;
        JetType known = knownProjection.getType();
        JetType withVariables = projectWithVariables.getType();
        Variance knownProjectionKind = knownProjection.getProjectionKind();
        if (knownProjectionKind == (withVariablesProjectionKind = projectWithVariables.getProjectionKind()) && knownProjectionKind != Variance.INVARIANT) {
            TypeUnifier.doUnify(new TypeProjection(known), new TypeProjection(withVariables), isVariable, result);
            return;
        }
        if (known.isNullable() && withVariables.isNullable()) {
            TypeUnifier.doUnify(new TypeProjection(knownProjectionKind, TypeUtils.makeNotNullable(known)), new TypeProjection(withVariablesProjectionKind, TypeUtils.makeNotNullable(withVariables)), isVariable, result);
            return;
        }
        if (knownProjectionKind != withVariablesProjectionKind && withVariablesProjectionKind != Variance.INVARIANT) {
            result.fail();
            return;
        }
        if (!known.isNullable() && withVariables.isNullable()) {
            result.fail();
            return;
        }
        TypeConstructor maybeVariable = withVariables.getConstructor();
        if (isVariable.apply(maybeVariable)) {
            result.put(maybeVariable, new TypeProjection(knownProjectionKind, known));
            return;
        }
        boolean bl = structuralMismatch = known.isNullable() != withVariables.isNullable() || knownProjectionKind != withVariablesProjectionKind || !known.getConstructor().equals(withVariables.getConstructor());
        if (structuralMismatch) {
            result.fail();
            return;
        }
        if (known.getArguments().size() != withVariables.getArguments().size()) {
            result.fail();
            return;
        }
        if (known.getArguments().isEmpty()) {
            return;
        }
        List<TypeProjection> knownArguments = known.getArguments();
        List<TypeProjection> withVariablesArguments = withVariables.getArguments();
        for (int i = 0; i < knownArguments.size(); ++i) {
            TypeProjection knownArg = knownArguments.get(i);
            TypeProjection withVariablesArg = withVariablesArguments.get(i);
            TypeUnifier.doUnify(knownArg, withVariablesArg, isVariable, result);
        }
    }

    private static class UnificationResultImpl
    implements UnificationResult {
        private boolean success = true;
        private final Map<TypeConstructor, TypeProjection> substitution = Maps.newHashMapWithExpectedSize(1);
        private final Set<TypeConstructor> failedVariables = Sets.newHashSetWithExpectedSize(0);

        private UnificationResultImpl() {
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        public void fail() {
            this.success = false;
        }

        @Override
        @NotNull
        public Map<TypeConstructor, TypeProjection> getSubstitution() {
            return this.substitution;
        }

        public void put(TypeConstructor key, TypeProjection value) {
            if (this.failedVariables.contains(key)) {
                return;
            }
            TypeProjection oldValue = this.substitution.put(key, value);
            if (oldValue != null && !oldValue.equals(value)) {
                this.substitution.remove(key);
                this.failedVariables.add(key);
                this.fail();
            }
        }
    }

    public static interface UnificationResult {
        public boolean isSuccess();

        @NotNull
        public Map<TypeConstructor, TypeProjection> getSubstitution();
    }
}

