/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.utils.DFS;

public class CommonSupertypes {
    @NotNull
    public static JetType commonSupertype(@NotNull Collection<JetType> types) {
        assert (!types.isEmpty());
        HashSet<JetType> typeSet = new HashSet<JetType>(types);
        if (typeSet.size() == 1) {
            return (JetType)typeSet.iterator().next();
        }
        boolean nullable = false;
        Iterator iterator = typeSet.iterator();
        while (iterator.hasNext()) {
            JetType type = (JetType)iterator.next();
            assert (type != null);
            if (KotlinBuiltIns.getInstance().isNothingOrNullableNothing(type)) {
                iterator.remove();
            }
            if (ErrorUtils.isErrorType(type)) {
                return ErrorUtils.createErrorType("Supertype of error type " + type);
            }
            nullable |= type.isNullable();
        }
        if (typeSet.isEmpty()) {
            return nullable ? KotlinBuiltIns.getInstance().getNullableNothingType() : KotlinBuiltIns.getInstance().getNothingType();
        }
        if (typeSet.size() == 1) {
            return TypeUtils.makeNullableIfNeeded((JetType)typeSet.iterator().next(), nullable);
        }
        Map<TypeConstructor, Set<JetType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            HashSet<JetType> merge = new HashSet<JetType>();
            for (Set<JetType> supertypes : commonSupertypes.values()) {
                merge.addAll(supertypes);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        assert (!commonSupertypes.isEmpty()) : commonSupertypes + " <- " + types;
        Map.Entry<TypeConstructor, Set<JetType>> entry = commonSupertypes.entrySet().iterator().next();
        JetType result = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue());
        return TypeUtils.makeNullableIfNeeded(result, nullable);
    }

    @NotNull
    private static Map<TypeConstructor, Set<JetType>> computeCommonRawSupertypes(@NotNull Collection<JetType> types) {
        assert (!types.isEmpty());
        HashMap<TypeConstructor, Set<JetType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<JetType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (JetType type : types) {
            HashSet<TypeConstructor> visited = Sets.newHashSet();
            order = CommonSupertypes.topologicallySortSuperclassesAndRecordAllInstances(type, constructorToAllInstances, visited);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited;
                continue;
            }
            commonSuperclasses.retainAll(visited);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        HashMap<TypeConstructor, Set<JetType>> result = new HashMap<TypeConstructor, Set<JetType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result.put(superConstructor, (Set<JetType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        return result;
    }

    private static List<TypeConstructor> topologicallySortSuperclassesAndRecordAllInstances(@NotNull JetType type, final @NotNull Map<TypeConstructor, Set<JetType>> constructorToAllInstances, final @NotNull Set<TypeConstructor> visited) {
        return DFS.dfs(Collections.singletonList(type), new DFS.Neighbors<JetType>(){

            @Override
            @NotNull
            public Iterable<JetType> getNeighbors(JetType current) {
                TypeSubstitutor substitutor = TypeSubstitutor.create(current);
                ArrayList<JetType> result = Lists.newArrayList();
                for (JetType supertype : current.getConstructor().getSupertypes()) {
                    if (visited.contains(supertype.getConstructor())) continue;
                    result.add(substitutor.safeSubstitute(supertype, Variance.INVARIANT));
                }
                return result;
            }
        }, new DFS.Visited<JetType>(){

            @Override
            public boolean checkAndMarkVisited(JetType current) {
                return visited.add(current.getConstructor());
            }
        }, new DFS.NodeHandlerWithListResult<JetType, TypeConstructor>(){

            @Override
            public void beforeChildren(JetType current) {
                TypeConstructor constructor = current.getConstructor();
                HashSet<JetType> instances = (HashSet<JetType>)constructorToAllInstances.get(constructor);
                if (instances == null) {
                    instances = new HashSet<JetType>();
                    constructorToAllInstances.put(constructor, instances);
                }
                instances.add(current);
            }

            @Override
            public void afterChildren(JetType current) {
                this.result.addFirst(current.getConstructor());
            }
        });
    }

    @NotNull
    private static JetType computeSupertypeProjections(@NotNull TypeConstructor constructor, @NotNull Set<JetType> types) {
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return types.iterator().next();
        }
        List<TypeParameterDescriptor> parameters = constructor.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>();
        int parametersSize = parameters.size();
        for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters.get(i);
            HashSet<TypeProjection> typeProjections = new HashSet<TypeProjection>();
            for (JetType type : types) {
                typeProjections.add(type.getArguments().get(i));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(parameterDescriptor, typeProjections));
        }
        boolean nullable = false;
        for (JetType type : types) {
            nullable |= type.isNullable();
        }
        KotlinBuiltIns.getInstance();
        JetScope newScope = KotlinBuiltIns.STUB;
        ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            newScope = ((ClassDescriptor)declarationDescriptor).getMemberScope(newProjections);
        }
        return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), constructor, nullable, newProjections, newScope);
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections) {
        Variance projectionKind;
        if (typeProjections.size() == 1) {
            return typeProjections.iterator().next();
        }
        HashSet<JetType> ins = new HashSet<JetType>();
        HashSet<JetType> outs = new HashSet<JetType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind2 = projection.getProjectionKind();
            if (projectionKind2.allowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind2.allowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (ins != null) {
            JetType intersection = TypeUtils.intersect(JetTypeChecker.INSTANCE, ins);
            if (intersection == null) {
                if (outs != null) {
                    return new TypeProjection(Variance.OUT_VARIANCE, CommonSupertypes.commonSupertype(outs));
                }
                return new TypeProjection(Variance.OUT_VARIANCE, CommonSupertypes.commonSupertype(parameterDescriptor.getUpperBounds()));
            }
            Variance projectionKind3 = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            return new TypeProjection(projectionKind3, intersection);
        }
        if (outs != null) {
            projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            return new TypeProjection(projectionKind, CommonSupertypes.commonSupertype(outs));
        }
        projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        return new TypeProjection(projectionKind, CommonSupertypes.commonSupertype(parameterDescriptor.getUpperBounds()));
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor, @NotNull Set<TypeConstructor> markerSet) {
        markerSet.add(typeConstructor);
        for (JetType type : typeConstructor.getSupertypes()) {
            CommonSupertypes.markAll(type.getConstructor(), markerSet);
        }
    }
}

