/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameBase;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class FqNameUnsafe
extends FqNameBase {
    public static final Name ROOT_NAME = Name.special("<root>");
    @NotNull
    private final String fqName;
    private transient FqName safe;
    private transient FqNameUnsafe parent;
    private transient Name shortName;

    FqNameUnsafe(@NotNull String fqName, @NotNull FqName safe) {
        this.fqName = fqName;
        this.safe = safe;
        this.validateFqName();
    }

    public FqNameUnsafe(@NotNull String fqName) {
        this.fqName = fqName;
        this.validateFqName();
    }

    private FqNameUnsafe(@NotNull String fqName, FqNameUnsafe parent, Name shortName) {
        this.fqName = fqName;
        this.parent = parent;
        this.shortName = shortName;
        this.validateFqName();
    }

    private void validateFqName() {
        if (!FqNameUnsafe.isValid(this.fqName)) {
            throw new IllegalArgumentException("incorrect fq name: " + this.fqName);
        }
    }

    public static boolean isValid(@Nullable String qualifiedName) {
        return qualifiedName != null && qualifiedName.indexOf(47) < 0 && qualifiedName.indexOf(42) < 0;
    }

    private void compute() {
        int lastDot = this.fqName.lastIndexOf(46);
        if (lastDot >= 0) {
            this.shortName = Name.guess(this.fqName.substring(lastDot + 1));
            this.parent = new FqNameUnsafe(this.fqName.substring(0, lastDot));
        } else {
            this.shortName = Name.guess(this.fqName);
            this.parent = FqName.ROOT.toUnsafe();
        }
    }

    @Override
    @NotNull
    public String asString() {
        return this.fqName;
    }

    public boolean isSafe() {
        if (this.safe != null) {
            return true;
        }
        return FqName.isValidAfterUnsafeCheck(this.asString());
    }

    @NotNull
    public FqName toSafe() {
        if (this.safe != null) {
            return this.safe;
        }
        this.safe = new FqName(this);
        return this.safe;
    }

    public boolean isRoot() {
        return this.fqName.equals("");
    }

    @NotNull
    public FqNameUnsafe parent() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        return this.parent;
    }

    @NotNull
    public FqNameUnsafe child(@NotNull Name name) {
        String childFqName = this.isRoot() ? name.asString() : this.fqName + "." + name.asString();
        return new FqNameUnsafe(childFqName, this, name);
    }

    @NotNull
    public Name shortName() {
        if (this.shortName != null) {
            return this.shortName;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        return this.shortName;
    }

    @NotNull
    public Name shortNameOrSpecial() {
        if (this.isRoot()) {
            return ROOT_NAME;
        }
        return this.shortName();
    }

    @NotNull
    public List<FqNameUnsafe> path() {
        final ArrayList<FqNameUnsafe> path = Lists.newArrayList();
        path.add(FqName.ROOT.toUnsafe());
        this.walk(new WalkCallback(){

            @Override
            public void segment(@NotNull Name shortName, @NotNull FqNameUnsafe fqName) {
                path.add(fqName);
            }
        });
        return path;
    }

    @NotNull
    public List<Name> pathSegments() {
        final ArrayList<Name> path = Lists.newArrayList();
        this.walk(new WalkCallback(){

            @Override
            public void segment(@NotNull Name shortName, @NotNull FqNameUnsafe fqName) {
                path.add(shortName);
            }
        });
        return path;
    }

    void walk(@NotNull WalkCallback callback) {
        if (this.isRoot()) {
            return;
        }
        int pos = this.fqName.indexOf(46);
        if (pos < 0) {
            if (this.parent == null) {
                this.parent = FqName.ROOT.toUnsafe();
            }
            if (this.shortName == null) {
                this.shortName = Name.guess(this.fqName);
            }
            callback.segment(this.shortName, this);
            return;
        }
        Name firstSegment = Name.guess(this.fqName.substring(0, pos));
        FqNameUnsafe last = new FqNameUnsafe(firstSegment.asString(), FqName.ROOT.toUnsafe(), firstSegment);
        callback.segment(firstSegment, last);
        while (true) {
            Name shortName;
            int next;
            if ((next = this.fqName.indexOf(46, pos + 1)) < 0) {
                if (this.parent == null) {
                    this.parent = last;
                }
                shortName = Name.guess(this.fqName.substring(pos + 1));
                if (this.shortName == null) {
                    this.shortName = shortName;
                }
                callback.segment(shortName, this);
                return;
            }
            shortName = Name.guess(this.fqName.substring(pos + 1, next));
            last = new FqNameUnsafe(this.fqName.substring(0, next), last, shortName);
            callback.segment(shortName, last);
            pos = next;
        }
    }

    public boolean firstSegmentIs(@NotNull Name segment) {
        if (this.isRoot()) {
            return false;
        }
        List<Name> pathSegments = this.pathSegments();
        return pathSegments.get(0).equals(segment);
    }

    public boolean lastSegmentIs(@NotNull Name segment) {
        if (this.isRoot()) {
            return false;
        }
        return this.shortName().equals(segment);
    }

    @NotNull
    public static FqNameUnsafe fromSegments(@NotNull List<Name> names) {
        String fqName = StringUtil.join(names, ".");
        return new FqNameUnsafe(fqName);
    }

    @NotNull
    public static FqNameUnsafe topLevel(@NotNull Name shortName) {
        return new FqNameUnsafe(shortName.asString(), FqName.ROOT.toUnsafe(), shortName);
    }

    public String toString() {
        return this.isRoot() ? ROOT_NAME.asString() : this.fqName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FqNameUnsafe)) {
            return false;
        }
        FqNameUnsafe that = (FqNameUnsafe)o;
        return this.fqName.equals(that.fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }

    static interface WalkCallback {
        public void segment(@NotNull Name var1, @NotNull FqNameUnsafe var2);
    }
}

