/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.Name;

class ImportsProvider {
    private final List<JetImportDirective> importDirectives;
    private final NotNullLazyValue<NameToImportsCache> importsCacheValue;

    public ImportsProvider(StorageManager storageManager, final List<JetImportDirective> importDirectives) {
        this.importDirectives = importDirectives;
        this.importsCacheValue = storageManager.createLazyValue(new Computable<NameToImportsCache>(){

            @Override
            public NameToImportsCache compute() {
                return NameToImportsCache.createIndex(importDirectives);
            }
        });
    }

    @NotNull
    public List<JetImportDirective> getImports(@NotNull Name name) {
        return this.importsCacheValue.compute().getImports(name);
    }

    @NotNull
    public List<JetImportDirective> getAllImports() {
        return this.importDirectives;
    }

    private static class NameToImportsCache {
        private final ListMultimap<Name, JetImportDirective> nameToDirectives;
        private final List<JetImportDirective> allUnderImports;

        private NameToImportsCache(ListMultimap<Name, JetImportDirective> directives, List<JetImportDirective> imports) {
            this.nameToDirectives = directives;
            this.allUnderImports = imports;
        }

        private List<JetImportDirective> getImports(@NotNull Name name) {
            return this.nameToDirectives.containsKey(name) ? this.nameToDirectives.get(name) : this.allUnderImports;
        }

        private static NameToImportsCache createIndex(List<JetImportDirective> importDirectives) {
            ImmutableListMultimap.Builder namesToRelativeImportsBuilder = ImmutableListMultimap.builder();
            HashSet<Name> processedAliases = Sets.newHashSet();
            ArrayList<JetImportDirective> processedAllUnderImports = Lists.newArrayList();
            for (JetImportDirective anImport : importDirectives) {
                ImportPath path = JetPsiUtil.getImportPath(anImport);
                if (path == null) continue;
                if (path.isAllUnder()) {
                    processedAllUnderImports.add(anImport);
                    for (Name aliasName : processedAliases) {
                        namesToRelativeImportsBuilder.put(aliasName, anImport);
                    }
                    continue;
                }
                Name aliasName = path.getImportedName();
                assert (aliasName != null);
                if (!processedAliases.contains(aliasName)) {
                    processedAliases.add(aliasName);
                    namesToRelativeImportsBuilder.putAll(aliasName, processedAllUnderImports);
                }
                namesToRelativeImportsBuilder.put(aliasName, anImport);
            }
            return new NameToImportsCache((ListMultimap<Name, JetImportDirective>)((Object)namesToRelativeImportsBuilder.build()), ImmutableList.copyOf(processedAllUnderImports));
        }
    }
}

