/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeParameterImpl;

public class JavaTypeSubstitutorImpl
implements JavaTypeSubstitutor {
    private final PsiSubstitutor psiSubstitutor;
    private Map<JavaTypeParameter, JavaType> substitutionMap;

    public JavaTypeSubstitutorImpl(@NotNull PsiSubstitutor psiSubstitutor) {
        this.psiSubstitutor = psiSubstitutor;
    }

    public JavaTypeSubstitutorImpl(@NotNull PsiSubstitutor psiSubstitutor, @NotNull Map<JavaTypeParameter, JavaType> substitutionMap) {
        this(psiSubstitutor);
        this.substitutionMap = substitutionMap;
    }

    @NotNull
    public static JavaTypeSubstitutor create(@NotNull Map<JavaTypeParameter, JavaType> substitutionMap) {
        HashMap<PsiTypeParameter, PsiType> psiMap = new HashMap<PsiTypeParameter, PsiType>();
        for (Map.Entry<JavaTypeParameter, JavaType> entry : substitutionMap.entrySet()) {
            JavaTypeImpl value = (JavaTypeImpl)entry.getValue();
            psiMap.put((PsiTypeParameter)((JavaTypeParameterImpl)entry.getKey()).getPsi(), (PsiType)(value == null ? null : (Object)value.getPsi()));
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(psiMap);
        return new JavaTypeSubstitutorImpl(psiSubstitutor, substitutionMap);
    }

    @Override
    @NotNull
    public JavaType substitute(@NotNull JavaType type) {
        return JavaTypeImpl.create(this.psiSubstitutor.substitute((PsiType)((JavaTypeImpl)type).getPsi()));
    }

    @Override
    @Nullable
    public JavaType substitute(@NotNull JavaTypeParameter typeParameter) {
        PsiType psiType = this.psiSubstitutor.substitute((PsiTypeParameter)((JavaTypeParameterImpl)typeParameter).getPsi());
        return psiType == null ? null : JavaTypeImpl.create(psiType);
    }

    @Override
    @NotNull
    public Map<JavaTypeParameter, JavaType> getSubstitutionMap() {
        if (this.substitutionMap == null) {
            Map<PsiTypeParameter, PsiType> psiMap = this.psiSubstitutor.getSubstitutionMap();
            this.substitutionMap = new HashMap<JavaTypeParameter, JavaType>();
            for (Map.Entry<PsiTypeParameter, PsiType> entry : psiMap.entrySet()) {
                PsiType value = entry.getValue();
                this.substitutionMap.put(new JavaTypeParameterImpl(entry.getKey()), value == null ? null : JavaTypeImpl.create(value));
            }
        }
        return this.substitutionMap;
    }

    public int hashCode() {
        return this.psiSubstitutor.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaTypeSubstitutorImpl && this.psiSubstitutor.equals(((JavaTypeSubstitutorImpl)obj).psiSubstitutor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.psiSubstitutor;
    }
}

