/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationOwner;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiBasedExternalAnnotationResolver
implements ExternalAnnotationResolver {
    @Override
    @Nullable
    public JavaAnnotation findExternalAnnotation(@NotNull JavaAnnotationOwner owner, @NotNull FqName fqName) {
        PsiAnnotation psiAnnotation = PsiBasedExternalAnnotationResolver.findExternalAnnotation(((JavaAnnotationOwnerImpl)owner).getPsi(), fqName);
        return psiAnnotation == null ? null : new JavaAnnotationImpl(psiAnnotation);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> findExternalAnnotations(@NotNull JavaAnnotationOwner owner) {
        PsiModifierListOwner psiOwner = ((JavaAnnotationOwnerImpl)owner).getPsi();
        PsiAnnotation[] annotations = ExternalAnnotationsManager.getInstance(psiOwner.getProject()).findExternalAnnotations(psiOwner);
        return annotations == null ? Collections.emptyList() : JavaElementCollectionFromPsiArrayUtil.annotations(annotations);
    }

    @Nullable
    public static PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner owner, @NotNull FqName fqName) {
        return ExternalAnnotationsManager.getInstance(owner.getProject()).findExternalAnnotation(owner, fqName.asString());
    }

    @Nullable
    public static PsiAnnotation findOwnAnnotation(@NotNull PsiModifierListOwner owner, @NotNull JvmClassName name) {
        PsiModifierList list = owner.getModifierList();
        return list == null ? null : list.findAnnotation(name.getFqName().asString());
    }
}

