/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.ClassReader;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.lang.resolve.java.AbiVersionUtil;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class KotlinClassFileHeader {
    private int version = -1;
    @Nullable
    private String[] annotationData = null;
    @NotNull
    HeaderType type = HeaderType.NONE;
    @Nullable
    JvmClassName jvmClassName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static KotlinClassFileHeader readKotlinHeaderFromClassFile(@NotNull VirtualFile virtualFile) {
        KotlinClassFileHeader kotlinClassFileHeader;
        InputStream inputStream = virtualFile.getInputStream();
        try {
            ClassReader reader = new ClassReader(inputStream);
            KotlinClassFileHeader classFileData = new KotlinClassFileHeader();
            reader.accept(classFileData.new ReadDataFromAnnotationVisitor(), 7);
            kotlinClassFileHeader = classFileData;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return kotlinClassFileHeader;
    }

    public int getVersion() {
        return this.version;
    }

    @NotNull
    public HeaderType getType() {
        return this.type;
    }

    public boolean isKotlinCompiledFile() {
        return this.type.isValidAnnotation() && AbiVersionUtil.isAbiVersionCompatible(this.version);
    }

    @NotNull
    public FqName getFqName() {
        assert (this.jvmClassName != null);
        return this.jvmClassName.getFqName();
    }

    public String[] getAnnotationData() {
        this.assertDataRead();
        return this.annotationData;
    }

    private void assertDataRead() {
        if (this.annotationData == null && this.type != HeaderType.NONE) {
            throw new IllegalStateException("Data for annotations " + this.type.correspondingAnnotation + " was not read.");
        }
    }

    @NotNull
    public ClassData readClassData() {
        assert (this.type == HeaderType.CLASS);
        return JavaProtoBufUtil.readClassDataFrom(this.getAnnotationData());
    }

    @NotNull
    public PackageData readPackageData() {
        assert (this.type == HeaderType.PACKAGE);
        return JavaProtoBufUtil.readPackageDataFrom(this.getAnnotationData());
    }

    private KotlinClassFileHeader() {
    }

    static /* synthetic */ String[] access$202(KotlinClassFileHeader x0, String[] x1) {
        x0.annotationData = x1;
        return x1;
    }

    private class ReadDataFromAnnotationVisitor
    extends ClassVisitor {
        public ReadDataFromAnnotationVisitor() {
            super(262144);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            KotlinClassFileHeader.this.jvmClassName = JvmClassName.byInternalName(name);
        }

        @Override
        public AnnotationVisitor visitAnnotation(final String desc, boolean visible) {
            HeaderType headerTypeByAnnotation = HeaderType.byDescriptor(desc);
            if (headerTypeByAnnotation == HeaderType.NONE) {
                return null;
            }
            if (headerTypeByAnnotation.isValidAnnotation() && KotlinClassFileHeader.this.type.isValidAnnotation()) {
                throw new IllegalStateException("Both " + KotlinClassFileHeader.this.type.correspondingAnnotation + " and " + headerTypeByAnnotation.correspondingAnnotation + " present!");
            }
            if (!KotlinClassFileHeader.this.type.isValidAnnotation()) {
                KotlinClassFileHeader.this.type = headerTypeByAnnotation;
            }
            if (!headerTypeByAnnotation.isValidAnnotation()) {
                return null;
            }
            return new AnnotationVisitor(262144){

                @Override
                public void visit(String name, Object value) {
                    if (name.equals("abiVersion")) {
                        KotlinClassFileHeader.this.version = (Integer)value;
                    } else if (AbiVersionUtil.isAbiVersionCompatible(KotlinClassFileHeader.this.version)) {
                        throw new IllegalStateException("Unexpected argument " + name + " for annotation " + desc);
                    }
                }

                @Override
                public AnnotationVisitor visitArray(String name) {
                    if (name.equals("data")) {
                        return this.stringArrayVisitor();
                    }
                    if (AbiVersionUtil.isAbiVersionCompatible(KotlinClassFileHeader.this.version)) {
                        throw new IllegalStateException("Unexpected array argument " + name + " for annotation " + desc);
                    }
                    return super.visitArray(name);
                }

                @NotNull
                private AnnotationVisitor stringArrayVisitor() {
                    final ArrayList strings = new ArrayList(1);
                    return new AnnotationVisitor(262144){

                        @Override
                        public void visit(String name, Object value) {
                            if (!(value instanceof String)) {
                                throw new IllegalStateException("Unexpected argument value: " + value);
                            }
                            strings.add((String)value);
                        }

                        @Override
                        public void visitEnd() {
                            KotlinClassFileHeader.access$202(KotlinClassFileHeader.this, strings.toArray(new String[strings.size()]));
                        }
                    };
                }
            };
        }
    }

    public static enum HeaderType {
        CLASS(JvmAnnotationNames.KOTLIN_CLASS),
        PACKAGE(JvmAnnotationNames.KOTLIN_PACKAGE),
        OLD_CLASS(JvmAnnotationNames.OLD_JET_CLASS_ANNOTATION),
        OLD_PACKAGE(JvmAnnotationNames.OLD_JET_PACKAGE_CLASS_ANNOTATION),
        NONE(null);

        @Nullable
        private final JvmClassName correspondingAnnotation;

        private HeaderType(@Nullable JvmClassName annotation) {
            this.correspondingAnnotation = annotation;
        }

        boolean isValidAnnotation() {
            return this == CLASS || this == PACKAGE;
        }

        @NotNull
        public static HeaderType byDescriptor(@NotNull String desc) {
            for (HeaderType headerType : HeaderType.values()) {
                JvmClassName annotation = headerType.correspondingAnnotation;
                if (annotation == null || !desc.equals(annotation.getDescriptor())) continue;
                return headerType;
            }
            return NONE;
        }
    }
}

