/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolverImpl;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaSupertypeResolver {
    public static final FqName OBJECT_FQ_NAME = new FqName("java.lang.Object");
    private JavaTypeTransformer typeTransformer;
    private JavaClassResolver classResolver;

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @NotNull
    public Collection<JetType> getSupertypes(@NotNull ClassDescriptor classDescriptor, @NotNull JavaClass javaClass, @NotNull List<TypeParameterDescriptor> typeParameters) {
        TypeVariableResolverImpl typeVariableResolver = new TypeVariableResolverImpl(typeParameters, classDescriptor);
        List<JetType> result = this.transformSupertypeList(javaClass.getSupertypes(), typeVariableResolver);
        return result.isEmpty() ? Collections.singletonList(this.getDefaultSupertype(javaClass)) : result;
    }

    @NotNull
    private JetType getDefaultSupertype(@NotNull JavaClass javaClass) {
        if (OBJECT_FQ_NAME.equals(javaClass.getFqName()) || javaClass.isAnnotationType()) {
            return KotlinBuiltIns.getInstance().getAnyType();
        }
        ClassDescriptor object = this.classResolver.resolveClass(OBJECT_FQ_NAME, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (object != null) {
            return object.getDefaultType();
        }
        return KotlinBuiltIns.getInstance().getAnyType();
    }

    @NotNull
    private List<JetType> transformSupertypeList(@NotNull Collection<JavaClassifierType> supertypes, @NotNull TypeVariableResolver typeVariableResolver) {
        ArrayList<JetType> result = new ArrayList<JetType>(supertypes.size());
        for (JavaClassifierType type : supertypes) {
            JetType transformed;
            JavaClassifier resolved = type.getClassifier();
            if (resolved != null) {
                assert (resolved instanceof JavaClass) : "Supertype should be a class: " + resolved;
                FqName fqName = ((JavaClass)resolved).getFqName();
                assert (fqName != null) : "Unresolved supertype: " + resolved;
                if (JvmAbi.JET_OBJECT.getFqName().equals(fqName)) continue;
            }
            if (ErrorUtils.isErrorType(transformed = this.typeTransformer.transformToType(type, TypeUsage.SUPERTYPE, typeVariableResolver))) continue;
            result.add(TypeUtils.makeNotNullable(transformed));
        }
        return result;
    }
}

