/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaPropertyDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaPropertyDescriptorForObject;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.FakeOverrideVisibilityResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolverImpl;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public final class JavaPropertyResolver {
    private JavaTypeTransformer typeTransformer;
    private JavaResolverCache cache;
    private JavaAnnotationResolver annotationResolver;
    private ExternalSignatureResolver externalSignatureResolver;
    private FakeOverrideVisibilityResolver fakeOverrideVisibilityResolver;

    public void setTypeTransformer(@NotNull JavaTypeTransformer javaTypeTransformer) {
        this.typeTransformer = javaTypeTransformer;
    }

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setExternalSignatureResolver(ExternalSignatureResolver externalSignatureResolver) {
        this.externalSignatureResolver = externalSignatureResolver;
    }

    public void setFakeOverrideVisibilityResolver(FakeOverrideVisibilityResolver fakeOverrideVisibilityResolver) {
        this.fakeOverrideVisibilityResolver = fakeOverrideVisibilityResolver;
    }

    @NotNull
    public Set<VariableDescriptor> resolveFieldGroup(@NotNull NamedMembers members, @NotNull ClassOrNamespaceDescriptor owner) {
        JavaField field;
        Name propertyName = members.getName();
        List<JavaField> fields = members.getFields();
        HashSet<PropertyDescriptor> propertiesFromCurrent = new HashSet<PropertyDescriptor>(1);
        assert (fields.size() <= 1);
        if (fields.size() == 1 && DescriptorResolverUtils.isCorrectOwnerForEnumMember(owner, field = fields.iterator().next())) {
            propertiesFromCurrent.add(this.resolveProperty(owner, propertyName, field));
        }
        HashSet<PropertyDescriptor> properties = new HashSet<PropertyDescriptor>();
        if (owner instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)owner;
            Set<PropertyDescriptor> propertiesFromSupertypes = JavaPropertyResolver.getPropertiesFromSupertypes(propertyName, classDescriptor);
            properties.addAll(DescriptorResolverUtils.resolveOverrides(propertyName, propertiesFromSupertypes, propertiesFromCurrent, classDescriptor, this.fakeOverrideVisibilityResolver));
        }
        properties.addAll(propertiesFromCurrent);
        return new HashSet<VariableDescriptor>(properties);
    }

    @NotNull
    private PropertyDescriptor resolveProperty(@NotNull ClassOrNamespaceDescriptor owner, @NotNull Name name, @NotNull JavaField field) {
        boolean isVar = !field.isFinal();
        PropertyDescriptorImpl propertyDescriptor = this.createPropertyDescriptor(owner, name, field, isVar);
        propertyDescriptor.initialize(null, null);
        TypeVariableResolverImpl typeVariableResolver = new TypeVariableResolverImpl(Collections.<TypeParameterDescriptor>emptyList(), propertyDescriptor);
        JetType propertyType = this.getPropertyType(field, typeVariableResolver);
        ExternalSignatureResolver.AlternativeFieldSignature effectiveSignature = this.externalSignatureResolver.resolveAlternativeFieldSignature(field, propertyType, isVar);
        List<String> signatureErrors = effectiveSignature.getErrors();
        if (!signatureErrors.isEmpty()) {
            this.externalSignatureResolver.reportSignatureErrors(propertyDescriptor, signatureErrors);
        }
        propertyDescriptor.setType(effectiveSignature.getReturnType(), Collections.emptyList(), DescriptorUtils.getExpectedThisObjectIfNeeded(owner), (JetType)null);
        this.cache.recordField(field, propertyDescriptor);
        return propertyDescriptor;
    }

    @NotNull
    private PropertyDescriptorImpl createPropertyDescriptor(@NotNull ClassOrNamespaceDescriptor owner, @NotNull Name propertyName, @NotNull JavaField field, boolean isVar) {
        List<AnnotationDescriptor> annotations = this.annotationResolver.resolveAnnotations(field);
        Visibility visibility = field.getVisibility();
        if (field.isEnumEntry()) {
            assert (!isVar) : "Enum entries should be immutable.";
            assert (DescriptorUtils.isEnumClassObject(owner)) : "Enum entries should be put into class object of enum only: " + owner;
            ClassDescriptorImpl dummyClassDescriptorForEnumEntryObject = new ClassDescriptorImpl(owner, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, propertyName);
            dummyClassDescriptorForEnumEntryObject.initialize(true, Collections.emptyList(), Collections.<JetType>emptyList(), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, false);
            return new JavaPropertyDescriptorForObject(owner, annotations, visibility, propertyName, (ClassDescriptor)dummyClassDescriptorForEnumEntryObject);
        }
        return new JavaPropertyDescriptor(owner, annotations, visibility, isVar, propertyName);
    }

    @NotNull
    private JetType getPropertyType(@NotNull JavaField field, @NotNull TypeVariableResolver typeVariableResolver) {
        JetType propertyType = this.typeTransformer.transformToType(field.getType(), typeVariableResolver);
        if (this.annotationResolver.hasNotNullAnnotation(field) || JavaPropertyResolver.isStaticFinalField(field)) {
            return TypeUtils.makeNotNullable(propertyType);
        }
        return propertyType;
    }

    @NotNull
    private static Set<PropertyDescriptor> getPropertiesFromSupertypes(@NotNull Name name, @NotNull ClassDescriptor descriptor) {
        HashSet<PropertyDescriptor> result = new HashSet<PropertyDescriptor>();
        for (JetType supertype : descriptor.getTypeConstructor().getSupertypes()) {
            for (VariableDescriptor property : supertype.getMemberScope().getProperties(name)) {
                result.add((PropertyDescriptor)property);
            }
        }
        return result;
    }

    private static boolean isStaticFinalField(@NotNull JavaField field) {
        return field.isFinal() && field.isStatic();
    }
}

