/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaVisibilities;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaValueParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolverImpl;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.types.JetType;

public final class JavaConstructorResolver {
    private JavaResolverCache cache;
    private JavaTypeTransformer typeTransformer;
    private JavaValueParameterResolver valueParameterResolver;
    private ExternalSignatureResolver externalSignatureResolver;

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setValueParameterResolver(JavaValueParameterResolver valueParameterResolver) {
        this.valueParameterResolver = valueParameterResolver;
    }

    public void setExternalSignatureResolver(ExternalSignatureResolver externalSignatureResolver) {
        this.externalSignatureResolver = externalSignatureResolver;
    }

    @NotNull
    public Collection<ConstructorDescriptor> resolveConstructors(@NotNull JavaClass javaClass, @NotNull ClassDescriptor containingClass) {
        ArrayList<ConstructorDescriptor> result = new ArrayList<ConstructorDescriptor>();
        Collection<JavaMethod> constructors = javaClass.getConstructors();
        if (containingClass.getKind() == ClassKind.OBJECT || containingClass.getKind() == ClassKind.CLASS_OBJECT) {
            result.add(DescriptorResolver.createPrimaryConstructorForObject(containingClass));
        } else if (constructors.isEmpty()) {
            ConstructorDescriptor defaultConstructor = this.resolveDefaultConstructor(javaClass, containingClass);
            if (defaultConstructor != null) {
                result.add(defaultConstructor);
            }
        } else {
            for (JavaMethod javaMethod : constructors) {
                ConstructorDescriptor descriptor = this.resolveConstructor(javaMethod, containingClass, javaClass.isStatic());
                result.add(descriptor);
                ConstructorDescriptor samAdapter = JavaConstructorResolver.resolveSamAdapter(descriptor);
                if (samAdapter == null) continue;
                result.add(samAdapter);
            }
        }
        for (ConstructorDescriptor constructorDescriptor : result) {
            ((ConstructorDescriptorImpl)constructorDescriptor).setReturnType(containingClass.getDefaultType());
        }
        return result;
    }

    @Nullable
    private ConstructorDescriptor resolveDefaultConstructor(@NotNull JavaClass javaClass, @NotNull ClassDescriptor containingClass) {
        List<ValueParameterDescriptor> valueParameters;
        ConstructorDescriptor alreadyResolved = this.cache.getConstructor(javaClass);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        boolean isAnnotation = javaClass.isAnnotationType();
        if (javaClass.isInterface() && !isAnnotation) {
            return null;
        }
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(containingClass, Collections.<AnnotationDescriptor>emptyList(), true);
        List<TypeParameterDescriptor> typeParameters = containingClass.getTypeConstructor().getParameters();
        if (isAnnotation) {
            TypeVariableResolverImpl typeVariableResolver = new TypeVariableResolverImpl(typeParameters, containingClass);
            valueParameters = this.resolveAnnotationParameters(javaClass, constructorDescriptor, typeVariableResolver);
        } else {
            valueParameters = Collections.emptyList();
        }
        constructorDescriptor.initialize(typeParameters, valueParameters, JavaConstructorResolver.getConstructorVisibility(containingClass), javaClass.isStatic());
        this.cache.recordConstructor(javaClass, constructorDescriptor);
        return constructorDescriptor;
    }

    @NotNull
    private List<ValueParameterDescriptor> resolveAnnotationParameters(@NotNull JavaClass javaClass, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull TypeVariableResolver typeVariableResolver) {
        Collection<JavaMethod> methods = javaClass.getMethods();
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>(methods.size());
        int index = 0;
        Iterator<JavaMethod> iterator = methods.iterator();
        while (iterator.hasNext()) {
            JavaMethod method = iterator.next();
            assert (method.getValueParameters().isEmpty()) : "Annotation method can't have parameters: " + method;
            JavaType returnType = method.getReturnType();
            assert (returnType != null) : "Annotation method has no return type: " + method;
            JetType varargElementType = null;
            if (!iterator.hasNext() && returnType instanceof JavaArrayType) {
                JavaType componentType = ((JavaArrayType)returnType).getComponentType();
                varargElementType = this.typeTransformer.transformToType(componentType, typeVariableResolver);
            }
            result.add(new ValueParameterDescriptorImpl(constructorDescriptor, index, Collections.<AnnotationDescriptor>emptyList(), method.getName(), this.typeTransformer.transformToType(returnType, typeVariableResolver), method.hasAnnotationParameterDefaultValue(), varargElementType));
            ++index;
        }
        return result;
    }

    @NotNull
    private static Visibility getConstructorVisibility(@NotNull ClassDescriptor classDescriptor) {
        Visibility visibility = classDescriptor.getVisibility();
        if (visibility == JavaVisibilities.PROTECTED_STATIC_VISIBILITY) {
            return JavaVisibilities.PROTECTED_AND_PACKAGE;
        }
        return visibility;
    }

    @NotNull
    private ConstructorDescriptor resolveConstructor(@NotNull JavaMethod constructor, @NotNull ClassDescriptor classDescriptor, boolean isStaticClass) {
        ConstructorDescriptor alreadyResolved = this.cache.getConstructor(constructor);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
        List<TypeParameterDescriptor> typeParameters = classDescriptor.getTypeConstructor().getParameters();
        List<ValueParameterDescriptor> valueParameters = this.valueParameterResolver.resolveValueParameters(constructorDescriptor, constructor, new TypeVariableResolverImpl(typeParameters, classDescriptor));
        ExternalSignatureResolver.AlternativeMethodSignature effectiveSignature = this.externalSignatureResolver.resolveAlternativeMethodSignature(constructor, false, null, null, valueParameters, Collections.<TypeParameterDescriptor>emptyList());
        constructorDescriptor.initialize(typeParameters, effectiveSignature.getValueParameters(), constructor.getVisibility(), isStaticClass);
        List<String> signatureErrors = effectiveSignature.getErrors();
        if (!signatureErrors.isEmpty()) {
            this.externalSignatureResolver.reportSignatureErrors(constructorDescriptor, signatureErrors);
        }
        this.cache.recordConstructor(constructor, constructorDescriptor);
        return constructorDescriptor;
    }

    @Nullable
    private static ConstructorDescriptor resolveSamAdapter(@NotNull ConstructorDescriptor original) {
        return SingleAbstractMethodUtils.isSamAdapterNecessary(original) ? (ConstructorDescriptor)((Object)SingleAbstractMethodUtils.createSamAdapterConstructor(original)) : null;
    }
}

