/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.types.JetType;

public interface ExternalSignatureResolver {
    @NotNull
    public PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod var1, @NotNull ClassDescriptor var2, @NotNull JetType var3, @Nullable JetType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6);

    @NotNull
    public AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMethod var1, boolean var2, @Nullable JetType var3, @Nullable JetType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6);

    @NotNull
    public AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField var1, @NotNull JetType var2, boolean var3);

    public void reportSignatureErrors(@NotNull CallableMemberDescriptor var1, @NotNull List<String> var2);

    public static class PropagatedMethodSignature
    extends AlternativeMethodSignature {
        private final List<FunctionDescriptor> superMethods;

        public PropagatedMethodSignature(@Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors, @NotNull List<FunctionDescriptor> superMethods) {
            super(returnType, receiverType, valueParameters, typeParameters, signatureErrors);
            this.superMethods = superMethods;
        }

        @NotNull
        public List<FunctionDescriptor> getSuperMethods() {
            return this.superMethods;
        }
    }

    public static class AlternativeFieldSignature
    extends MemberSignature {
        private final JetType returnType;

        public AlternativeFieldSignature(@NotNull JetType returnType, @Nullable String signatureError) {
            super(signatureError == null ? Collections.emptyList() : Collections.singletonList(signatureError));
            this.returnType = returnType;
        }

        @NotNull
        public JetType getReturnType() {
            return this.returnType;
        }
    }

    public static class AlternativeMethodSignature
    extends MemberSignature {
        private final JetType returnType;
        private final JetType receiverType;
        private final List<ValueParameterDescriptor> valueParameters;
        private final List<TypeParameterDescriptor> typeParameters;

        public AlternativeMethodSignature(@Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors) {
            super(signatureErrors);
            this.returnType = returnType;
            this.receiverType = receiverType;
            this.valueParameters = valueParameters;
            this.typeParameters = typeParameters;
        }

        @Nullable
        public JetType getReturnType() {
            return this.returnType;
        }

        @Nullable
        public JetType getReceiverType() {
            return this.receiverType;
        }

        @NotNull
        public List<ValueParameterDescriptor> getValueParameters() {
            return this.valueParameters;
        }

        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            return this.typeParameters;
        }
    }

    public static abstract class MemberSignature {
        private final List<String> signatureErrors;

        protected MemberSignature(@NotNull List<String> signatureErrors) {
            this.signatureErrors = signatureErrors;
        }

        @NotNull
        public List<String> getErrors() {
            return this.signatureErrors;
        }
    }
}

