/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSupertypeResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaElementFactory;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeSubstitutorImpl;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

class PropagationHeuristics {
    static void checkArrayInReturnType(@NotNull SignaturesPropagationData data, @NotNull JetType type, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        List<SignaturesPropagationData.TypeAndVariance> arrayTypesFromSuper = ContainerUtil.filter(typesFromSuper, new Condition<SignaturesPropagationData.TypeAndVariance>(){

            @Override
            public boolean value(SignaturesPropagationData.TypeAndVariance typeAndVariance) {
                return typeAndVariance.type.getConstructor().getDeclarationDescriptor() == KotlinBuiltIns.getInstance().getArray();
            }
        });
        if (KotlinBuiltIns.getInstance().getArray() == type.getConstructor().getDeclarationDescriptor() && !arrayTypesFromSuper.isEmpty()) {
            assert (type.getArguments().size() == 1);
            if (type.getArguments().get(0).getProjectionKind() == Variance.INVARIANT) {
                for (SignaturesPropagationData.TypeAndVariance typeAndVariance : arrayTypesFromSuper) {
                    JetType arrayTypeFromSuper = typeAndVariance.type;
                    assert (arrayTypeFromSuper.getArguments().size() == 1);
                    JetType elementTypeInSuper = arrayTypeFromSuper.getArguments().get(0).getType();
                    JetType elementType = type.getArguments().get(0).getType();
                    if (!JetTypeChecker.INSTANCE.isSubtypeOf(elementType, elementTypeInSuper) || JetTypeChecker.INSTANCE.equalTypes(elementType, elementTypeInSuper)) continue;
                    JetTypeImpl betterTypeInSuper = new JetTypeImpl(arrayTypeFromSuper.getAnnotations(), arrayTypeFromSuper.getConstructor(), arrayTypeFromSuper.isNullable(), Arrays.asList(new TypeProjection(Variance.OUT_VARIANCE, elementTypeInSuper)), JetScope.EMPTY);
                    data.reportError("Return type is not a subtype of overridden method. To fix it, add annotation with Kotlin signature to super method with type " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(arrayTypeFromSuper) + " replaced with " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(betterTypeInSuper) + " in return type");
                }
            }
        }
    }

    @Nullable
    static ClassifierDescriptor tryToFixOverridingTWithRawType(@NotNull SignaturesPropagationData data, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        ArrayList<TypeParameterDescriptor> typeParameterClassifiersFromSuper = Lists.newArrayList();
        for (SignaturesPropagationData.TypeAndVariance typeFromSuper : typesFromSuper) {
            ClassifierDescriptor classifierFromSuper = typeFromSuper.type.getConstructor().getDeclarationDescriptor();
            if (!(classifierFromSuper instanceof TypeParameterDescriptor)) continue;
            typeParameterClassifiersFromSuper.add((TypeParameterDescriptor)classifierFromSuper);
        }
        if (!typeParameterClassifiersFromSuper.isEmpty() && typeParameterClassifiersFromSuper.size() == typesFromSuper.size()) {
            for (TypeParameterDescriptor typeParameter : typeParameterClassifiersFromSuper) {
                if (typeParameter.getContainingDeclaration() != data.containingClass) continue;
                return typeParameter;
            }
        }
        return null;
    }

    @NotNull
    static List<JavaMethodImpl> getSuperMethods(@NotNull JavaMethod method) {
        return new SuperMethodCollector(method).collect();
    }

    private PropagationHeuristics() {
    }

    private static class SuperMethodCollector {
        private final JavaMethod initialMethod;
        private final Name initialMethodName;
        private final List<JavaType> initialParametersErasure;
        private final Set<JavaClass> visitedSuperclasses = Sets.newHashSet();
        private final List<JavaMethod> collectedMethods = Lists.newArrayList();

        private SuperMethodCollector(@NotNull JavaMethod initialMethod) {
            this.initialMethod = initialMethod;
            this.initialMethodName = initialMethod.getName();
            Collection<JavaValueParameter> valueParameters = initialMethod.getValueParameters();
            this.initialParametersErasure = Lists.newArrayListWithExpectedSize(valueParameters.size());
            for (JavaValueParameter parameter : valueParameters) {
                this.initialParametersErasure.add(DescriptorResolverUtils.erasure(SuperMethodCollector.varargToArray(parameter.getType(), parameter.isVararg())));
            }
        }

        @NotNull
        public List<JavaMethod> collect() {
            if (!SuperMethodCollector.canHaveSuperMethod(this.initialMethod)) {
                return Collections.emptyList();
            }
            for (JavaClassifierType supertype : this.initialMethod.getContainingClass().getSupertypes()) {
                this.collectFromSupertype(supertype);
            }
            return this.collectedMethods;
        }

        private void collectFromSupertype(@NotNull JavaClassifierType type) {
            JavaClassifier classifier = type.getClassifier();
            if (!(classifier instanceof JavaClass)) {
                return;
            }
            JavaClass klass = (JavaClass)classifier;
            if (!this.visitedSuperclasses.add(klass)) {
                return;
            }
            JavaTypeSubstitutor supertypeSubstitutor = SuperMethodCollector.getErasedSubstitutor(type);
            for (JavaMethod methodFromSuper : klass.getMethods()) {
                if (!this.isSubMethodOf(methodFromSuper, supertypeSubstitutor)) continue;
                this.collectedMethods.add(methodFromSuper);
                return;
            }
            for (JavaClassifierType supertype : type.getSupertypes()) {
                this.collectFromSupertype(supertype);
            }
        }

        private boolean isSubMethodOf(@NotNull JavaMethod methodFromSuper, @NotNull JavaTypeSubstitutor supertypeSubstitutor) {
            if (!methodFromSuper.getName().equals(this.initialMethodName)) {
                return false;
            }
            Collection<JavaValueParameter> fromSuperParameters = methodFromSuper.getValueParameters();
            if (fromSuperParameters.size() != this.initialParametersErasure.size()) {
                return false;
            }
            Iterator<JavaType> originalIterator = this.initialParametersErasure.iterator();
            Iterator<JavaValueParameter> superIterator = fromSuperParameters.iterator();
            while (originalIterator.hasNext()) {
                JavaValueParameter parameterFromSuper;
                JavaType typeFromSuper;
                JavaType originalType = originalIterator.next();
                if (Comparing.equal(originalType, typeFromSuper = DescriptorResolverUtils.erasure(SuperMethodCollector.varargToArray(supertypeSubstitutor.substitute((parameterFromSuper = superIterator.next()).getType()), parameterFromSuper.isVararg())))) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private static JavaType varargToArray(@NotNull JavaType type, boolean isVararg) {
            return isVararg ? JavaElementFactory.getInstance().createArrayType(((JavaArrayType)type).getComponentType()) : type;
        }

        @NotNull
        private static JavaTypeSubstitutor getErasedSubstitutor(@NotNull JavaClassifierType type) {
            Map<JavaTypeParameter, JavaType> unerasedMap = type.getSubstitutor().getSubstitutionMap();
            HashMap<JavaTypeParameter, JavaType> erasedMap = Maps.newHashMapWithExpectedSize(unerasedMap.size());
            for (Map.Entry<JavaTypeParameter, JavaType> entry : unerasedMap.entrySet()) {
                JavaType value = entry.getValue();
                erasedMap.put(entry.getKey(), value == null ? null : DescriptorResolverUtils.erasure(value));
            }
            return JavaTypeSubstitutorImpl.create(erasedMap);
        }

        private static boolean canHaveSuperMethod(@NotNull JavaMethod method) {
            return !method.isConstructor() && !method.isStatic() && method.getVisibility() != Visibilities.PRIVATE && !JavaSupertypeResolver.OBJECT_FQ_NAME.equals(method.getContainingClass().getFqName());
        }
    }
}

