/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JvmClassName {
    private final String internalName;
    private FqName fqName;
    private String descriptor;
    private String signatureName;
    private Type asmType;

    @NotNull
    public static JvmClassName byInternalName(@NotNull String internalName) {
        return new JvmClassName(internalName);
    }

    @NotNull
    public static JvmClassName byType(@NotNull Type type) {
        if (type.getSort() != 10) {
            throw new IllegalArgumentException("Type is not convertible to " + JvmClassName.class.getSimpleName() + ": " + type);
        }
        return JvmClassName.byInternalName(type.getInternalName());
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull FqName fqName) {
        JvmClassName r = new JvmClassName(JvmClassName.fqNameToInternalName(fqName));
        r.fqName = fqName;
        return r;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull String fqName) {
        return JvmClassName.byFqNameWithoutInnerClasses(new FqName(fqName));
    }

    @NotNull
    public static JvmClassName byClass(@NotNull Class<?> klass) {
        return JvmClassName.byFqNameWithoutInnerClasses(new FqName(klass.getCanonicalName()));
    }

    @NotNull
    public static JvmClassName bySignatureName(@NotNull String signatureName) {
        JvmClassName className = new JvmClassName(JvmClassName.signatureNameToInternalName(signatureName));
        className.signatureName = signatureName;
        return className;
    }

    private static String encodeSpecialNames(String str) {
        String encodedObjectNames = StringUtil.replace(str, "object", "<class_object>");
        return StringUtil.replace(encodedObjectNames, "$TImpl", "<trait_impl>");
    }

    private static String decodeSpecialNames(String str) {
        String decodedObjectNames = StringUtil.replace(str, "<class_object>", "object");
        return StringUtil.replace(decodedObjectNames, "<trait_impl>", "$TImpl");
    }

    @NotNull
    private static JvmClassName byFqNameAndInnerClassList(@NotNull FqName fqName, @NotNull List<String> innerClassList) {
        String outerClassName = JvmClassName.fqNameToInternalName(fqName);
        StringBuilder sb = new StringBuilder(outerClassName);
        for (String innerClassName : innerClassList) {
            sb.append("$").append(innerClassName);
        }
        return new JvmClassName(sb.toString());
    }

    @NotNull
    public static JvmClassName byClassDescriptor(@NotNull ClassifierDescriptor classDescriptor) {
        DeclarationDescriptor descriptor = classDescriptor;
        ArrayList<String> innerClassNames = new ArrayList<String>();
        while (descriptor.getContainingDeclaration() instanceof ClassDescriptor) {
            innerClassNames.add(descriptor.getName().asString());
            descriptor = descriptor.getContainingDeclaration();
            assert (descriptor != null);
        }
        return JvmClassName.byFqNameAndInnerClassList(DescriptorUtils.getFQName(descriptor).toSafe(), innerClassNames);
    }

    @NotNull
    private static String fqNameToInternalName(@NotNull FqName fqName) {
        return fqName.asString().replace('.', '/');
    }

    @NotNull
    private static String signatureNameToInternalName(@NotNull String signatureName) {
        return signatureName.replace('.', '$');
    }

    @NotNull
    private static String internalNameToFqName(@NotNull String name) {
        return JvmClassName.decodeSpecialNames(JvmClassName.encodeSpecialNames(name).replace('$', '.').replace('/', '.'));
    }

    @NotNull
    private static String internalNameToSignatureName(@NotNull String name) {
        return JvmClassName.decodeSpecialNames(JvmClassName.encodeSpecialNames(name).replace('$', '.'));
    }

    @NotNull
    private static String signatureNameToFqName(@NotNull String name) {
        return name.replace('/', '.');
    }

    private JvmClassName(@NotNull String internalName) {
        this.internalName = internalName;
    }

    @NotNull
    public FqName getFqName() {
        if (this.fqName == null) {
            this.fqName = new FqName(JvmClassName.internalNameToFqName(this.internalName));
        }
        return this.fqName;
    }

    @NotNull
    public String getInternalName() {
        return this.internalName;
    }

    @NotNull
    public String getDescriptor() {
        if (this.descriptor == null) {
            StringBuilder sb = new StringBuilder(this.internalName.length() + 2);
            sb.append('L');
            sb.append(this.internalName);
            sb.append(';');
            this.descriptor = sb.toString();
        }
        return this.descriptor;
    }

    @NotNull
    public Type getAsmType() {
        if (this.asmType == null) {
            this.asmType = Type.getType(this.getDescriptor());
        }
        return this.asmType;
    }

    @NotNull
    public String getSignatureName() {
        if (this.signatureName == null) {
            this.signatureName = JvmClassName.internalNameToSignatureName(this.internalName);
        }
        return this.signatureName;
    }

    @NotNull
    public FqName getOuterClassFqName() {
        String signatureName = this.getSignatureName();
        int index = signatureName.indexOf(46);
        String outerClassName = index != -1 ? signatureName.substring(0, index) : signatureName;
        return new FqName(JvmClassName.signatureNameToFqName(outerClassName));
    }

    @NotNull
    public List<String> getInnerClassNameList() {
        ArrayList<String> innerClassList = new ArrayList<String>();
        String signatureName = this.getSignatureName();
        int index = signatureName.indexOf(46);
        while (index != -1) {
            int nextIndex = signatureName.indexOf(46, index + 1);
            String innerClassName = nextIndex != -1 ? signatureName.substring(index + 1, nextIndex) : signatureName.substring(index + 1);
            innerClassList.add(innerClassName);
            index = nextIndex;
        }
        return innerClassList;
    }

    public String toString() {
        return this.getInternalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmClassName name = (JvmClassName)o;
        return this.internalName.equals(name.internalName);
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }
}

