/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class TracingStrategyImpl
implements TracingStrategy {
    private final JetReferenceExpression reference;
    private final Call call;

    private TracingStrategyImpl(@NotNull JetReferenceExpression reference, @NotNull Call call) {
        this.reference = reference;
        this.call = call;
    }

    @NotNull
    public static TracingStrategy create(@NotNull JetReferenceExpression reference, @NotNull Call call) {
        return new TracingStrategyImpl(reference, call);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCallWithTrace<D> resolvedCall) {
        DeclarationDescriptor storedReference;
        Object descriptor = resolvedCall.getResultingDescriptor();
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            descriptor = ((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall().getResultingDescriptor();
        }
        if ((storedReference = trace.get(BindingContext.REFERENCE_TARGET, this.reference)) == null || !ErrorUtils.isError(descriptor)) {
            trace.record(BindingContext.REFERENCE_TARGET, this.reference, descriptor);
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCallWithTrace<D> resolvedCall) {
        trace.record(BindingContext.RESOLVED_CALL, this.call.getCalleeExpression(), resolvedCall);
        trace.record(BindingContext.CALL, this.call.getCalleeExpression(), this.call);
    }

    @Override
    public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> candidates) {
        HashSet descriptors = Sets.newHashSet();
        for (ResolvedCallWithTrace<D> candidate : candidates) {
            descriptors.add(candidate.getCandidateDescriptor());
        }
        trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, this.reference, descriptors);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        trace.report(Errors.UNRESOLVED_REFERENCE.on(this.reference, this.reference));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> candidates) {
        trace.report(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER.on(this.reference, candidates));
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
        JetValueArgumentList valueArgumentList = this.call.getValueArgumentList();
        JetElementImpl reportOn = valueArgumentList != null ? valueArgumentList : this.reference;
        trace.report(Errors.NO_VALUE_FOR_PARAMETER.on(reportOn, valueParameter));
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        trace.report(Errors.MISSING_RECEIVER.on(this.reference, expectedReceiver.getType()));
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument) {
        if (receiverArgument instanceof ExpressionReceiver) {
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverArgument;
            trace.report(Errors.TYPE_MISMATCH.on(expressionReceiver.getExpression(), receiverParameter.getType(), receiverArgument.getType()));
        } else {
            trace.report(Errors.TYPE_MISMATCH.on(this.reference, receiverParameter.getType(), receiverArgument.getType()));
        }
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        trace.report(Errors.NO_RECEIVER_ADMITTED.on(this.reference));
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount) {
        JetTypeArgumentList typeArgumentList = this.call.getTypeArgumentList();
        if (typeArgumentList != null) {
            trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(typeArgumentList, expectedTypeArgumentCount));
        } else {
            trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(this.reference, expectedTypeArgumentCount));
        }
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
        trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
        trace.report(Errors.NONE_APPLICABLE.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
        trace.report(Errors.CANNOT_COMPLETE_RESOLVE.on(this.reference, descriptors));
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        trace.report(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(this.call.getCallElement()));
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull JetType type, boolean isCallForImplicitInvoke) {
        ASTNode callOperationNode = this.call.getCallOperationNode();
        if (callOperationNode != null && !isCallForImplicitInvoke) {
            trace.report(Errors.UNSAFE_CALL.on(callOperationNode.getPsi(), type));
        } else {
            PsiElement callElement = this.call.getCallElement();
            if (callElement instanceof JetBinaryExpression) {
                JetBinaryExpression binaryExpression = (JetBinaryExpression)callElement;
                JetSimpleNameExpression operationReference = binaryExpression.getOperationReference();
                Name operationString = operationReference.getReferencedNameElementType() == JetTokens.IDENTIFIER ? Name.identifier(operationReference.getText()) : OperatorConventions.getNameForOperationSymbol((JetToken)operationReference.getReferencedNameElementType());
                JetExpression left = binaryExpression.getLeft();
                JetExpression right = binaryExpression.getRight();
                if (left != null && right != null) {
                    trace.report(Errors.UNSAFE_INFIX_CALL.on(this.reference, left.getText(), operationString.asString(), right.getText()));
                }
            } else {
                trace.report(Errors.UNSAFE_CALL.on(this.reference, type));
            }
        }
    }

    @Override
    public void unnecessarySafeCall(@NotNull BindingTrace trace, @NotNull JetType type) {
        ASTNode callOperationNode = this.call.getCallOperationNode();
        assert (callOperationNode != null);
        trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type));
    }

    @Override
    public void danglingFunctionLiteralArgumentSuspected(@NotNull BindingTrace trace, @NotNull List<JetExpression> functionLiteralArguments) {
        for (JetExpression functionLiteralArgument : functionLiteralArguments) {
            trace.report(Errors.DANGLING_FUNCTION_LITERAL_ARGUMENT_SUSPECTED.on(functionLiteralArgument));
        }
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor) {
        trace.report(Errors.INVISIBLE_MEMBER.on(this.call.getCallElement(), descriptor, descriptor.getVisibility(), descriptor.getContainingDeclaration()));
    }

    @Override
    public void typeInferenceFailed(@NotNull BindingTrace trace, @NotNull InferenceErrorData.ExtendedInferenceErrorData data) {
        ConstraintSystem constraintSystem = data.constraintSystem;
        assert (!constraintSystem.isSuccessful()) : "Report error only for not successful constraint system";
        if (constraintSystem.hasErrorInConstrainingTypes()) {
            return;
        }
        if (constraintSystem.hasOnlyExpectedTypeMismatch()) {
            JetType declaredReturnType = data.descriptor.getReturnType();
            if (declaredReturnType == null) {
                return;
            }
            JetType substitutedReturnType = constraintSystem.getResultingSubstitutor().substitute(declaredReturnType, Variance.INVARIANT);
            assert (substitutedReturnType != null);
            assert (!TypeUtils.noExpectedType(data.expectedType)) : "Expected type doesn't exist, but there is an expected type mismatch error";
            trace.report(Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.on(this.reference, data.expectedType, substitutedReturnType));
        } else if (constraintSystem.hasTypeConstructorMismatch()) {
            trace.report(Errors.TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH.on(this.reference, data));
        } else if (constraintSystem.hasConflictingConstraints()) {
            trace.report(Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS.on(this.reference, data));
        } else {
            assert (constraintSystem.hasUnknownParameters());
            trace.report(Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER.on(this.reference, data));
        }
    }

    @Override
    public void upperBoundViolated(@NotNull BindingTrace trace, @NotNull InferenceErrorData inferenceErrorData) {
        trace.report(Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.on(this.reference, inferenceErrorData));
    }
}

