/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastServiceImpl;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollector;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTaskHolder;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class TaskPrioritizer {
    public static <D extends CallableDescriptor> void splitLexicallyLocalDescriptors(@NotNull Collection<ResolutionCandidate<D>> allDescriptors, @NotNull DeclarationDescriptor containerOfTheCurrentLocality, @NotNull Collection<ResolutionCandidate<D>> local, @NotNull Collection<ResolutionCandidate<D>> nonlocal) {
        for (ResolutionCandidate<D> resolvedCall : allDescriptors) {
            if (DescriptorUtils.isLocal(containerOfTheCurrentLocality, resolvedCall.getDescriptor())) {
                local.add(resolvedCall);
                continue;
            }
            nonlocal.add(resolvedCall);
        }
    }

    @Nullable
    public static JetSuperExpression getReceiverSuper(@NotNull ReceiverValue receiver) {
        ExpressionReceiver expressionReceiver;
        JetExpression expression;
        if (receiver instanceof ExpressionReceiver && (expression = (expressionReceiver = (ExpressionReceiver)receiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)expression;
        }
        return null;
    }

    @NotNull
    public static <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasks(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull JetReferenceExpression functionReference, @NotNull List<CallableDescriptorCollector<? extends D>> callableDescriptorCollectors) {
        JetScope scope;
        ReceiverValue explicitReceiver = context.call.getExplicitReceiver();
        if (explicitReceiver.exists() && explicitReceiver.getType() instanceof NamespaceType) {
            scope = explicitReceiver.getType().getMemberScope();
            explicitReceiver = ReceiverValue.NO_RECEIVER;
        } else {
            scope = context.scope;
        }
        ResolutionTaskHolder result = new ResolutionTaskHolder(functionReference, context, new MyPriorityProvider(context), null);
        TaskPrioritizerContext c = new TaskPrioritizerContext(name, result, context, scope, callableDescriptorCollectors);
        TaskPrioritizer.doComputeTasks(explicitReceiver, c);
        return result.getTasks();
    }

    private static <D extends CallableDescriptor, F extends D> void doComputeTasks(@NotNull ReceiverValue receiver, @NotNull TaskPrioritizerContext<D, F> c) {
        ProgressIndicatorProvider.checkCanceled();
        boolean resolveInvoke = c.context.call.getThisObject().exists();
        if (resolveInvoke) {
            TaskPrioritizer.addCandidatesForInvoke(receiver, c);
            return;
        }
        List<ReceiverValue> implicitReceivers = JetScopeUtils.getImplicitReceiversHierarchyValues(c.scope);
        if (receiver.exists()) {
            TaskPrioritizer.addCandidatesForExplicitReceiver(receiver, implicitReceivers, c, false);
            return;
        }
        TaskPrioritizer.addCandidatesForNoReceiver(implicitReceivers, c);
    }

    private static <D extends CallableDescriptor, F extends D> void addCandidatesForExplicitReceiver(@NotNull ReceiverValue receiver, @NotNull List<ReceiverValue> implicitReceivers, @NotNull TaskPrioritizerContext<D, F> c, boolean resolveInvoke) {
        List<ReceiverValue> variantsForExplicitReceiver = c.autoCastService.getVariantsForReceiver(receiver);
        for (CallableDescriptorCollector callableDescriptorCollector : c.callableDescriptorCollectors) {
            ArrayList members = Lists.newArrayList();
            for (ReceiverValue variant : variantsForExplicitReceiver) {
                Collection membersForThisVariant = callableDescriptorCollector.getMembersByName(variant.getType(), c.name, c.context.trace);
                TaskPrioritizer.convertWithReceivers(membersForThisVariant, Collections.singletonList(variant), Collections.singletonList(ReceiverValue.NO_RECEIVER), members, resolveInvoke);
            }
            c.result.addCandidates(members);
        }
        for (CallableDescriptorCollector callableDescriptorCollector : c.callableDescriptorCollectors) {
            for (ReceiverValue implicitReceiver : implicitReceivers) {
                TaskPrioritizer.addMemberExtensionCandidates(implicitReceiver, variantsForExplicitReceiver, callableDescriptorCollector, c, resolveInvoke);
            }
            Collection extensions = TaskPrioritizer.convertWithImpliedThis(c.scope, variantsForExplicitReceiver, callableDescriptorCollector.getNonMembersByName(c.scope, c.name, c.context.trace));
            c.result.addCandidates(extensions);
        }
    }

    private static <D extends CallableDescriptor, F extends D> void addMemberExtensionCandidates(@NotNull ReceiverValue implicitReceiver, @NotNull List<ReceiverValue> variantsForExplicitReceiver, @NotNull CallableDescriptorCollector<? extends D> callableDescriptorCollector, TaskPrioritizerContext<D, F> c, boolean resolveInvoke) {
        Collection<? extends D> memberExtensions = callableDescriptorCollector.getNonMembersByName(implicitReceiver.getType().getMemberScope(), c.name, c.context.trace);
        List<ReceiverValue> variantsForImplicitReceiver = c.autoCastService.getVariantsForReceiver(implicitReceiver);
        c.result.addCandidates(TaskPrioritizer.convertWithReceivers(memberExtensions, variantsForImplicitReceiver, variantsForExplicitReceiver, resolveInvoke));
    }

    private static <D extends CallableDescriptor, F extends D> void addCandidatesForNoReceiver(@NotNull List<ReceiverValue> implicitReceivers, @NotNull TaskPrioritizerContext<D, F> c) {
        ArrayList localsList = Lists.newArrayList();
        ArrayList nonlocalsList = Lists.newArrayList();
        for (CallableDescriptorCollector callableDescriptorCollector : c.callableDescriptorCollectors) {
            Collection<ResolutionCandidate<D>> members = TaskPrioritizer.convertWithImpliedThis(c.scope, Collections.singletonList(ReceiverValue.NO_RECEIVER), callableDescriptorCollector.getNonExtensionsByName(c.scope, c.name, c.context.trace));
            ArrayList<ResolutionCandidate<D>> nonlocals = Lists.newArrayList();
            ArrayList<ResolutionCandidate<D>> locals = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(members, c.scope.getContainingDeclaration(), locals, nonlocals);
            localsList.add(locals);
            nonlocalsList.add(nonlocals);
        }
        c.result.addCandidates(localsList);
        for (ReceiverValue implicitReceiver : implicitReceivers) {
            TaskPrioritizer.addCandidatesForExplicitReceiver(implicitReceiver, implicitReceivers, c, false);
        }
        c.result.addCandidates(nonlocalsList);
    }

    private static <D extends CallableDescriptor, F extends D> void addCandidatesForInvoke(@NotNull ReceiverValue explicitReceiver, @NotNull TaskPrioritizerContext<D, F> c) {
        List<ReceiverValue> implicitReceivers = JetScopeUtils.getImplicitReceiversHierarchyValues(c.scope);
        ReceiverValue variableReceiver = c.context.call.getThisObject();
        assert (variableReceiver.exists()) : "'Invoke' call hasn't got variable receiver";
        if (!explicitReceiver.exists()) {
            TaskPrioritizer.addCandidatesForExplicitReceiver(variableReceiver, implicitReceivers, c, true);
        }
        if (explicitReceiver.exists()) {
            TaskPrioritizer.addCandidatesWhenInvokeIsMemberExtensionToExplicitReceiver(variableReceiver, explicitReceiver, c);
            return;
        }
        for (ReceiverValue implicitReceiver : implicitReceivers) {
            TaskPrioritizer.addCandidatesWhenInvokeIsMemberExtensionToExplicitReceiver(variableReceiver, implicitReceiver, c);
        }
    }

    private static <D extends CallableDescriptor, F extends D> void addCandidatesWhenInvokeIsMemberExtensionToExplicitReceiver(@NotNull ReceiverValue variableReceiver, @NotNull ReceiverValue explicitReceiver, @NotNull TaskPrioritizerContext<D, F> c) {
        List<ReceiverValue> variantsForExplicitReceiver = c.autoCastService.getVariantsForReceiver(explicitReceiver);
        for (CallableDescriptorCollector callableDescriptorCollector : c.callableDescriptorCollectors) {
            TaskPrioritizer.addMemberExtensionCandidates(variableReceiver, variantsForExplicitReceiver, callableDescriptorCollector, c, true);
        }
    }

    private static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithReceivers(@NotNull Collection<? extends D> descriptors, @NotNull Iterable<ReceiverValue> thisObjects, @NotNull Iterable<ReceiverValue> receiverParameters, boolean hasExplicitThisObject) {
        ArrayList<ResolutionCandidate<D>> result = Lists.newArrayList();
        TaskPrioritizer.convertWithReceivers(descriptors, thisObjects, receiverParameters, result, hasExplicitThisObject);
        return result;
    }

    private static <D extends CallableDescriptor> void convertWithReceivers(@NotNull Collection<? extends D> descriptors, @NotNull Iterable<ReceiverValue> thisObjects, @NotNull Iterable<ReceiverValue> receiverParameters, @NotNull Collection<ResolutionCandidate<D>> result, boolean hasExplicitThisObject) {
        for (ReceiverValue thisObject : thisObjects) {
            for (ReceiverValue receiverParameter : receiverParameters) {
                for (CallableDescriptor extension : descriptors) {
                    if (DescriptorUtils.isConstructorOfStaticNestedClass(extension)) continue;
                    ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(extension);
                    candidate.setThisObject(thisObject);
                    candidate.setReceiverArgument(receiverParameter);
                    candidate.setExplicitReceiverKind(hasExplicitThisObject ? ExplicitReceiverKind.BOTH_RECEIVERS : ExplicitReceiverKind.THIS_OBJECT);
                    result.add(candidate);
                }
            }
        }
    }

    public static <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThis(@NotNull JetScope scope, @NotNull Collection<ReceiverValue> receiverParameters, @NotNull Collection<? extends D> descriptors) {
        ArrayList<ResolutionCandidate<D>> result = Lists.newArrayList();
        for (ReceiverValue receiverParameter : receiverParameters) {
            for (CallableDescriptor descriptor : descriptors) {
                ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(descriptor);
                candidate.setReceiverArgument(receiverParameter);
                candidate.setExplicitReceiverKind(receiverParameter.exists() ? ExplicitReceiverKind.RECEIVER_ARGUMENT : ExplicitReceiverKind.NO_EXPLICIT_RECEIVER);
                if (!TaskPrioritizer.setImpliedThis(scope, candidate)) continue;
                result.add(candidate);
            }
        }
        if (receiverParameters.size() == 1 && !receiverParameters.iterator().next().exists()) {
            for (CallableDescriptor descriptor : descriptors) {
                if (descriptor.getExpectedThisObject() == null || descriptor.getReceiverParameter() != null) continue;
                DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
                if (descriptor instanceof ConstructorDescriptor) {
                    containingDeclaration = containingDeclaration.getContainingDeclaration();
                }
                if (containingDeclaration == null || !DescriptorUtils.isClassObject(containingDeclaration)) continue;
                ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(descriptor);
                candidate.setThisObject(((ClassDescriptor)containingDeclaration).getThisAsReceiverParameter().getValue());
                candidate.setExplicitReceiverKind(ExplicitReceiverKind.NO_EXPLICIT_RECEIVER);
                result.add(candidate);
            }
        }
        return result;
    }

    private static <D extends CallableDescriptor> boolean setImpliedThis(@NotNull JetScope scope, @NotNull ResolutionCandidate<D> candidate) {
        ReceiverParameterDescriptor expectedThisObject = candidate.getDescriptor().getExpectedThisObject();
        if (expectedThisObject == null) {
            return true;
        }
        List<ReceiverParameterDescriptor> receivers = scope.getImplicitReceiversHierarchy();
        for (ReceiverParameterDescriptor receiver : receivers) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(receiver.getType(), expectedThisObject.getType())) continue;
            candidate.setThisObject(expectedThisObject.getValue());
            return true;
        }
        return false;
    }

    public static <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasksFromCandidates(@NotNull BasicCallResolutionContext context, @NotNull JetReferenceExpression functionReference, @NotNull Collection<ResolutionCandidate<D>> candidates, @Nullable TracingStrategy tracing) {
        ResolutionTaskHolder result = new ResolutionTaskHolder(functionReference, context, new MyPriorityProvider(context), tracing);
        result.addCandidates(candidates);
        return result.getTasks();
    }

    private static class TaskPrioritizerContext<D extends CallableDescriptor, F extends D> {
        @NotNull
        public final Name name;
        @NotNull
        public final ResolutionTaskHolder<D, F> result;
        @NotNull
        public final BasicCallResolutionContext context;
        @NotNull
        public final JetScope scope;
        @NotNull
        public final List<CallableDescriptorCollector<? extends D>> callableDescriptorCollectors;
        @NotNull
        AutoCastServiceImpl autoCastService;

        private TaskPrioritizerContext(@NotNull Name name, @NotNull ResolutionTaskHolder<D, F> result, @NotNull BasicCallResolutionContext context, @NotNull JetScope scope, @NotNull List<CallableDescriptorCollector<? extends D>> callableDescriptorCollectors) {
            this.name = name;
            this.result = result;
            this.context = context;
            this.scope = scope;
            this.callableDescriptorCollectors = callableDescriptorCollectors;
            this.autoCastService = new AutoCastServiceImpl(context.dataFlowInfo, context.trace.getBindingContext());
        }
    }

    private static class MyPriorityProvider<D extends CallableDescriptor>
    implements ResolutionTaskHolder.PriorityProvider<ResolutionCandidate<D>> {
        private final BasicCallResolutionContext context;

        public MyPriorityProvider(BasicCallResolutionContext context) {
            this.context = context;
        }

        @Override
        public int getPriority(ResolutionCandidate<D> call) {
            return (this.isVisible(call) ? 2 : 0) + (this.isSynthesized(call) ? 0 : 1);
        }

        @Override
        public int getMaxPriority() {
            return 3;
        }

        private boolean isVisible(ResolutionCandidate<D> call) {
            if (call == null) {
                return false;
            }
            D candidateDescriptor = call.getDescriptor();
            if (ErrorUtils.isError(candidateDescriptor)) {
                return true;
            }
            return Visibilities.isVisible(candidateDescriptor, this.context.scope.getContainingDeclaration());
        }

        private boolean isSynthesized(ResolutionCandidate<D> call) {
            D descriptor = call.getDescriptor();
            return descriptor instanceof CallableMemberDescriptor && CallResolverUtil.isOrOverridesSynthesized((CallableMemberDescriptor)descriptor);
        }
    }
}

