/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraints;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraintsImpl;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;
import org.jetbrains.jet.lang.types.checker.TypingConstraints;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ConstraintSystemImpl
implements ConstraintSystem {
    private final Map<TypeParameterDescriptor, TypeConstraintsImpl> typeParameterConstraints = Maps.newLinkedHashMap();
    private final Set<ConstraintPosition> errorConstraintPositions = Sets.newHashSet();
    private final TypeSubstitutor resultingSubstitutor = this.createTypeSubstitutorWithDefaultForUnknownTypeParameter(new TypeProjection(CallResolverUtil.CANT_INFER_TYPE_PARAMETER));
    private final TypeSubstitutor currentSubstitutor = this.createTypeSubstitutorWithDefaultForUnknownTypeParameter(new TypeProjection(CallResolverUtil.DONT_CARE));
    private boolean hasErrorInConstrainingTypes;
    @Nullable
    private ConstraintSystem systemWithoutExpectedTypeConstraint;

    private TypeSubstitutor createTypeSubstitutorWithDefaultForUnknownTypeParameter(final @Nullable TypeProjection defaultTypeProjection) {
        return TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                ClassifierDescriptor declarationDescriptor = key.getDeclarationDescriptor();
                if (declarationDescriptor instanceof TypeParameterDescriptor) {
                    TypeParameterDescriptor descriptor = (TypeParameterDescriptor)declarationDescriptor;
                    JetType value = ConstraintsUtil.getValue(ConstraintSystemImpl.this.getTypeConstraints(descriptor));
                    if (value != null && !TypeUtils.equalsOrContainsAsArgument(value, CallResolverUtil.DONT_CARE)) {
                        return new TypeProjection(value);
                    }
                    if (ConstraintSystemImpl.this.typeParameterConstraints.containsKey(descriptor)) {
                        return defaultTypeProjection;
                    }
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            public String toString() {
                return ConstraintSystemImpl.this.typeParameterConstraints.toString();
            }
        });
    }

    @Override
    public boolean hasTypeConstructorMismatch() {
        return !this.errorConstraintPositions.isEmpty();
    }

    @Override
    public boolean hasTypeConstructorMismatchAt(@NotNull ConstraintPosition constraintPosition) {
        return this.errorConstraintPositions.contains(constraintPosition);
    }

    @Override
    public boolean hasOnlyExpectedTypeMismatch() {
        if (this.systemWithoutExpectedTypeConstraint == null) {
            return false;
        }
        if (!this.isSuccessful() && this.systemWithoutExpectedTypeConstraint.isSuccessful()) {
            return true;
        }
        return this.errorConstraintPositions.size() == 1 && this.errorConstraintPositions.contains(ConstraintPosition.EXPECTED_TYPE_POSITION);
    }

    @Override
    public boolean hasErrorInConstrainingTypes() {
        return this.hasErrorInConstrainingTypes;
    }

    @Override
    public void registerTypeVariable(@NotNull TypeParameterDescriptor typeVariable, @NotNull Variance positionVariance) {
        this.typeParameterConstraints.put(typeVariable, new TypeConstraintsImpl(positionVariance));
    }

    @Override
    @NotNull
    public ConstraintSystem copy() {
        return this.replaceTypeVariables(Functions.<TypeParameterDescriptor>identity(), true);
    }

    @NotNull
    public ConstraintSystem replaceTypeVariables(@NotNull Function<TypeParameterDescriptor, TypeParameterDescriptor> typeVariablesMap) {
        return this.replaceTypeVariables(typeVariablesMap, false);
    }

    @NotNull
    private ConstraintSystem replaceTypeVariables(@NotNull Function<TypeParameterDescriptor, TypeParameterDescriptor> typeVariablesMap, boolean recreateTypeConstraints) {
        ConstraintSystemImpl newConstraintSystem = new ConstraintSystemImpl();
        for (Map.Entry<TypeParameterDescriptor, TypeConstraintsImpl> entry : this.typeParameterConstraints.entrySet()) {
            TypeParameterDescriptor typeParameter = entry.getKey();
            TypeConstraintsImpl typeConstraints = entry.getValue();
            TypeParameterDescriptor newTypeParameter = typeVariablesMap.apply(typeParameter);
            assert (newTypeParameter != null);
            newConstraintSystem.typeParameterConstraints.put(newTypeParameter, recreateTypeConstraints ? typeConstraints.copy() : typeConstraints);
        }
        newConstraintSystem.errorConstraintPositions.addAll(this.errorConstraintPositions);
        newConstraintSystem.hasErrorInConstrainingTypes = this.hasErrorInConstrainingTypes;
        return newConstraintSystem;
    }

    @Override
    public void addSupertypeConstraint(@Nullable JetType constrainingType, @NotNull JetType subjectType, @NotNull ConstraintPosition constraintPosition) {
        if (constrainingType != null && TypeUtils.noExpectedType(constrainingType)) {
            return;
        }
        if (constraintPosition == ConstraintPosition.EXPECTED_TYPE_POSITION) {
            this.systemWithoutExpectedTypeConstraint = this.copy();
        }
        this.addConstraint(ConstraintKind.SUB_TYPE, subjectType, constrainingType, constraintPosition);
    }

    @Override
    public void addSubtypeConstraint(@Nullable JetType constrainingType, @NotNull JetType subjectType, @NotNull ConstraintPosition constraintPosition) {
        this.addConstraint(ConstraintKind.SUB_TYPE, constrainingType, subjectType, constraintPosition);
    }

    private void addConstraint(@NotNull ConstraintKind constraintKind, @Nullable JetType subType, @Nullable JetType superType, final @NotNull ConstraintPosition constraintPosition) {
        TypeCheckingProcedure typeCheckingProcedure = new TypeCheckingProcedure(new TypingConstraints(){

            @Override
            public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                ConstraintSystemImpl.this.doAddConstraint(ConstraintKind.EQUAL, a, b, constraintPosition, typeCheckingProcedure);
                return true;
            }

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
                throw new IllegalStateException("'assertEqualTypeConstructors' shouldn't be invoked inside 'isSubtypeOf'");
            }

            @Override
            public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                ConstraintSystemImpl.this.doAddConstraint(ConstraintKind.SUB_TYPE, subtype, supertype, constraintPosition, typeCheckingProcedure);
                return true;
            }

            @Override
            public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
                ConstraintSystemImpl.this.errorConstraintPositions.add(constraintPosition);
                return true;
            }
        });
        this.doAddConstraint(constraintKind, subType, superType, constraintPosition, typeCheckingProcedure);
    }

    private boolean isErrorOrSpecialType(@Nullable JetType type) {
        if (type == CallResolverUtil.DONT_CARE || type == CallResolverUtil.CANT_INFER_TYPE_PARAMETER) {
            return true;
        }
        if (type == null || ErrorUtils.isErrorType(type) && type != CallResolverUtil.PLACEHOLDER_FUNCTION_TYPE) {
            this.hasErrorInConstrainingTypes = true;
            return true;
        }
        return false;
    }

    private void doAddConstraint(@NotNull ConstraintKind constraintKind, @Nullable JetType subType, @Nullable JetType superType, @NotNull ConstraintPosition constraintPosition, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
        if (this.isErrorOrSpecialType(subType) || this.isErrorOrSpecialType(superType)) {
            return;
        }
        assert (subType != null && superType != null);
        assert (superType != CallResolverUtil.PLACEHOLDER_FUNCTION_TYPE) : "The type for " + constraintPosition + " shouldn't be a placeholder for function type";
        KotlinBuiltIns kotlinBuiltIns = KotlinBuiltIns.getInstance();
        if (subType == CallResolverUtil.PLACEHOLDER_FUNCTION_TYPE) {
            if (!kotlinBuiltIns.isFunctionOrExtensionFunctionType(superType)) {
                if (this.isMyTypeVariable(superType)) {
                    return;
                }
                this.errorConstraintPositions.add(constraintPosition);
            }
            return;
        }
        if (constraintKind == ConstraintKind.SUB_TYPE && kotlinBuiltIns.isFunctionType(subType) && kotlinBuiltIns.isExtensionFunctionType(superType)) {
            subType = ConstraintSystemImpl.createCorrespondingExtensionFunctionType(subType, CallResolverUtil.DONT_CARE);
        }
        if (((Object)subType).equals(superType)) {
            return;
        }
        assert (!this.isMyTypeVariable(subType) || !this.isMyTypeVariable(superType)) : "The constraint shouldn't contain different type variables on both sides: " + subType + " <: " + superType;
        if (this.isMyTypeVariable(subType)) {
            this.generateTypeParameterConstraint(subType, superType, constraintKind == ConstraintKind.SUB_TYPE ? TypeConstraintsImpl.BoundKind.UPPER_BOUND : TypeConstraintsImpl.BoundKind.EXACT_BOUND);
            return;
        }
        if (this.isMyTypeVariable(superType)) {
            this.generateTypeParameterConstraint(superType, subType, constraintKind == ConstraintKind.SUB_TYPE ? TypeConstraintsImpl.BoundKind.LOWER_BOUND : TypeConstraintsImpl.BoundKind.EXACT_BOUND);
            return;
        }
        typeCheckingProcedure.isSubtypeOf(TypeUtils.makeNotNullable(subType), TypeUtils.makeNotNullable(superType));
    }

    private void generateTypeParameterConstraint(@NotNull JetType parameterType, @NotNull JetType constrainingType, @NotNull TypeConstraintsImpl.BoundKind boundKind) {
        TypeConstraintsImpl typeConstraints = this.getTypeConstraints(parameterType);
        assert (typeConstraints != null) : "constraint should be generated only for type variables";
        if (parameterType.isNullable()) {
            constrainingType = TypeUtils.makeNotNullable(constrainingType);
        }
        typeConstraints.addBound(boundKind, constrainingType);
    }

    public void processDeclaredBoundConstraints() {
        for (Map.Entry<TypeParameterDescriptor, TypeConstraintsImpl> entry : this.typeParameterConstraints.entrySet()) {
            TypeParameterDescriptor typeParameterDescriptor = entry.getKey();
            TypeConstraintsImpl typeConstraints = entry.getValue();
            for (JetType declaredUpperBound : typeParameterDescriptor.getUpperBounds()) {
                for (JetType lowerOrExactBound : Sets.union(typeConstraints.getLowerBounds(), typeConstraints.getExactBounds())) {
                    this.addSubtypeConstraint(lowerOrExactBound, declaredUpperBound, ConstraintPosition.BOUND_CONSTRAINT_POSITION);
                }
            }
        }
    }

    @Override
    @NotNull
    public Set<TypeParameterDescriptor> getTypeVariables() {
        return this.typeParameterConstraints.keySet();
    }

    @Override
    @Nullable
    public TypeConstraints getTypeConstraints(@NotNull TypeParameterDescriptor typeVariable) {
        return this.typeParameterConstraints.get(typeVariable);
    }

    @Nullable
    private TypeConstraintsImpl getTypeConstraints(@NotNull JetType type) {
        ClassifierDescriptor parameterDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (parameterDescriptor instanceof TypeParameterDescriptor) {
            return this.typeParameterConstraints.get(parameterDescriptor);
        }
        return null;
    }

    private boolean isMyTypeVariable(@NotNull JetType type) {
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof TypeParameterDescriptor && this.typeParameterConstraints.get(descriptor) != null;
    }

    @Override
    public boolean isSuccessful() {
        return !this.hasContradiction() && !this.hasUnknownParameters();
    }

    @Override
    public boolean hasContradiction() {
        return this.hasTypeConstructorMismatch() || this.hasConflictingConstraints();
    }

    @Override
    public boolean hasConflictingConstraints() {
        for (TypeParameterDescriptor typeParameter : this.typeParameterConstraints.keySet()) {
            TypeConstraints typeConstraints = this.getTypeConstraints(typeParameter);
            if (typeConstraints == null || ConstraintsUtil.getValues(typeConstraints).size() <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUnknownParameters() {
        for (TypeConstraintsImpl constraints : this.typeParameterConstraints.values()) {
            if (!constraints.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public TypeSubstitutor getResultingSubstitutor() {
        if (this.hasOnlyExpectedTypeMismatch()) {
            assert (this.systemWithoutExpectedTypeConstraint != null);
            return this.systemWithoutExpectedTypeConstraint.getResultingSubstitutor();
        }
        return this.resultingSubstitutor;
    }

    @Override
    @NotNull
    public TypeSubstitutor getCurrentSubstitutor() {
        return this.currentSubstitutor;
    }

    @NotNull
    public static JetType createCorrespondingExtensionFunctionType(@NotNull JetType functionType, @NotNull JetType receiverType) {
        assert (KotlinBuiltIns.getInstance().isFunctionType(functionType));
        List<TypeProjection> typeArguments = functionType.getArguments();
        assert (!typeArguments.isEmpty());
        ArrayList<JetType> arguments = Lists.newArrayList();
        int index = 0;
        int lastIndex = typeArguments.size() - 1;
        for (TypeProjection typeArgument : typeArguments) {
            if (index < lastIndex) {
                arguments.add(typeArgument.getType());
            }
            ++index;
        }
        JetType returnType = typeArguments.get(lastIndex).getType();
        return KotlinBuiltIns.getInstance().getFunctionType(functionType.getAnnotations(), receiverType, arguments, returnType);
    }

    public static enum ConstraintKind {
        SUB_TYPE,
        EQUAL;

    }
}

