/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.CallKey;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCacheImpl;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;

public class TemporaryResolutionResultsCache
implements ResolutionResultsCache {
    private final ResolutionResultsCache parentCache;
    private final ResolutionResultsCacheImpl innerCache;

    public TemporaryResolutionResultsCache(@NotNull ResolutionResultsCache parentCache) {
        assert (parentCache instanceof ResolutionResultsCacheImpl || parentCache instanceof TemporaryResolutionResultsCache) : "Unsupported parent cache: " + parentCache;
        this.parentCache = parentCache;
        this.innerCache = new ResolutionResultsCacheImpl();
    }

    @Override
    public <D extends CallableDescriptor> void recordResolutionResults(@NotNull CallKey callKey, @NotNull ResolutionResultsCache.MemberType<D> memberType, @NotNull OverloadResolutionResultsImpl<D> results) {
        this.innerCache.recordResolutionResults(callKey, memberType, results);
    }

    @Override
    @Nullable
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> getResolutionResults(@NotNull CallKey callKey, @NotNull ResolutionResultsCache.MemberType<D> memberType) {
        OverloadResolutionResultsImpl<D> results = this.innerCache.getResolutionResults(callKey, memberType);
        if (results != null) {
            return results;
        }
        return this.parentCache.getResolutionResults(callKey, memberType);
    }

    @Override
    public void recordResolutionTrace(@NotNull CallKey callKey, @NotNull DelegatingBindingTrace delegatingTrace) {
        this.innerCache.recordResolutionTrace(callKey, delegatingTrace);
    }

    @Override
    @Nullable
    public DelegatingBindingTrace getResolutionTrace(@NotNull CallKey callKey) {
        DelegatingBindingTrace trace = this.innerCache.getResolutionTrace(callKey);
        if (trace != null) {
            return trace;
        }
        return this.parentCache.getResolutionTrace(callKey);
    }

    @Override
    public <D extends CallableDescriptor> void recordDeferredComputationForCall(@NotNull CallKey callKey, @NotNull CallCandidateResolutionContext<D> deferredComputation, @NotNull ResolutionResultsCache.MemberType memberType) {
        this.innerCache.recordDeferredComputationForCall(callKey, deferredComputation, memberType);
    }

    @Override
    @Nullable
    public CallCandidateResolutionContext<FunctionDescriptor> getDeferredComputation(@Nullable JetExpression expression) {
        CallCandidateResolutionContext<FunctionDescriptor> computation = this.innerCache.getDeferredComputation(expression);
        if (computation != null) {
            return computation;
        }
        return this.parentCache.getDeferredComputation(expression);
    }

    public void commit() {
        if (this.parentCache instanceof ResolutionResultsCacheImpl) {
            ((ResolutionResultsCacheImpl)this.parentCache).addData(this.innerCache);
            return;
        }
        assert (this.parentCache instanceof TemporaryResolutionResultsCache);
        ((TemporaryResolutionResultsCache)this.parentCache).innerCache.addData(this.innerCache);
    }
}

