/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;

public abstract class ResolutionContext<Context extends ResolutionContext<Context>> {
    public final BindingTrace trace;
    public final JetScope scope;
    public final JetType expectedType;
    public final DataFlowInfo dataFlowInfo;
    public final ExpressionPosition expressionPosition;
    public final ContextDependency contextDependency;
    public final ResolutionResultsCache resolutionResultsCache;
    public final LabelResolver labelResolver;

    protected ResolutionContext(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ExpressionPosition expressionPosition, @NotNull ContextDependency contextDependency, @NotNull ResolutionResultsCache resolutionResultsCache, @NotNull LabelResolver labelResolver) {
        this.trace = trace;
        this.scope = scope;
        this.expectedType = expectedType;
        this.dataFlowInfo = dataFlowInfo;
        this.expressionPosition = expressionPosition;
        this.contextDependency = contextDependency;
        this.resolutionResultsCache = resolutionResultsCache;
        this.labelResolver = labelResolver;
    }

    protected abstract Context create(@NotNull BindingTrace var1, @NotNull JetScope var2, @NotNull DataFlowInfo var3, @NotNull JetType var4, @NotNull ExpressionPosition var5, @NotNull ContextDependency var6, @NotNull ResolutionResultsCache var7, @NotNull LabelResolver var8);

    protected abstract Context self();

    public Context replaceBindingTrace(@NotNull BindingTrace trace) {
        if (this.trace == trace) {
            return this.self();
        }
        return this.create(trace, this.scope, this.dataFlowInfo, this.expectedType, this.expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
    }

    @NotNull
    public Context replaceExpressionPosition(@NotNull ExpressionPosition expressionPosition) {
        if (expressionPosition == this.expressionPosition) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
    }

    @NotNull
    public Context replaceDataFlowInfo(@NotNull DataFlowInfo newDataFlowInfo) {
        if (newDataFlowInfo == this.dataFlowInfo) {
            return this.self();
        }
        return this.create(this.trace, this.scope, newDataFlowInfo, this.expectedType, this.expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
    }

    @NotNull
    public Context replaceExpectedType(@Nullable JetType newExpectedType) {
        if (newExpectedType == null) {
            return this.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        }
        if (this.expectedType == newExpectedType) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, newExpectedType, this.expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
    }

    @NotNull
    public Context replaceScope(@NotNull JetScope newScope) {
        if (newScope == this.scope) {
            return this.self();
        }
        return this.create(this.trace, newScope, this.dataFlowInfo, this.expectedType, this.expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
    }

    @NotNull
    public Context replaceContextDependency(@NotNull ContextDependency newContextDependency) {
        if (newContextDependency == this.contextDependency) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.expressionPosition, newContextDependency, this.resolutionResultsCache, this.labelResolver);
    }

    @NotNull
    public Context replaceResolutionResultsCache(@NotNull ResolutionResultsCache newResolutionResultsCache) {
        if (newResolutionResultsCache == this.resolutionResultsCache) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.expressionPosition, this.contextDependency, newResolutionResultsCache, this.labelResolver);
    }

    public Context replaceTraceAndCache(@NotNull TemporaryTraceAndCache traceAndCache) {
        return ((ResolutionContext)this.replaceBindingTrace(traceAndCache.trace)).replaceResolutionResultsCache(traceAndCache.cache);
    }
}

