/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.types.CastDiagnosticsUtil;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeReconstructionResult;
import org.jetbrains.jet.lang.types.TypeUtils;

public class PossiblyBareType {
    private final JetType actualType;
    private final TypeConstructor bareTypeConstructor;
    private final boolean nullable;

    @NotNull
    public static PossiblyBareType bare(@NotNull TypeConstructor bareTypeConstructor, boolean nullable) {
        return new PossiblyBareType(null, bareTypeConstructor, nullable);
    }

    @NotNull
    public static PossiblyBareType type(@NotNull JetType actualType) {
        return new PossiblyBareType(actualType, null, false);
    }

    private PossiblyBareType(@Nullable JetType actualType, @Nullable TypeConstructor bareTypeConstructor, boolean nullable) {
        this.actualType = actualType;
        this.bareTypeConstructor = bareTypeConstructor;
        this.nullable = nullable;
    }

    public boolean isBare() {
        return this.actualType == null;
    }

    @NotNull
    public JetType getActualType() {
        return this.actualType;
    }

    @NotNull
    public TypeConstructor getBareTypeConstructor() {
        return this.bareTypeConstructor;
    }

    private boolean isBareTypeNullable() {
        return this.nullable;
    }

    public boolean isNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable();
        }
        return this.getActualType().isNullable();
    }

    public PossiblyBareType makeNullable() {
        if (this.isBare()) {
            return this.isBareTypeNullable() ? this : PossiblyBareType.bare(this.getBareTypeConstructor(), true);
        }
        return PossiblyBareType.type(TypeUtils.makeNullable(this.getActualType()));
    }

    @NotNull
    public TypeReconstructionResult reconstruct(@NotNull JetType subjectType) {
        if (!this.isBare()) {
            return new TypeReconstructionResult(this.getActualType(), true);
        }
        TypeReconstructionResult reconstructionResult = CastDiagnosticsUtil.findStaticallyKnownSubtype(TypeUtils.makeNotNullable(subjectType), this.getBareTypeConstructor());
        JetType type = reconstructionResult.getResultingType();
        if (type == null) {
            return reconstructionResult;
        }
        JetType resultingType = TypeUtils.makeNullableAsSpecified(type, this.isBareTypeNullable());
        return new TypeReconstructionResult(resultingType, reconstructionResult.isAllArgumentsInferred());
    }

    public String toString() {
        return this.isBare() ? "bare " + this.bareTypeConstructor + (this.isBareTypeNullable() ? "?" : "") : this.getActualType().toString();
    }
}

