/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.util.slicedmap.MutableSlicedMap;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.SlicedMapImpl;
import org.jetbrains.jet.util.slicedmap.TrackingSlicedMap;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class BindingTraceContext
implements BindingTrace {
    private final List<Diagnostic> diagnostics = Lists.newArrayList();
    private final MutableSlicedMap map;
    private final BindingContext bindingContext = new BindingContext(){

        @Override
        @NotNull
        public Collection<Diagnostic> getDiagnostics() {
            return BindingTraceContext.this.diagnostics;
        }

        @Override
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            return BindingTraceContext.this.get(slice, key);
        }

        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            return BindingTraceContext.this.getKeys(slice);
        }

        @Override
        @NotNull
        public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
            return BindingTraceContext.this.map.getSliceContents(slice);
        }
    };

    public BindingTraceContext() {
        this.map = SlicedMapImpl.create();
    }

    private BindingTraceContext(MutableSlicedMap map) {
        this.map = map;
    }

    public static BindingTraceContext createTraceableBindingTrace() {
        return new BindingTraceContext(new TrackingSlicedMap(true));
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        this.diagnostics.add(diagnostic);
    }

    public void clearDiagnostics() {
        this.diagnostics.clear();
    }

    @Override
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
        this.map.put(slice, key, value);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.map.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        return this.map.getKeys(slice);
    }
}

