/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class AnnotationUtils {
    public static void checkConstructorParametersType(@NotNull List<JetParameter> parameters, @NotNull BindingTrace trace) {
        for (JetParameter parameter : parameters) {
            VariableDescriptor parameterDescriptor = trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
            if (parameterDescriptor == null) continue;
            JetType parameterType = parameterDescriptor.getType();
            JetTypeReference typeReference = parameter.getTypeReference();
            if (typeReference == null) continue;
            if (parameterType.isNullable()) {
                trace.report(Errors.NULLABLE_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
                continue;
            }
            if (AnnotationUtils.isAcceptableTypeForAnnotationParameter(parameterType)) continue;
            trace.report(Errors.INVALID_TYPE_OF_ANNOTATION_MEMBER.on(typeReference));
        }
    }

    private static boolean isAcceptableTypeForAnnotationParameter(@NotNull JetType parameterType) {
        List<TypeProjection> arguments;
        ClassDescriptor typeDescriptor = TypeUtils.getClassDescriptor(parameterType);
        if (typeDescriptor == null) {
            return false;
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (DescriptorUtils.isEnumClass(typeDescriptor) || DescriptorUtils.isAnnotationClass(typeDescriptor) || AnnotationUtils.isJavaLangClass(typeDescriptor) || builtIns.isPrimitiveArray(parameterType) || builtIns.isPrimitiveType(parameterType) || ((Object)builtIns.getStringType()).equals(parameterType)) {
            return true;
        }
        if (builtIns.isArray(parameterType) && (arguments = parameterType.getArguments()).size() == 1) {
            JetType arrayType = arguments.get(0).getType();
            if (arrayType.isNullable()) {
                return false;
            }
            ClassDescriptor arrayTypeDescriptor = TypeUtils.getClassDescriptor(arrayType);
            if (arrayTypeDescriptor != null) {
                return DescriptorUtils.isEnumClass(arrayTypeDescriptor) || DescriptorUtils.isAnnotationClass(arrayTypeDescriptor) || AnnotationUtils.isJavaLangClass(arrayTypeDescriptor) || ((Object)builtIns.getStringType()).equals(arrayType);
            }
        }
        return false;
    }

    public static boolean isArrayMethodCall(@NotNull ResolvedCall resolvedCall) {
        List<AnnotationDescriptor> annotations = resolvedCall.getResultingDescriptor().getOriginal().getAnnotations();
        if (annotations != null) {
            for (AnnotationDescriptor annotation : annotations) {
                if (!"Intrinsic".equals(annotation.getType().getConstructor().getDeclarationDescriptor().getName().asString())) continue;
                return "kotlin.arrays.array".equals(annotation.getAllValueArguments().values().iterator().next().getValue());
            }
        }
        return false;
    }

    public static boolean isJavaClassMethodCall(@NotNull ResolvedCall resolvedCall) {
        List<AnnotationDescriptor> annotations = resolvedCall.getResultingDescriptor().getOriginal().getAnnotations();
        if (annotations != null) {
            for (AnnotationDescriptor annotation : annotations) {
                if (!"Intrinsic".equals(annotation.getType().getConstructor().getDeclarationDescriptor().getName().asString())) continue;
                return "kotlin.javaClass.function".equals(annotation.getAllValueArguments().values().iterator().next().getValue());
            }
        }
        return false;
    }

    public static boolean isPropertyAcceptableAsAnnotationParameter(@NotNull PropertyDescriptor descriptor) {
        if (descriptor.isVar()) {
            return false;
        }
        if (DescriptorUtils.isClassObject(descriptor.getContainingDeclaration()) || DescriptorUtils.isTopLevelDeclaration(descriptor)) {
            JetType type = descriptor.getType();
            return KotlinBuiltIns.getInstance().isPrimitiveType(type) || ((Object)KotlinBuiltIns.getInstance().getStringType()).equals(type);
        }
        return false;
    }

    private static boolean isJavaLangClass(ClassDescriptor descriptor) {
        return "java.lang.Class".equals(DescriptorUtils.getFQName(descriptor).asString());
    }

    private AnnotationUtils() {
    }
}

