/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.MutableValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements MutableValueParameterDescriptor {
    private Boolean hasDefaultValue;
    private final boolean declaresDefaultValue;
    private final JetType varargElementType;
    private final int index;
    private final ValueParameterDescriptor original;
    private final Set<ValueParameterDescriptor> overriddenDescriptors = Sets.newLinkedHashSet();
    private boolean overriddenDescriptorsLocked = false;
    private final Set<? extends ValueParameterDescriptor> readOnlyOverriddenDescriptors = Collections.unmodifiableSet(this.overriddenDescriptors);

    public ValueParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, int index, @NotNull List<AnnotationDescriptor> annotations, @NotNull Name name, @NotNull JetType outType, boolean declaresDefaultValue, @Nullable JetType varargElementType) {
        super(containingDeclaration, annotations, name, outType);
        this.original = this;
        this.index = index;
        this.declaresDefaultValue = declaresDefaultValue;
        this.varargElementType = varargElementType;
    }

    public ValueParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull ValueParameterDescriptor original, @NotNull List<AnnotationDescriptor> annotations, @NotNull JetType outType, @Nullable JetType varargElementType) {
        super(containingDeclaration, annotations, original.getName(), outType);
        this.original = original;
        this.index = original.getIndex();
        this.declaresDefaultValue = original.declaresDefaultValue();
        this.varargElementType = varargElementType;
    }

    @Override
    public void setType(@NotNull JetType type) {
        this.setOutType(type);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasDefaultValue() {
        this.computeDefaultValuePresence();
        return this.hasDefaultValue;
    }

    @Override
    public boolean declaresDefaultValue() {
        return this.declaresDefaultValue && ((CallableMemberDescriptor)this.getContainingDeclaration()).getKind().isReal();
    }

    private void computeDefaultValuePresence() {
        if (this.hasDefaultValue != null) {
            return;
        }
        this.overriddenDescriptorsLocked = true;
        if (this.declaresDefaultValue) {
            this.hasDefaultValue = true;
        } else {
            for (ValueParameterDescriptor descriptor : this.overriddenDescriptors) {
                if (!descriptor.hasDefaultValue()) continue;
                this.hasDefaultValue = true;
                return;
            }
            this.hasDefaultValue = false;
        }
    }

    @Override
    @Nullable
    public JetType getVarargElementType() {
        return this.varargElementType;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor getOriginal() {
        return this.original == this ? this : this.original.getOriginal();
    }

    @Override
    @NotNull
    public ValueParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitValueParameterDescriptor(this, data);
    }

    @Override
    public boolean isVar() {
        return false;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor copy(@NotNull DeclarationDescriptor newOwner, @NotNull Name newName) {
        return new ValueParameterDescriptorImpl(newOwner, this.index, Lists.newArrayList(this.getAnnotations()), newName, this.getType(), this.declaresDefaultValue(), this.varargElementType);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.LOCAL;
    }

    @Override
    @NotNull
    public Set<? extends ValueParameterDescriptor> getOverriddenDescriptors() {
        return this.readOnlyOverriddenDescriptors;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull ValueParameterDescriptor overridden) {
        assert (!this.overriddenDescriptorsLocked) : "Adding more overridden descriptors is not allowed at this point: the presence of the default value has already been calculated";
        this.overriddenDescriptors.add(overridden);
    }
}

