/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.DescriptorSubstitutor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;

public class PropertyDescriptorImpl
extends VariableDescriptorImpl
implements PropertyDescriptor {
    private final Modality modality;
    private Visibility visibility;
    private final boolean isVar;
    private final Set<PropertyDescriptor> overriddenProperties = Sets.newLinkedHashSet();
    private final PropertyDescriptor original;
    private final CallableMemberDescriptor.Kind kind;
    private ReceiverParameterDescriptor expectedThisObject;
    private ReceiverParameterDescriptor receiverParameter;
    private List<TypeParameterDescriptor> typeParameters;
    private PropertyGetterDescriptorImpl getter;
    private PropertySetterDescriptor setter;

    private PropertyDescriptorImpl(@Nullable PropertyDescriptor original, @NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name, @NotNull CallableMemberDescriptor.Kind kind) {
        super(containingDeclaration, annotations, name);
        this.isVar = isVar;
        this.modality = modality;
        this.visibility = visibility;
        this.original = original == null ? this : original;
        this.kind = kind;
    }

    public PropertyDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name, @NotNull CallableMemberDescriptor.Kind kind) {
        this(null, containingDeclaration, annotations, modality, visibility, isVar, name, kind);
    }

    public PropertyDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull List<AnnotationDescriptor> annotations, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @Nullable JetType receiverType, @Nullable ReceiverParameterDescriptor expectedThisObject, @NotNull Name name, @NotNull JetType outType, @NotNull CallableMemberDescriptor.Kind kind) {
        this(containingDeclaration, annotations, modality, visibility, isVar, name, kind);
        this.setType(outType, Collections.emptyList(), expectedThisObject, receiverType);
    }

    public void setType(@NotNull JetType outType, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor expectedThisObject, @Nullable JetType receiverType) {
        ReceiverParameterDescriptor receiverParameter = DescriptorResolver.resolveReceiverParameterFor(this, receiverType);
        this.setType(outType, typeParameters, expectedThisObject, receiverParameter);
    }

    public void setType(@NotNull JetType outType, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @Nullable ReceiverParameterDescriptor expectedThisObject, @Nullable ReceiverParameterDescriptor receiverParameter) {
        this.setOutType(outType);
        this.typeParameters = Lists.newArrayList(typeParameters);
        this.receiverParameter = receiverParameter;
        this.expectedThisObject = expectedThisObject;
    }

    public void initialize(@Nullable PropertyGetterDescriptorImpl getter, @Nullable PropertySetterDescriptor setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getReceiverParameter() {
        return this.receiverParameter;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getExpectedThisObject() {
        return this.expectedThisObject;
    }

    @Override
    @NotNull
    public JetType getReturnType() {
        return this.getType();
    }

    @Override
    public boolean isVar() {
        return this.isVar;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    @Nullable
    public PropertyGetterDescriptorImpl getGetter() {
        return this.getter;
    }

    @Override
    @Nullable
    public PropertySetterDescriptor getSetter() {
        return this.setter;
    }

    @Override
    @NotNull
    public List<PropertyAccessorDescriptor> getAccessors() {
        ArrayList<PropertyAccessorDescriptor> r = Lists.newArrayListWithCapacity(2);
        if (this.getter != null) {
            r.add(this.getter);
        }
        if (this.setter != null) {
            r.add(this.setter);
        }
        return r;
    }

    @Override
    public PropertyDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.doSubstitute(originalSubstitutor, this.getContainingDeclaration(), this.modality, this.visibility, true, true, this.getKind());
    }

    private PropertyDescriptor doSubstitute(TypeSubstitutor originalSubstitutor, DeclarationDescriptor newOwner, Modality newModality, Visibility newVisibility, boolean preserveOriginal, boolean copyOverrides, CallableMemberDescriptor.Kind kind) {
        PropertySetterDescriptorImpl newSetter;
        PropertyGetterDescriptorImpl newGetter;
        JetType substitutedReceiverType;
        ReceiverParameterDescriptor substitutedExpectedThisObject;
        JetType originalOutType;
        PropertyDescriptorImpl substitutedDescriptor = new PropertyDescriptorImpl(preserveOriginal ? this.getOriginal() : null, newOwner, this.getAnnotations(), newModality, newVisibility, this.isVar(), this.getName(), kind);
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters = Lists.newArrayList();
        TypeSubstitutor substitutor = DescriptorSubstitutor.substituteTypeParameters(this.getTypeParameters(), originalSubstitutor, substitutedDescriptor, substitutedTypeParameters);
        JetType outType = substitutor.substitute(originalOutType = this.getType(), Variance.OUT_VARIANCE);
        if (outType == null) {
            return null;
        }
        ReceiverParameterDescriptor expectedThisObject = this.getExpectedThisObject();
        if (expectedThisObject != null) {
            substitutedExpectedThisObject = expectedThisObject.substitute(substitutor);
            if (substitutedExpectedThisObject == null) {
                return null;
            }
        } else {
            substitutedExpectedThisObject = null;
        }
        if (this.receiverParameter != null) {
            substitutedReceiverType = substitutor.substitute(this.receiverParameter.getType(), Variance.IN_VARIANCE);
            if (substitutedReceiverType == null) {
                return null;
            }
        } else {
            substitutedReceiverType = null;
        }
        substitutedDescriptor.setType(outType, substitutedTypeParameters, substitutedExpectedThisObject, substitutedReceiverType);
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = newGetter = this.getter == null ? null : new PropertyGetterDescriptorImpl(substitutedDescriptor, Lists.newArrayList(this.getter.getAnnotations()), DescriptorUtils.convertModality(this.getter.getModality(), false), PropertyDescriptorImpl.convertVisibility(this.getter.getVisibility(), newVisibility), this.getter.hasBody(), this.getter.isDefault(), kind, this.getter.getOriginal());
        if (newGetter != null) {
            JetType returnType = this.getter.getReturnType();
            newGetter.initialize(returnType != null ? substitutor.substitute(returnType, Variance.OUT_VARIANCE) : null);
        }
        PropertySetterDescriptorImpl propertySetterDescriptorImpl = newSetter = this.setter == null ? null : new PropertySetterDescriptorImpl(substitutedDescriptor, Lists.newArrayList(this.setter.getAnnotations()), DescriptorUtils.convertModality(this.setter.getModality(), false), PropertyDescriptorImpl.convertVisibility(this.setter.getVisibility(), newVisibility), this.setter.hasBody(), this.setter.isDefault(), kind, this.setter.getOriginal());
        if (newSetter != null) {
            List<ValueParameterDescriptor> substitutedValueParameters = FunctionDescriptorUtil.getSubstitutedValueParameters(newSetter, this.setter, substitutor);
            if (substitutedValueParameters == null) {
                return null;
            }
            if (substitutedValueParameters.size() != 1) {
                throw new IllegalStateException();
            }
            newSetter.initialize(substitutedValueParameters.get(0));
        }
        substitutedDescriptor.initialize(newGetter, newSetter);
        if (copyOverrides) {
            for (PropertyDescriptor propertyDescriptor : this.overriddenProperties) {
                OverridingUtil.bindOverride(substitutedDescriptor, propertyDescriptor.substitute(substitutor));
            }
        }
        return substitutedDescriptor;
    }

    @NotNull
    private static Visibility convertVisibility(Visibility orig, Visibility candidate) {
        if (candidate == Visibilities.INHERITED) {
            return candidate;
        }
        Integer result = Visibilities.compare(orig, candidate);
        return result != null && result < 0 ? candidate : orig;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitPropertyDescriptor(this, data);
    }

    @Override
    @NotNull
    public PropertyDescriptor getOriginal() {
        return this.original == this ? this : this.original.getOriginal();
    }

    @Override
    public CallableMemberDescriptor.Kind getKind() {
        return this.kind;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overridden) {
        this.overriddenProperties.add((PropertyDescriptorImpl)overridden);
    }

    @Override
    @NotNull
    public Set<? extends PropertyDescriptor> getOverriddenDescriptors() {
        return this.overriddenProperties;
    }

    @Override
    @NotNull
    public PropertyDescriptor copy(DeclarationDescriptor newOwner, Modality modality, Visibility visibility, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        return this.doSubstitute(TypeSubstitutor.EMPTY, newOwner, modality, visibility, false, copyOverrides, kind);
    }
}

