/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorForObject;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class WhenChecker {
    private WhenChecker() {
    }

    public static boolean mustHaveElse(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        JetType expectedType = trace.get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression);
        boolean isUnit = expectedType != null && KotlinBuiltIns.getInstance().isUnit(expectedType);
        boolean isStatement = Boolean.TRUE.equals(trace.get(BindingContext.STATEMENT, expression)) && expectedType == null;
        return !isUnit && !isStatement && !WhenChecker.isWhenExhaustive(expression, trace);
    }

    private static boolean isWhenExhaustive(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        JetExpression subjectExpression = expression.getSubjectExpression();
        if (subjectExpression == null) {
            return false;
        }
        JetType type = trace.get(BindingContext.EXPRESSION_TYPE, subjectExpression);
        if (type == null) {
            return false;
        }
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor.getKind() != ClassKind.ENUM_CLASS || classDescriptor.getModality().isOverridable()) {
            return false;
        }
        Collection<ClassDescriptor> objectDescriptors = DescriptorUtils.getEnumEntriesScope(classDescriptor).getObjectDescriptors();
        boolean isExhaust = true;
        boolean notEmpty = false;
        for (ClassDescriptor descriptor : objectDescriptors) {
            if (descriptor.getKind() != ClassKind.ENUM_ENTRY) continue;
            notEmpty = true;
            if (WhenChecker.containsEnumEntryCase(expression, descriptor, trace)) continue;
            isExhaust = false;
        }
        return isExhaust && notEmpty;
    }

    private static boolean containsEnumEntryCase(@NotNull JetWhenExpression whenExpression, @NotNull ClassDescriptor enumEntry, @NotNull BindingTrace trace) {
        assert (enumEntry.getKind() == ClassKind.ENUM_ENTRY);
        for (JetWhenEntry whenEntry : whenExpression.getEntries()) {
            for (JetWhenCondition condition : whenEntry.getConditions()) {
                if (!(condition instanceof JetWhenConditionWithExpression) || !WhenChecker.isCheckForEnumEntry((JetWhenConditionWithExpression)condition, enumEntry, trace)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCheckForEnumEntry(@NotNull JetWhenConditionWithExpression whenExpression, @NotNull ClassDescriptor enumEntry, @NotNull BindingTrace trace) {
        JetSimpleNameExpression reference = WhenChecker.getReference(whenExpression.getExpression());
        if (reference == null) {
            return false;
        }
        DeclarationDescriptor target = trace.get(BindingContext.REFERENCE_TARGET, reference);
        if (!(target instanceof VariableDescriptorForObject)) {
            return false;
        }
        ClassDescriptor classDescriptor = ((VariableDescriptorForObject)target).getObjectClass();
        return classDescriptor == enumEntry;
    }

    @Nullable
    private static JetSimpleNameExpression getReference(@Nullable JetExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JetSimpleNameExpression) {
            return (JetSimpleNameExpression)expression;
        }
        if (expression instanceof JetQualifiedExpression) {
            return WhenChecker.getReference(((JetQualifiedExpression)expression).getSelectorExpression());
        }
        return null;
    }
}

