/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorDeserializer;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedMemberScope;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class DeserializedPackageMemberScope
extends DeserializedMemberScope {
    private final DescriptorFinder descriptorFinder;
    private final FqName packageFqName;

    public DeserializedPackageMemberScope(@NotNull StorageManager storageManager, @NotNull NamespaceDescriptor packageDescriptor, @NotNull AnnotationDeserializer annotationDeserializer, @NotNull DescriptorFinder descriptorFinder, @NotNull ProtoBuf.Package proto, @NotNull NameResolver nameResolver) {
        super(storageManager, packageDescriptor, DescriptorDeserializer.create(storageManager, packageDescriptor, nameResolver, descriptorFinder, annotationDeserializer), proto.getMemberList());
        this.descriptorFinder = descriptorFinder;
        this.packageFqName = DescriptorUtils.getFQName(packageDescriptor).toSafe();
    }

    public DeserializedPackageMemberScope(@NotNull StorageManager storageManager, @NotNull NamespaceDescriptor packageDescriptor, @NotNull AnnotationDeserializer annotationDeserializer, @NotNull DescriptorFinder descriptorFinder, @NotNull PackageData packageData) {
        this(storageManager, packageDescriptor, annotationDeserializer, descriptorFinder, packageData.getPackageProto(), packageData.getNameResolver());
    }

    @Override
    @Nullable
    protected ClassifierDescriptor getClassDescriptor(@NotNull Name name) {
        return this.findClassDescriptor(name, false);
    }

    @Override
    @Nullable
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        return this.findClassDescriptor(name, true);
    }

    @Nullable
    private ClassDescriptor findClassDescriptor(Name name, boolean object) {
        ClassDescriptor classDescriptor = this.descriptorFinder.findClass(new ClassId(this.packageFqName, FqNameUnsafe.topLevel(name)));
        if (classDescriptor == null) {
            return null;
        }
        return classDescriptor.getKind().isObject() == object ? classDescriptor : null;
    }

    @Override
    protected void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
        this.findClassifiers(result, false);
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeAllObjectDescriptors() {
        return this.findClassifiers(new ArrayList(), true);
    }

    private <T extends Collection<? super ClassDescriptor>> T findClassifiers(T result, boolean object) {
        for (Name className : this.descriptorFinder.getClassNames(this.packageFqName)) {
            ClassDescriptor classDescriptor = this.findClassDescriptor(className, object);
            if (classDescriptor == null) continue;
            assert (classDescriptor.getKind().isObject() == object);
            result.add((ClassDescriptor)classDescriptor);
        }
        return result;
    }

    @Override
    protected void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.descriptorFinder.findPackage(this.packageFqName.child(name));
    }

    @Override
    @Nullable
    protected ReceiverParameterDescriptor getImplicitReceiver() {
        return null;
    }
}

