/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class NameResolver {
    private final ProtoBuf.SimpleNameTable simpleNames;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolver(@NotNull ProtoBuf.SimpleNameTable simpleNames, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        this.simpleNames = simpleNames;
        this.qualifiedNames = qualifiedNames;
    }

    @NotNull
    public ProtoBuf.SimpleNameTable getSimpleNameTable() {
        return this.simpleNames;
    }

    @NotNull
    public ProtoBuf.QualifiedNameTable getQualifiedNameTable() {
        return this.qualifiedNames;
    }

    @NotNull
    public Name getName(int index) {
        String name = this.simpleNames.getName(index);
        return Name.guess(name);
    }

    @NotNull
    public ClassId getClassId(int index) {
        FqName packageFqName;
        ProtoBuf.QualifiedNameTable.QualifiedName fqNameProto = this.qualifiedNames.getQualifiedName(index);
        assert (fqNameProto.getKind() == ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS) : "Not a class fqName: " + fqNameProto.getKind();
        StringBuilder relativeClassName = new StringBuilder();
        ProtoBuf.QualifiedNameTable.QualifiedName packageFqNameProto = this.renderFqName(relativeClassName, fqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        if (packageFqNameProto != null) {
            StringBuilder sb = new StringBuilder();
            ProtoBuf.QualifiedNameTable.QualifiedName mustBeNull = this.renderFqName(sb, packageFqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE);
            assert (mustBeNull == null) : "Prefix of an fqName must be all of kind PACKAGE";
            packageFqName = new FqName(sb.toString());
        } else {
            packageFqName = FqName.ROOT;
        }
        return new ClassId(packageFqName, new FqNameUnsafe(relativeClassName.toString()));
    }

    @Nullable
    private ProtoBuf.QualifiedNameTable.QualifiedName renderFqName(StringBuilder sb, ProtoBuf.QualifiedNameTable.QualifiedName fqNameProto, ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind) {
        ProtoBuf.QualifiedNameTable.QualifiedName result = null;
        if (fqNameProto.hasParentQualifiedName()) {
            ProtoBuf.QualifiedNameTable.QualifiedName parentProto = this.qualifiedNames.getQualifiedName(fqNameProto.getParentQualifiedName());
            if (kind == null || parentProto.getKind() == kind) {
                result = this.renderFqName(sb, parentProto, kind);
                sb.append(".");
            } else {
                result = parentProto;
            }
        }
        sb.append(this.simpleNames.getName(fqNameProto.getShortName()));
        return result;
    }

    @NotNull
    public FqName getFqName(int index) {
        ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName = this.qualifiedNames.getQualifiedName(index);
        Name shortName = this.getName(qualifiedName.getShortName());
        if (!qualifiedName.hasParentQualifiedName()) {
            return FqName.topLevel(shortName);
        }
        return this.getFqName(qualifiedName.getParentQualifiedName()).child(shortName);
    }
}

