/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorForObjectImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.Variance;

public class DescriptorDeserializer {
    private final DeclarationDescriptor containingDeclaration;
    private final NameResolver nameResolver;
    private final TypeDeserializer typeDeserializer;
    private final AnnotationDeserializer annotationDeserializer;
    private final StorageManager storageManager;

    @NotNull
    public static DescriptorDeserializer create(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull NameResolver nameResolver, @NotNull DescriptorFinder descriptorFinder, @NotNull AnnotationDeserializer annotationDeserializer) {
        return new DescriptorDeserializer(storageManager, new TypeDeserializer(storageManager, null, nameResolver, descriptorFinder, "Deserializer for " + containingDeclaration.getName(), TypeDeserializer.TypeParameterResolver.NONE), containingDeclaration, nameResolver, annotationDeserializer);
    }

    @NotNull
    public static DescriptorDeserializer create(@NotNull StorageManager storageManager, @NotNull TypeDeserializer typeDeserializer, @NotNull DeclarationDescriptor containingDeclaration, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer annotationDeserializer) {
        return new DescriptorDeserializer(storageManager, typeDeserializer, containingDeclaration, nameResolver, annotationDeserializer);
    }

    private DescriptorDeserializer(@NotNull StorageManager storageManager, @NotNull TypeDeserializer typeDeserializer, @NotNull DeclarationDescriptor containingDeclaration, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer annotationDeserializer) {
        this.storageManager = storageManager;
        this.typeDeserializer = typeDeserializer;
        this.containingDeclaration = containingDeclaration;
        this.nameResolver = nameResolver;
        this.annotationDeserializer = annotationDeserializer;
    }

    @NotNull
    public TypeDeserializer getTypeDeserializer() {
        return this.typeDeserializer;
    }

    @NotNull
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public DescriptorDeserializer createChildDeserializer(@NotNull DeclarationDescriptor descriptor, final @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, final @NotNull List<TypeParameterDescriptor> typeParameters) {
        TypeDeserializer childTypeDeserializer = new TypeDeserializer(this.storageManager, this.typeDeserializer, "Child deserializer for " + descriptor.getName(), new TypeDeserializer.TypeParameterResolver(){

            @Override
            @NotNull
            public List<DeserializedTypeParameterDescriptor> getTypeParameters(@NotNull TypeDeserializer typeDeserializer) {
                List<DeserializedTypeParameterDescriptor> descriptors = DescriptorDeserializer.this.typeParameters(typeParameterProtos, typeDeserializer);
                typeParameters.addAll(descriptors);
                return descriptors;
            }
        });
        return DescriptorDeserializer.create(this.storageManager, childTypeDeserializer, descriptor, this.nameResolver, this.annotationDeserializer);
    }

    @NotNull
    public CallableMemberDescriptor loadCallable(@NotNull ProtoBuf.Callable proto) {
        ProtoBuf.Callable.CallableKind callableKind = Flags.CALLABLE_KIND.get(proto.getFlags());
        switch (callableKind) {
            case FUN: {
                return this.loadFunction(proto);
            }
            case VAL: 
            case VAR: 
            case OBJECT_PROPERTY: {
                return this.loadProperty(proto);
            }
            case CONSTRUCTOR: {
                return this.loadConstructor(proto);
            }
        }
        throw new IllegalArgumentException("Unsupported callable kind: " + callableKind);
    }

    @NotNull
    private PropertyDescriptor loadProperty(@NotNull ProtoBuf.Callable proto) {
        boolean isNotDefault;
        PropertyDescriptorImpl property = this.createPropertyDescriptor(proto);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DescriptorDeserializer local = this.createChildDeserializer(property, proto.getTypeParameterList(), typeParameters);
        property.setType(local.typeDeserializer.type(proto.getReturnType()), typeParameters, this.getExpectedThisObject(), local.typeDeserializer.typeOrNull(proto.hasReceiverType() ? proto.getReceiverType() : null));
        PropertyGetterDescriptorImpl getter = null;
        PropertySetterDescriptorImpl setter = null;
        if (Flags.HAS_GETTER.get(proto.getFlags()).booleanValue()) {
            int getterFlags = proto.getGetterFlags();
            boolean bl = isNotDefault = proto.hasGetterFlags() && Flags.IS_NOT_DEFAULT.get(getterFlags) != false;
            getter = isNotDefault ? new PropertyGetterDescriptorImpl(property, this.getAnnotations(proto, getterFlags, AnnotationDeserializer.AnnotatedCallableKind.PROPERTY_GETTER), DescriptorDeserializer.modality(Flags.MODALITY.get(getterFlags)), DescriptorDeserializer.visibility(Flags.VISIBILITY.get(getterFlags)), isNotDefault, !isNotDefault, property.getKind()) : DescriptorResolver.createDefaultGetter(property);
            getter.initialize(property.getReturnType());
        }
        if (Flags.HAS_SETTER.get(proto.getFlags()).booleanValue()) {
            int setterFlags = proto.getSetterFlags();
            boolean bl = isNotDefault = proto.hasSetterFlags() && Flags.IS_NOT_DEFAULT.get(setterFlags) != false;
            if (isNotDefault) {
                setter = new PropertySetterDescriptorImpl(property, this.getAnnotations(proto, setterFlags, AnnotationDeserializer.AnnotatedCallableKind.PROPERTY_SETTER), DescriptorDeserializer.modality(Flags.MODALITY.get(setterFlags)), DescriptorDeserializer.visibility(Flags.VISIBILITY.get(setterFlags)), isNotDefault, !isNotDefault, property.getKind());
                setter.initialize(new ValueParameterDescriptorImpl(setter, 0, Collections.<AnnotationDescriptor>emptyList(), this.nameResolver.getName(proto.getSetterParameterName()), property.getReturnType(), false, null));
            } else {
                setter = DescriptorResolver.createDefaultSetter(property);
            }
        }
        property.initialize(getter, setter);
        return property;
    }

    @NotNull
    private PropertyDescriptorImpl createPropertyDescriptor(@NotNull ProtoBuf.Callable proto) {
        int flags = proto.getFlags();
        Name name = this.nameResolver.getName(proto.getName());
        List<AnnotationDescriptor> annotations = this.getAnnotations(proto, flags, AnnotationDeserializer.AnnotatedCallableKind.PROPERTY);
        Visibility visibility = DescriptorDeserializer.visibility(Flags.VISIBILITY.get(flags));
        ProtoBuf.Callable.CallableKind callableKind = Flags.CALLABLE_KIND.get(flags);
        if (callableKind == ProtoBuf.Callable.CallableKind.OBJECT_PROPERTY) {
            FqNameUnsafe fqName = DescriptorUtils.getFQName(this.containingDeclaration).child(name);
            ClassId objectId = ClassId.fromFqNameAndContainingDeclaration(fqName, (ClassOrNamespaceDescriptor)this.containingDeclaration);
            ClassDescriptor objectClass = this.typeDeserializer.getDescriptorFinder().findClass(objectId);
            if (objectClass == null) {
                objectClass = ErrorUtils.createErrorClass(objectId.asSingleFqName().asString());
            }
            return new PropertyDescriptorForObjectImpl(this.containingDeclaration, annotations, visibility, name, objectClass);
        }
        return new PropertyDescriptorImpl(this.containingDeclaration, annotations, DescriptorDeserializer.modality(Flags.MODALITY.get(flags)), visibility, callableKind == ProtoBuf.Callable.CallableKind.VAR, name, DescriptorDeserializer.memberKind(Flags.MEMBER_KIND.get(flags)));
    }

    @NotNull
    private CallableMemberDescriptor loadFunction(@NotNull ProtoBuf.Callable proto) {
        int flags = proto.getFlags();
        SimpleFunctionDescriptorImpl function = new SimpleFunctionDescriptorImpl(this.containingDeclaration, this.getAnnotations(proto, proto.getFlags(), AnnotationDeserializer.AnnotatedCallableKind.FUNCTION), this.nameResolver.getName(proto.getName()), DescriptorDeserializer.memberKind(Flags.MEMBER_KIND.get(flags)));
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DescriptorDeserializer local = this.createChildDeserializer(function, proto.getTypeParameterList(), typeParameters);
        function.initialize(local.typeDeserializer.typeOrNull(proto.hasReceiverType() ? proto.getReceiverType() : null), this.getExpectedThisObject(), typeParameters, local.valueParameters(proto.getValueParameterList()), local.typeDeserializer.type(proto.getReturnType()), DescriptorDeserializer.modality(Flags.MODALITY.get(flags)), DescriptorDeserializer.visibility(Flags.VISIBILITY.get(flags)), Flags.INLINE.get(flags));
        return function;
    }

    @Nullable
    private ReceiverParameterDescriptor getExpectedThisObject() {
        return this.containingDeclaration instanceof ClassDescriptor ? ((ClassDescriptor)this.containingDeclaration).getThisAsReceiverParameter() : null;
    }

    @NotNull
    private CallableMemberDescriptor loadConstructor(@NotNull ProtoBuf.Callable proto) {
        ClassDescriptor classDescriptor = (ClassDescriptor)this.containingDeclaration;
        ConstructorDescriptorImpl descriptor = new ConstructorDescriptorImpl(classDescriptor, this.getAnnotations(proto, proto.getFlags(), AnnotationDeserializer.AnnotatedCallableKind.FUNCTION), true);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(proto.getTypeParameterCount());
        DescriptorDeserializer local = this.createChildDeserializer(descriptor, Collections.<ProtoBuf.TypeParameter>emptyList(), typeParameters);
        descriptor.initialize(classDescriptor.getTypeConstructor().getParameters(), local.valueParameters(proto.getValueParameterList()), DescriptorDeserializer.visibility(Flags.VISIBILITY.get(proto.getFlags())), !classDescriptor.isInner());
        descriptor.setReturnType(local.typeDeserializer.type(proto.getReturnType()));
        return descriptor;
    }

    @NotNull
    private List<AnnotationDescriptor> getAnnotations(@NotNull ProtoBuf.Callable proto, int flags, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        assert (this.containingDeclaration instanceof ClassOrNamespaceDescriptor) : "Only members in classes or namespaces should be serialized: " + this.containingDeclaration;
        return Flags.HAS_ANNOTATIONS.get(flags) != false ? this.annotationDeserializer.loadCallableAnnotations((ClassOrNamespaceDescriptor)this.containingDeclaration, proto, this.nameResolver, kind) : Collections.emptyList();
    }

    private static CallableMemberDescriptor.Kind memberKind(ProtoBuf.Callable.MemberKind memberKind) {
        switch (memberKind) {
            case DECLARATION: {
                return CallableMemberDescriptor.Kind.DECLARATION;
            }
            case FAKE_OVERRIDE: {
                return CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
            }
            case DELEGATION: {
                return CallableMemberDescriptor.Kind.DELEGATION;
            }
            case SYNTHESIZED: {
                return CallableMemberDescriptor.Kind.SYNTHESIZED;
            }
        }
        throw new IllegalArgumentException("Unknown member kind: " + memberKind);
    }

    @NotNull
    public static Modality modality(@NotNull ProtoBuf.Modality modality) {
        switch (modality) {
            case FINAL: {
                return Modality.FINAL;
            }
            case OPEN: {
                return Modality.OPEN;
            }
            case ABSTRACT: {
                return Modality.ABSTRACT;
            }
        }
        throw new IllegalArgumentException("Unknown modality: " + modality);
    }

    @NotNull
    public static Visibility visibility(@NotNull ProtoBuf.Visibility visibility) {
        switch (visibility) {
            case INTERNAL: {
                return Visibilities.INTERNAL;
            }
            case PRIVATE: {
                return Visibilities.PRIVATE;
            }
            case PROTECTED: {
                return Visibilities.PROTECTED;
            }
            case PUBLIC: {
                return Visibilities.PUBLIC;
            }
            case EXTRA: {
                throw new UnsupportedOperationException("Extra visibilities are not supported yet");
            }
        }
        throw new IllegalArgumentException("Unknown visibility: " + visibility);
    }

    @NotNull
    public static ClassKind classKind(@NotNull ProtoBuf.Class.Kind kind) {
        switch (kind) {
            case CLASS: {
                return ClassKind.CLASS;
            }
            case TRAIT: {
                return ClassKind.TRAIT;
            }
            case ENUM_CLASS: {
                return ClassKind.ENUM_CLASS;
            }
            case ENUM_ENTRY: {
                return ClassKind.ENUM_ENTRY;
            }
            case ANNOTATION_CLASS: {
                return ClassKind.ANNOTATION_CLASS;
            }
            case OBJECT: {
                return ClassKind.OBJECT;
            }
            case CLASS_OBJECT: {
                return ClassKind.CLASS_OBJECT;
            }
        }
        throw new IllegalArgumentException("Unknown class kind: " + kind);
    }

    @NotNull
    public List<DeserializedTypeParameterDescriptor> typeParameters(@NotNull List<ProtoBuf.TypeParameter> protos, @NotNull TypeDeserializer typeDeserializer) {
        ArrayList<DeserializedTypeParameterDescriptor> result = new ArrayList<DeserializedTypeParameterDescriptor>(protos.size());
        for (int i = 0; i < protos.size(); ++i) {
            ProtoBuf.TypeParameter proto = protos.get(i);
            DeserializedTypeParameterDescriptor descriptor = new DeserializedTypeParameterDescriptor(this.storageManager, typeDeserializer, proto, this.containingDeclaration, this.nameResolver.getName(proto.getName()), DescriptorDeserializer.variance(proto.getVariance()), proto.getReified(), i);
            result.add(descriptor);
        }
        return result;
    }

    private static Variance variance(ProtoBuf.TypeParameter.Variance proto) {
        switch (proto) {
            case IN: {
                return Variance.IN_VARIANCE;
            }
            case OUT: {
                return Variance.OUT_VARIANCE;
            }
            case INV: {
                return Variance.INVARIANT;
            }
        }
        throw new IllegalStateException("Unknown projection: " + proto);
    }

    @NotNull
    private List<ValueParameterDescriptor> valueParameters(@NotNull List<ProtoBuf.Callable.ValueParameter> protos) {
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>(protos.size());
        for (int i = 0; i < protos.size(); ++i) {
            ProtoBuf.Callable.ValueParameter proto = protos.get(i);
            result.add(this.valueParameter(proto, i));
        }
        return result;
    }

    private ValueParameterDescriptor valueParameter(ProtoBuf.Callable.ValueParameter proto, int index) {
        return new ValueParameterDescriptorImpl(this.containingDeclaration, index, this.getAnnotations(proto), this.nameResolver.getName(proto.getName()), this.typeDeserializer.type(proto.getType()), Flags.DECLARES_DEFAULT_VALUE.get(proto.getFlags()), this.typeDeserializer.typeOrNull(proto.hasVarargElementType() ? proto.getVarargElementType() : null));
    }

    private List<AnnotationDescriptor> getAnnotations(ProtoBuf.Callable.ValueParameter proto) {
        return Flags.HAS_ANNOTATIONS.get(proto.getFlags()) != false ? this.annotationDeserializer.loadValueParameterAnnotations(proto) : Collections.emptyList();
    }
}

