/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class MemberMap {
    private final Map<FunctionDescriptor, Method> methodForFunction = new HashMap<FunctionDescriptor, Method>();
    private final Map<PropertyDescriptor, Pair<Type, String>> fieldForProperty = new HashMap<PropertyDescriptor, Pair<Type, String>>();
    private final Map<PropertyDescriptor, String> syntheticMethodNameForProperty = new HashMap<PropertyDescriptor, String>();
    private final Map<CallableMemberDescriptor, Name> srcClassNameForCallable = new HashMap<CallableMemberDescriptor, Name>();
    private final Set<PropertyDescriptor> staticFieldInOuterClass = new HashSet<PropertyDescriptor>();

    @NotNull
    public static MemberMap union(@NotNull Collection<MemberMap> maps) {
        MemberMap result = new MemberMap();
        for (MemberMap map : maps) {
            for (Map.Entry<FunctionDescriptor, Method> entry : map.methodForFunction.entrySet()) {
                result.recordMethodOfDescriptor(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<CallableMemberDescriptor, Object> entry : map.fieldForProperty.entrySet()) {
                result.recordFieldOfProperty((PropertyDescriptor)entry.getKey(), (Type)((Pair)entry.getValue()).first, (String)((Pair)entry.getValue()).second);
            }
            for (Map.Entry<CallableMemberDescriptor, Object> entry : map.syntheticMethodNameForProperty.entrySet()) {
                result.recordSyntheticMethodNameOfProperty((PropertyDescriptor)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry<CallableMemberDescriptor, Object> entry : map.srcClassNameForCallable.entrySet()) {
                result.recordSrcClassNameForCallable(entry.getKey(), (Name)entry.getValue());
            }
            for (PropertyDescriptor propertyDescriptor : map.staticFieldInOuterClass) {
                result.recordStaticFieldInOuterClass(propertyDescriptor);
            }
        }
        return result;
    }

    public void recordMethodOfDescriptor(@NotNull FunctionDescriptor descriptor, @NotNull Method method) {
        Method old = this.methodForFunction.put(descriptor, method);
        assert (old == null) : "Duplicate method for callable member: " + descriptor + "; " + old;
    }

    public void recordFieldOfProperty(@NotNull PropertyDescriptor descriptor, @NotNull Type type, @NotNull String fieldName) {
        Pair<Type, String> old = this.fieldForProperty.put(descriptor, Pair.create(type, fieldName));
        assert (old == null) : "Duplicate field for property: " + descriptor + "; " + old;
    }

    public void recordSyntheticMethodNameOfProperty(@NotNull PropertyDescriptor descriptor, @NotNull String name) {
        String old = this.syntheticMethodNameForProperty.put(descriptor, name);
        assert (old == null) : "Duplicate synthetic method for property: " + descriptor + "; " + old;
    }

    public void recordSrcClassNameForCallable(@NotNull CallableMemberDescriptor descriptor, @NotNull Name name) {
        Name old = this.srcClassNameForCallable.put(descriptor, name);
        assert (old == null) : "Duplicate src class name for callable: " + descriptor + "; " + old;
    }

    public void recordStaticFieldInOuterClass(@NotNull PropertyDescriptor property) {
        boolean added = this.staticFieldInOuterClass.add(property);
        assert (added) : "Duplicate static field in outer class: " + property;
    }

    @Nullable
    public Method getMethodOfDescriptor(@NotNull FunctionDescriptor descriptor) {
        return this.methodForFunction.get(descriptor);
    }

    @Nullable
    public Pair<Type, String> getFieldOfProperty(@NotNull PropertyDescriptor descriptor) {
        return this.fieldForProperty.get(descriptor);
    }

    @Nullable
    public String getSyntheticMethodNameOfProperty(@NotNull PropertyDescriptor descriptor) {
        return this.syntheticMethodNameForProperty.get(descriptor);
    }

    @Nullable
    public Name getSrcClassNameOfCallable(@NotNull CallableMemberDescriptor descriptor) {
        return this.srcClassNameForCallable.get(descriptor);
    }

    public boolean isStaticFieldInOuterClass(@NotNull PropertyDescriptor property) {
        return this.staticFieldInOuterClass.contains(property);
    }

    public String toString() {
        return "Functions: " + this.methodForFunction.size() + ", fields: " + this.fieldForProperty.size() + ", synthetic methods: " + this.syntheticMethodNameForProperty.size() + ", src class names: " + this.srcClassNameForCallable.size();
    }
}

