/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i = className.lastIndexOf(46);
            return i == -1 ? "" : className.substring(0, i);
        }
        return null;
    }

    public static String extractClassName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/ClassUtil", "extractClassName"));
        }
        int i = fqName.lastIndexOf(46);
        return i == -1 ? fqName : fqName.substring(i + 1);
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.length() == 0) {
            return className;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass, StringBuilder buf) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/ClassUtil", "formatClassName"));
        }
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = ClassUtil.getContainerClass(aClass);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    @Nullable
    private static PsiClass getContainerClass(PsiClass aClass) {
        PsiElement parent;
        for (parent = aClass.getContext(); parent != null && !(parent instanceof PsiClass); parent = parent.getContext()) {
        }
        return (PsiClass)parent;
    }

    public static int getNonQualifiedClassIdx(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/ClassUtil", "getNonQualifiedClassIdx"));
        }
        final int[] result = new int[]{-1};
        PsiClass containingClass = ClassUtil.getContainerClass(psiClass);
        if (containingClass != null) {
            containingClass.accept(new JavaRecursiveElementVisitor(){
                private int myCurrentIdx = 0;

                @Override
                public void visitElement(PsiElement element) {
                    if (result[0] == -1) {
                        super.visitElement(element);
                    }
                }

                @Override
                public void visitClass(PsiClass aClass) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (psiClass == aClass) {
                            result[0] = this.myCurrentIdx;
                        }
                    }
                }
            });
        }
        return result[0];
    }

    public static PsiClass findNonQualifiedClassByIndex(String indexName, @NotNull PsiClass containingClass) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        return ClassUtil.findNonQualifiedClassByIndex(indexName, containingClass, false);
    }

    public static PsiClass findNonQualifiedClassByIndex(String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        String prefix = ClassUtil.getDigitPrefix(indexName);
        final int idx = prefix.length() > 0 ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx = 0;

            @Override
            public void visitElement(PsiElement element) {
                if (result[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual(name, aClass.getName())) {
                            result[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (Comparing.strEqual(name, aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result[0] = aClass;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result[0];
    }

    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i;
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/ClassUtil", "getDigitPrefix"));
        }
        for (i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
        }
        return i == 0 ? "" : indexName.substring(0, i);
    }

    @Nullable
    public static PsiClass findPsiClass(PsiManager psiManager, String externalName) {
        return ClassUtil.findPsiClass(psiManager, externalName, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(PsiManager psiManager, String externalName, PsiClass psiClass, boolean jvmCompatible) {
        return ClassUtil.findPsiClass(psiManager, externalName, psiClass, jvmCompatible, GlobalSearchScope.allScope(psiManager.getProject()));
    }

    @Nullable
    public static PsiClass findPsiClass(PsiManager psiManager, String externalName, @Nullable PsiClass psiClass, boolean jvmCompatible, GlobalSearchScope scope) {
        int topIdx = externalName.indexOf(36);
        if (topIdx > -1) {
            if (psiClass == null) {
                psiClass = JavaPsiFacade.getInstance(psiManager.getProject()).findClass(externalName.substring(0, topIdx), scope);
            }
            if (psiClass == null) {
                return null;
            }
            externalName = externalName.substring(topIdx + 1);
            return ClassUtil.findSubclass(psiManager, externalName, psiClass, jvmCompatible);
        }
        return JavaPsiFacade.getInstance(psiManager.getProject()).findClass(externalName, scope);
    }

    @Nullable
    private static PsiClass findSubclass(PsiManager psiManager, String externalName, PsiClass psiClass, boolean jvmCompatible) {
        int nextIdx = externalName.indexOf(36);
        if (nextIdx > -1) {
            PsiClass anonymousClass = ClassUtil.findNonQualifiedClassByIndex(externalName.substring(0, nextIdx), psiClass, jvmCompatible);
            if (anonymousClass == null) {
                return null;
            }
            return ClassUtil.findPsiClass(psiManager, externalName.substring(nextIdx), anonymousClass, jvmCompatible);
        }
        return ClassUtil.findNonQualifiedClassByIndex(externalName, psiClass, jvmCompatible);
    }

    @Nullable
    public static String getJVMClassName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/ClassUtil", "getJVMClassName"));
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(PsiManager manager, String jvmClassName) {
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }
}

