/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Logger {
    public static Factory ourFactory = new DefaultFactory();

    public static Logger getInstance(@NonNls String category) {
        return ourFactory.getLoggerInstance(category);
    }

    public static Logger getInstance(Class cl) {
        return Logger.getInstance("#" + cl.getName());
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(@NonNls String var1);

    public abstract void debug(@Nullable Throwable var1);

    public abstract void debug(@NonNls String var1, @Nullable Throwable var2);

    public void info(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diagnostic/Logger", "info"));
        }
        this.info(t.getMessage(), t);
    }

    public abstract void info(@NonNls String var1);

    public abstract void info(@NonNls String var1, @Nullable Throwable var2);

    public void warn(@NonNls String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diagnostic/Logger", "warn"));
        }
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(@NonNls String var1, @Nullable Throwable var2);

    public void error(@NonNls String message) {
        this.error(message, new Throwable(), ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(Object message) {
        this.error(String.valueOf(message));
    }

    public void error(@NonNls String message, String ... details) {
        this.error(message, new Throwable(), details);
    }

    public void error(@NonNls String message, @Nullable Throwable e) {
        this.error(message, e, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diagnostic/Logger", "error"));
        }
        this.error(t.getMessage(), t, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public abstract void error(@NonNls String var1, @Nullable Throwable var2, String ... var3);

    public boolean assertTrue(boolean value, @Nullable @NonNls Object message) {
        if (!value) {
            String resultMessage = "Assertion failed";
            if (message != null) {
                resultMessage = resultMessage + ": " + message;
            }
            this.error(resultMessage, new Throwable());
        }
        return value;
    }

    public boolean assertTrue(boolean value) {
        return value || this.assertTrue(false, null);
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        public Logger getLoggerInstance(String category) {
            return new DefaultLogger(category);
        }
    }

    public static interface Factory {
        public Logger getLoggerInstance(String var1);
    }
}

