/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public abstract class AbstractCallExpressionTranslator
extends AbstractTranslator {
    @NotNull
    protected final JetCallExpression expression;
    @NotNull
    protected final ResolvedCall<?> resolvedCall;
    @Nullable
    protected final JsExpression receiver;
    @NotNull
    protected final CallType callType;

    protected AbstractCallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType type, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
        this.resolvedCall = BindingUtils.getResolvedCallForCallExpression(this.bindingContext(), expression);
        this.receiver = receiver;
        this.callType = type;
    }

    protected abstract boolean shouldWrapVarargInArray();

    protected void translateSingleArgument(@NotNull ResolvedValueArgument actualArgument, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull List<JsExpression> result) {
        List<ValueArgument> valueArguments = actualArgument.getArguments();
        if (actualArgument instanceof VarargValueArgument) {
            this.translateVarargArgument(valueArguments, result);
        } else if (actualArgument instanceof DefaultValueArgument) {
            JetExpression defaultArgument = BindingUtils.getDefaultArgument(this.bindingContext(), parameterDescriptor);
            result.add(Translation.translateAsExpression(defaultArgument, this.context()));
        } else {
            assert (actualArgument instanceof ExpressionValueArgument);
            assert (valueArguments.size() == 1);
            JetExpression argumentExpression = valueArguments.get(0).getArgumentExpression();
            assert (argumentExpression != null);
            result.add(Translation.translateAsExpression(argumentExpression, this.context()));
        }
    }

    private void translateVarargArgument(@NotNull List<ValueArgument> arguments, @NotNull List<JsExpression> result) {
        List<JsExpression> list;
        if (arguments.isEmpty()) {
            if (this.shouldWrapVarargInArray()) {
                result.add(new JsArrayLiteral(Collections.<JsExpression>emptyList()));
            }
            return;
        }
        if (this.shouldWrapVarargInArray()) {
            list = arguments.size() == 1 ? new SmartList() : new ArrayList(arguments.size());
            result.add(new JsArrayLiteral(list));
        } else {
            list = result;
        }
        for (ValueArgument argument : arguments) {
            JetExpression argumentExpression = argument.getArgumentExpression();
            assert (argumentExpression != null);
            list.add(Translation.translateAsExpression(argumentExpression, this.context()));
        }
    }
}

