/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;

public final class RangeForTranslator
extends ForTranslator {
    @NotNull
    private final TemporaryVariable rangeExpression;
    @NotNull
    private final TemporaryVariable start;
    @NotNull
    private final TemporaryVariable end;
    @NotNull
    private final TemporaryVariable increment;

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        return new RangeForTranslator(expression, context).translate();
    }

    public static boolean isApplicable(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        JetExpression loopRange = PsiUtils.getLoopRange(expression);
        JetType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        return DescriptorUtils.getClassDescriptorForType(rangeType).getName().asString().equals("IntRange");
    }

    private RangeForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        super(forExpression, context);
        this.rangeExpression = context.declareTemporary(Translation.translateAsExpression(PsiUtils.getLoopRange(this.expression), context));
        this.start = this.context().declareTemporary(this.callFunction("get_start"));
        this.end = this.context().declareTemporary(this.callFunction("get_end"));
        this.increment = this.context().declareTemporary(this.callFunction("get_increment"));
    }

    @NotNull
    private JsBlock translate() {
        ArrayList<JsStatement> blockStatements = Lists.newArrayList();
        blockStatements.add(TemporariesUtils.temporariesInitialization(this.rangeExpression, this.start, this.end, this.increment).makeStmt());
        blockStatements.add(this.generateForExpression());
        return new JsBlock(blockStatements);
    }

    @NotNull
    private JsFor generateForExpression() {
        JsFor result = new JsFor(this.initExpression(), this.getCondition(), this.getIncrExpression());
        result.setBody(this.translateOriginalBodyExpression());
        return result;
    }

    @NotNull
    private JsVars initExpression() {
        return JsAstUtils.newVar(this.parameterName, this.start.reference());
    }

    @NotNull
    private JsExpression getCondition() {
        return JsAstUtils.lessThanEq(this.parameterName.makeRef(), this.end.reference());
    }

    @NotNull
    private JsExpression getIncrExpression() {
        return JsAstUtils.addAssign(this.parameterName.makeRef(), this.increment.reference());
    }

    @NotNull
    private JsExpression callFunction(@NotNull String funName) {
        return new JsInvocation(new JsNameRef(funName, (JsExpression)this.rangeExpression.reference()));
    }
}

