/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.utils.JetFileUtils;

public class LibrarySourcesConfig
extends Config {
    @NotNull
    public static final Key<String> EXTERNAL_MODULE_NAME = new Key("externalModule");
    @NotNull
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    @NotNull
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.k2js.config.LibrarySourcesConfig");
    @NotNull
    private final List<String> files;

    public LibrarySourcesConfig(@NotNull Project project, @NotNull String moduleId, @NotNull List<String> files, @NotNull EcmaVersion ecmaVersion, boolean sourcemap) {
        super(project, moduleId, ecmaVersion, sourcemap);
        this.files = files;
    }

    @Override
    @NotNull
    public List<JetFile> generateLibFiles() {
        if (this.files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JetFile> jetFiles = new ArrayList<JetFile>();
        String moduleName = UNKNOWN_EXTERNAL_MODULE_NAME;
        for (String path : this.files) {
            File file = new File(path);
            if (!file.exists()) continue;
            try {
                String name = file.getName();
                if (path.charAt(0) == '@') {
                    moduleName = path.substring(1);
                    continue;
                }
                if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    jetFiles.addAll(this.readZip(file));
                    continue;
                }
                JetFile psiFile = JetFileUtils.createPsiFile(path, FileUtil.loadFile(file), this.getProject());
                psiFile.putUserData(EXTERNAL_MODULE_NAME, moduleName);
                jetFiles.add(psiFile);
            }
            catch (IOException e) {
                LOG.error("While processing " + file, e);
            }
        }
        return jetFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JetFile> readZip(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            List<JetFile> list = this.traverseArchive(zipFile);
            return list;
        }
        finally {
            zipFile.close();
        }
    }

    @NotNull
    private List<JetFile> traverseArchive(@NotNull ZipFile file) throws IOException {
        ArrayList<JetFile> result = Lists.newArrayList();
        Enumeration<? extends ZipEntry> zipEntries = file.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".kt")) continue;
            InputStream stream = file.getInputStream(entry);
            String text = FileUtil.loadTextAndClose(stream);
            JetFile jetFile = JetFileUtils.createPsiFile(entry.getName(), text, this.getProject());
            jetFile.putUserData(EXTERNAL_MODULE_NAME, UNKNOWN_EXTERNAL_MODULE_NAME);
            result.add(jetFile);
        }
        return result;
    }
}

