/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.js.compiler;

import com.google.dart.compiler.backend.js.JsToStringGenerationVisitor;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import com.google.dart.compiler.backend.js.ast.JsVisitable;
import com.google.dart.compiler.util.TextOutput;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.js.compiler.SourceMapBuilder;

public class JsSourceGenerationVisitor
extends JsToStringGenerationVisitor
implements TextOutput.OutListener {
    @Nullable
    private final SourceMapBuilder sourceMapBuilder;
    private Object pendingSourceInfo;

    public JsSourceGenerationVisitor(TextOutput out, @Nullable SourceMapBuilder sourceMapBuilder) {
        super(out);
        this.sourceMapBuilder = sourceMapBuilder;
        out.setOutListener(this);
    }

    @Override
    public boolean visit(JsProgram program, JsContext ctx) {
        return true;
    }

    @Override
    public boolean visit(JsProgramFragment x, JsContext ctx) {
        return true;
    }

    @Override
    public boolean visit(JsBlock x, JsContext ctx) {
        this.printJsBlock(x, false, true);
        return false;
    }

    @Override
    public void newLined() {
        if (this.sourceMapBuilder != null) {
            this.sourceMapBuilder.newLine();
        }
    }

    @Override
    public void indentedAfterNewLine() {
        if (this.pendingSourceInfo != null) {
            assert (this.sourceMapBuilder != null);
            this.sourceMapBuilder.processSourceInfo(this.pendingSourceInfo);
            this.pendingSourceInfo = null;
        }
    }

    @Override
    protected void doTraverse(JsVisitable node, JsContext context) {
        Object sourceInfo;
        if (this.sourceMapBuilder != null && (sourceInfo = node.getSourceInfo()) != null) {
            assert (this.pendingSourceInfo == null);
            if (this.p.isJustNewlined()) {
                this.pendingSourceInfo = sourceInfo;
            } else {
                this.sourceMapBuilder.processSourceInfo(sourceInfo);
            }
        }
        super.doTraverse(node, context);
    }

    @Override
    public void endVisit(JsProgram x, JsContext context) {
        super.endVisit(x, context);
        if (this.sourceMapBuilder != null) {
            this.sourceMapBuilder.addLink();
        }
    }
}

