/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class BuiltInsSerializationUtil {
    private BuiltInsSerializationUtil() {
    }

    @NotNull
    public static String relativeClassNameToFilePath(@NotNull FqNameUnsafe className) {
        ArrayList<String> correctedSegments = new ArrayList<String>();
        for (Name segment : className.pathSegments()) {
            if (segment.asString().startsWith("<class-object-for")) {
                correctedSegments.add("object");
                continue;
            }
            assert (!segment.isSpecial());
            correctedSegments.add(segment.asString());
        }
        return FqName.fromSegments(correctedSegments).asString();
    }

    @NotNull
    public static String getClassMetadataPath(@NotNull ClassId classId) {
        return BuiltInsSerializationUtil.packageFqNameToPath(classId.getPackageFqName().toUnsafe()) + "/" + BuiltInsSerializationUtil.relativeClassNameToFilePath(classId.getRelativeClassName()) + "." + "kotlin_class";
    }

    @NotNull
    public static String getPackageFilePath(@NotNull NamespaceDescriptor packageDescriptor) {
        FqNameUnsafe fqName = DescriptorUtils.getFQName(packageDescriptor);
        return BuiltInsSerializationUtil.packageFqNameToPath(fqName) + "/" + ".kotlin_package";
    }

    @NotNull
    public static String getNameTableFilePath(@NotNull NamespaceDescriptor packageDescriptor) {
        FqNameUnsafe fqName = DescriptorUtils.getFQName(packageDescriptor);
        return BuiltInsSerializationUtil.packageFqNameToPath(fqName) + "/" + ".kotlin_name_table";
    }

    @NotNull
    public static String getClassNamesFilePath(@NotNull NamespaceDescriptor packageDescriptor) {
        FqNameUnsafe fqName = DescriptorUtils.getFQName(packageDescriptor);
        return BuiltInsSerializationUtil.packageFqNameToPath(fqName) + "/" + ".kotlin_class_names";
    }

    private static String packageFqNameToPath(FqNameUnsafe fqName) {
        return fqName.asString().replace('.', '/');
    }
}

