/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.AbstractDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgument;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TraceEntryFilter;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CaptureKind;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ExpressionTypingUtils {
    public static final JetType CANT_INFER_LAMBDA_PARAM_TYPE = ErrorUtils.createErrorType("Cannot be inferred");

    private ExpressionTypingUtils() {
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull JetExpression expression, @Nullable JetType type) {
        if (type == null) {
            return null;
        }
        return new ExpressionReceiver(expression, type);
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context) {
        return ExpressionTypingUtils.getExpressionReceiver(expression, facade.getTypeInfo(expression, context).getType());
    }

    @NotNull
    protected static ExpressionReceiver safeGetExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context) {
        JetType type = facade.safeGetTypeInfo(expression, context).getType();
        assert (type != null) : "safeGetTypeInfo should return @NotNull type";
        return new ExpressionReceiver(expression, type);
    }

    @NotNull
    public static WritableScopeImpl newWritableScopeImpl(ExpressionTypingContext context, @NotNull String scopeDebugName) {
        WritableScopeImpl scope = new WritableScopeImpl(context.scope, context.scope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(context.trace), scopeDebugName);
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        return scope;
    }

    public static boolean isBoolean(@NotNull JetType type) {
        return JetTypeChecker.INSTANCE.isSubtypeOf(type, KotlinBuiltIns.getInstance().getBooleanType());
    }

    public static boolean ensureBooleanResult(JetExpression operationSign, Name name, JetType resultType, ExpressionTypingContext context) {
        return ExpressionTypingUtils.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name + "'", context);
    }

    public static boolean ensureBooleanResultWithCustomSubject(JetExpression operationSign, JetType resultType, String subjectName, ExpressionTypingContext context) {
        if (resultType != null && !ExpressionTypingUtils.isBoolean(resultType)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, KotlinBuiltIns.getInstance().getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    @NotNull
    public static JetType getDefaultType(IElementType constantType) {
        if (constantType == JetNodeTypes.INTEGER_CONSTANT) {
            return KotlinBuiltIns.getInstance().getIntType();
        }
        if (constantType == JetNodeTypes.FLOAT_CONSTANT) {
            return KotlinBuiltIns.getInstance().getDoubleType();
        }
        if (constantType == JetNodeTypes.BOOLEAN_CONSTANT) {
            return KotlinBuiltIns.getInstance().getBooleanType();
        }
        if (constantType == JetNodeTypes.CHARACTER_CONSTANT) {
            return KotlinBuiltIns.getInstance().getCharType();
        }
        if (constantType == JetNodeTypes.NULL) {
            return KotlinBuiltIns.getInstance().getNullableNothingType();
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    public static boolean isTypeFlexible(@Nullable JetExpression expression) {
        if (expression == null) {
            return false;
        }
        return TokenSet.create(JetNodeTypes.INTEGER_CONSTANT, JetNodeTypes.FLOAT_CONSTANT).contains(expression.getNode().getElementType());
    }

    private static boolean isCapturedInInline(@NotNull BindingContext context, @NotNull DeclarationDescriptor scopeContainer, @NotNull DeclarationDescriptor variableParent) {
        PsiElement scopeDeclaration = BindingContextUtils.descriptorToDeclaration(context, scopeContainer);
        if (!(scopeDeclaration instanceof JetFunctionLiteral)) {
            return false;
        }
        PsiElement parent = scopeDeclaration.getParent();
        assert (parent instanceof JetFunctionLiteralExpression) : "parent of JetFunctionLiteral is " + parent;
        JetCallExpression callExpression = ExpressionTypingUtils.getCallExpression((JetFunctionLiteralExpression)parent);
        if (callExpression == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> call = context.get(BindingContext.RESOLVED_CALL, callExpression.getCalleeExpression());
        if (call == null) {
            return false;
        }
        CallableDescriptor callable = call.getResultingDescriptor();
        if (callable instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)callable).isInline()) {
            DeclarationDescriptor scopeContainerParent = scopeContainer.getContainingDeclaration();
            assert (scopeContainerParent != null) : "parent is null for " + scopeContainer;
            return scopeContainerParent == variableParent || ExpressionTypingUtils.isCapturedInInline(context, scopeContainerParent, variableParent);
        }
        return false;
    }

    @Nullable
    private static JetCallExpression getCallExpression(@NotNull JetFunctionLiteralExpression functionLiteralExpression) {
        PsiElement parent = functionLiteralExpression.getParent();
        if (parent instanceof JetValueArgument) {
            PsiElement valueArgumentList = parent.getParent();
            assert (valueArgumentList instanceof JetValueArgumentList) : "parent of value argument is " + valueArgumentList;
            if (valueArgumentList.getParent() instanceof JetCallExpression) {
                return (JetCallExpression)valueArgumentList.getParent();
            }
        } else if (parent instanceof JetCallExpression) {
            return (JetCallExpression)parent;
        }
        return null;
    }

    public static void checkCapturingInClosure(JetSimpleNameExpression expression, BindingTrace trace, JetScope scope) {
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression, true);
        if (variable != null) {
            DeclarationDescriptor variableParent = variable.getContainingDeclaration();
            DeclarationDescriptor scopeContainer = scope.getContainingDeclaration();
            if (scopeContainer != variableParent && variableParent instanceof CallableDescriptor && trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable) != CaptureKind.NOT_INLINE) {
                boolean inline = ExpressionTypingUtils.isCapturedInInline(trace.getBindingContext(), scopeContainer, variableParent);
                trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable, inline ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE);
            }
        }
    }

    public static boolean isVariableIterable(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull Project project, @NotNull VariableDescriptor variableDescriptor, @NotNull JetScope scope) {
        ExpressionTypingContext context;
        JetExpression expression = JetPsiFactory.createExpression(project, "fake");
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression, variableDescriptor.getType());
        return ControlStructureTypingVisitor.checkIterableConvention(expressionReceiver, context = ExpressionTypingContext.newContext(expressionTypingServices, new BindingTraceContext(), scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, ExpressionPosition.FREE)) != null;
    }

    public static List<CallableDescriptor> canFindSuitableCall(@NotNull FqName callableFQN, @NotNull Project project, @NotNull JetExpression receiverExpression, @NotNull JetType receiverType, @NotNull JetScope scope, @NotNull ModuleDescriptor module) {
        JetImportDirective importDirective = JetPsiFactory.createImportDirective(project, callableFQN.asString());
        Collection<? extends DeclarationDescriptor> declarationDescriptors = new QualifiedExpressionResolver().analyseImportReference(importDirective, scope, new BindingTraceContext(), module);
        ArrayList<CallableDescriptor> callableExtensionDescriptors = new ArrayList<CallableDescriptor>();
        ExpressionReceiver receiverValue = new ExpressionReceiver(receiverExpression, receiverType);
        for (DeclarationDescriptor declarationDescriptor : declarationDescriptors) {
            CallableDescriptor callableDescriptor;
            if (!(declarationDescriptor instanceof CallableDescriptor) || !ExpressionTypingUtils.checkIsExtensionCallable(receiverValue, callableDescriptor = (CallableDescriptor)declarationDescriptor)) continue;
            callableExtensionDescriptors.add(callableDescriptor);
        }
        return callableExtensionDescriptors;
    }

    public static boolean checkIsExtensionCallable(@NotNull ReceiverValue receiverArgument, @NotNull CallableDescriptor callableDescriptor) {
        JetType notNullableType;
        JetType type = receiverArgument.getType();
        if (type instanceof NamespaceType) {
            return false;
        }
        if (ExpressionTypingUtils.checkReceiverResolution(receiverArgument, type, callableDescriptor)) {
            return true;
        }
        return type.isNullable() && ExpressionTypingUtils.checkReceiverResolution(receiverArgument, notNullableType = TypeUtils.makeNotNullable(type), callableDescriptor);
    }

    private static boolean checkReceiverResolution(@NotNull ReceiverValue receiverArgument, @NotNull JetType receiverType, @NotNull CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        if (!receiverArgument.exists() && receiverParameter == null) {
            return true;
        }
        if (!receiverArgument.exists() || receiverParameter == null) {
            return false;
        }
        Set<Name> typeNamesInReceiver = ExpressionTypingUtils.collectUsedTypeNames(receiverParameter.getType());
        ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
        for (TypeParameterDescriptor typeParameterDescriptor : callableDescriptor.getTypeParameters()) {
            if (!typeNamesInReceiver.contains(typeParameterDescriptor.getName())) continue;
            constraintSystem.registerTypeVariable(typeParameterDescriptor, Variance.INVARIANT);
        }
        constraintSystem.addSubtypeConstraint(receiverType, receiverParameter.getType(), ConstraintPosition.RECEIVER_POSITION);
        return constraintSystem.isSuccessful() && ConstraintsUtil.checkBoundsAreSatisfied(constraintSystem, true);
    }

    private static Set<Name> collectUsedTypeNames(@NotNull JetType jetType) {
        HashSet<Name> typeNames = new HashSet<Name>();
        ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
        if (descriptor != null) {
            typeNames.add(descriptor.getName());
        }
        for (TypeProjection argument : jetType.getArguments()) {
            typeNames.addAll(ExpressionTypingUtils.collectUsedTypeNames(argument.getType()));
        }
        return typeNames;
    }

    @NotNull
    public static OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ExpressionTypingContext context, @NotNull ReceiverValue receiver, @NotNull Name name, JetType ... argumentTypes) {
        TemporaryBindingTrace traceWithFakeArgumentInfo = TemporaryBindingTrace.create(context.trace, "trace to store fake argument for", name);
        ArrayList<JetExpression> fakeArguments = Lists.newArrayList();
        for (JetType type : argumentTypes) {
            fakeArguments.add(ExpressionTypingUtils.createFakeExpressionOfType(context.expressionTypingServices.getProject(), traceWithFakeArgumentInfo, "fakeArgument" + fakeArguments.size(), type));
        }
        return ExpressionTypingUtils.makeAndResolveFakeCall(receiver, (ExpressionTypingContext)context.replaceBindingTrace(traceWithFakeArgumentInfo), fakeArguments, name).getSecond();
    }

    public static JetExpression createFakeExpressionOfType(@NotNull Project project, @NotNull BindingTrace trace, @NotNull String argumentName, @NotNull JetType argumentType) {
        JetExpression fakeExpression = JetPsiFactory.createExpression(project, argumentName);
        trace.record(BindingContext.EXPRESSION_TYPE, fakeExpression, argumentType);
        trace.record(BindingContext.PROCESSED, fakeExpression);
        return fakeExpression;
    }

    @NotNull
    public static OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(@NotNull ExpressionTypingContext context, @NotNull ReceiverValue receiver, @NotNull Name name) {
        return ExpressionTypingUtils.makeAndResolveFakeCall(receiver, context, Collections.<JetExpression>emptyList(), name).getSecond();
    }

    @NotNull
    public static Pair<Call, OverloadResolutionResults<FunctionDescriptor>> makeAndResolveFakeCall(@NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context, @NotNull List<JetExpression> valueArguments, @NotNull Name name) {
        final JetSimpleNameExpression fake = JetPsiFactory.createSimpleName(context.expressionTypingServices.getProject(), "fake");
        TemporaryBindingTrace fakeTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve fake call for", name);
        Call call = CallMaker.makeCallWithExpressions(fake, receiver, null, fake, valueArguments);
        OverloadResolutionResults<FunctionDescriptor> results = ((ExpressionTypingContext)context.replaceBindingTrace(fakeTrace)).resolveCallWithGivenName(call, fake, name);
        if (results.isSuccess()) {
            fakeTrace.commit(new TraceEntryFilter(){

                @Override
                public boolean accept(@NotNull WritableSlice<?, ?> slice, Object key) {
                    return key != fake;
                }
            }, false);
        }
        return Pair.create(call, results);
    }

    public static void defineLocalVariablesFromMultiDeclaration(@NotNull WritableScope writableScope, @NotNull JetMultiDeclaration multiDeclaration, @NotNull ReceiverValue receiver, @NotNull JetExpression reportErrorsOn, @NotNull ExpressionTypingContext context) {
        int componentIndex = 1;
        for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
            Name componentName = Name.identifier("component" + componentIndex);
            ++componentIndex;
            JetType expectedType = ExpressionTypingUtils.getExpectedTypeForComponent(context, entry);
            OverloadResolutionResults<FunctionDescriptor> results = ExpressionTypingUtils.resolveFakeCall((ExpressionTypingContext)context.replaceExpectedType(expectedType), receiver, componentName);
            JetType componentType = null;
            if (results.isSuccess()) {
                context.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
                componentType = results.getResultingDescriptor().getReturnType();
                if (componentType != null && !TypeUtils.noExpectedType(expectedType) && !JetTypeChecker.INSTANCE.isSubtypeOf(componentType, expectedType)) {
                    context.trace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on(reportErrorsOn, componentName, componentType, expectedType));
                }
            } else if (results.isAmbiguity()) {
                context.trace.report(Errors.COMPONENT_FUNCTION_AMBIGUITY.on(reportErrorsOn, componentName, results.getResultingCalls()));
            } else {
                context.trace.report(Errors.COMPONENT_FUNCTION_MISSING.on(reportErrorsOn, componentName, receiver.getType()));
            }
            if (componentType == null) {
                componentType = ErrorUtils.createErrorType(componentName + "() return type");
            }
            VariableDescriptorImpl variableDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptorWithType(writableScope, entry, componentType, context.trace);
            VariableDescriptor olderVariable = writableScope.getLocalVariable(variableDescriptor.getName());
            ExpressionTypingUtils.checkVariableShadowing(context, variableDescriptor, olderVariable);
            writableScope.addVariableDescriptor(variableDescriptor);
        }
    }

    public static void checkVariableShadowing(@NotNull ExpressionTypingContext context, @NotNull VariableDescriptor variableDescriptor, VariableDescriptor oldDescriptor) {
        PsiElement declaration;
        if (oldDescriptor != null && DescriptorUtils.isLocal(variableDescriptor.getContainingDeclaration(), oldDescriptor) && (declaration = BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), variableDescriptor)) != null) {
            context.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().asString()));
        }
    }

    @NotNull
    private static JetType getExpectedTypeForComponent(ExpressionTypingContext context, JetMultiDeclarationEntry entry) {
        JetTypeReference entryTypeRef = entry.getTypeRef();
        if (entryTypeRef != null) {
            return context.expressionTypingServices.getTypeResolver().resolveType(context.scope, entryTypeRef, context.trace, true);
        }
        return TypeUtils.NO_EXPECTED_TYPE;
    }

    public static ObservableBindingTrace makeTraceInterceptingTypeMismatch(@NotNull BindingTrace trace, final @NotNull JetElement expressionToWatch, final @NotNull boolean[] mismatchFound) {
        return new ObservableBindingTrace(trace){

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                AbstractDiagnosticFactory factory = diagnostic.getFactory();
                if ((factory == Errors.TYPE_MISMATCH || factory == Errors.ERROR_COMPILE_TIME_VALUE) && diagnostic.getPsiElement() == expressionToWatch) {
                    mismatchFound[0] = true;
                }
                if (Errors.TYPE_INFERENCE_ERRORS.contains(factory) && PsiTreeUtil.isAncestor(expressionToWatch, diagnostic.getPsiElement(), false)) {
                    mismatchFound[0] = true;
                }
                super.report(diagnostic);
            }
        };
    }

    @NotNull
    public static JetTypeInfo getTypeInfoOrNullType(@Nullable JetExpression expression, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        return expression != null ? facade.getTypeInfo(expression, context) : JetTypeInfo.create(null, context.dataFlowInfo);
    }

    public static boolean isBinaryExpressionDependentOnExpectedType(@NotNull JetBinaryExpression expression) {
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        return operationType == JetTokens.IDENTIFIER || OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType) || operationType == JetTokens.ELVIS;
    }
}

