/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedInstanceExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetRootNamespaceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallExpressionResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.calls.autocasts.Nullability;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantResolver;
import org.jetbrains.jet.lang.resolve.constants.DoubleValueTypeConstructor;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.jet.lang.resolve.constants.NumberValueTypeConstructor;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.CastDiagnosticsUtil;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.utils.ThrowingList;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private final PlatformToKotlinClassMap platformToKotlinClassMap;

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        super(facade);
        this.platformToKotlinClassMap = platformToKotlinClassMap;
    }

    @Override
    public JetTypeInfo visitSimpleNameExpression(JetSimpleNameExpression expression, ExpressionTypingContext context) {
        CallExpressionResolver callExpressionResolver = context.expressionTypingServices.getCallExpressionResolver();
        JetTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression, ReceiverValue.NO_RECEIVER, null, context);
        JetType type = DataFlowUtils.checkType(typeInfo.getType(), (JetExpression)expression, (ResolutionContext)context);
        ExpressionTypingUtils.checkCapturingInClosure(expression, context.trace, context.scope);
        return JetTypeInfo.create(type, typeInfo.getDataFlowInfo());
    }

    @Override
    public JetTypeInfo visitParenthesizedExpression(JetParenthesizedExpression expression, ExpressionTypingContext context) {
        return this.visitParenthesizedExpression(expression, context, false);
    }

    public JetTypeInfo visitParenthesizedExpression(JetParenthesizedExpression expression, ExpressionTypingContext context, boolean isStatement) {
        JetExpression innerExpression = expression.getExpression();
        if (innerExpression == null) {
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(innerExpression, (ExpressionTypingContext)context.replaceScope(context.scope), isStatement);
        return DataFlowUtils.checkType(typeInfo, (JetExpression)expression, (ResolutionContext)context);
    }

    private static JetTypeInfo createNumberValueTypeInfo(@NotNull NumberValueTypeConstructor numberValueTypeConstructor, @NotNull Number value, @NotNull DataFlowInfo dataFlowInfo) {
        return JetTypeInfo.create(new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), numberValueTypeConstructor, false, Collections.<TypeProjection>emptyList(), ErrorUtils.createErrorScope("Scope for number value type (" + value + ")", true)), dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitConstantExpression(JetConstantExpression expression, ExpressionTypingContext context) {
        CompileTimeConstant<?> value;
        IElementType elementType = expression.getNode().getElementType();
        String text = expression.getNode().getText();
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        CompileTimeConstantResolver compileTimeConstantResolver = context.getCompileTimeConstantResolver();
        if (TypeUtils.noExpectedType(context.expectedType) && context.contextDependency == ContextDependency.DEPENDENT) {
            Double doubleValue;
            if (elementType == JetNodeTypes.INTEGER_CONSTANT) {
                Long longValue = CompileTimeConstantResolver.parseLongValue(text);
                if (longValue != null) {
                    return BasicExpressionTypingVisitor.createNumberValueTypeInfo(IntegerValueTypeConstructor.create(longValue), longValue, context.dataFlowInfo);
                }
            } else if (elementType == JetNodeTypes.FLOAT_CONSTANT && (doubleValue = CompileTimeConstantResolver.parseDoubleValue(text)) != null) {
                return BasicExpressionTypingVisitor.createNumberValueTypeInfo(DoubleValueTypeConstructor.create(doubleValue), doubleValue, context.dataFlowInfo);
            }
        }
        if ((value = compileTimeConstantResolver.getCompileTimeConstant(expression, context.expectedType)) instanceof ErrorValue) {
            if (context.contextDependency == ContextDependency.INDEPENDENT) {
                context.trace.report(Errors.ERROR_COMPILE_TIME_VALUE.on(expression, ((ErrorValue)value).getMessage()));
            }
            return JetTypeInfo.create(ExpressionTypingUtils.getDefaultType(elementType), context.dataFlowInfo);
        }
        context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, value);
        return DataFlowUtils.checkType(value.getType(builtIns), expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitBinaryWithTypeRHSExpression(JetBinaryExpressionWithTypeRHS expression, ExpressionTypingContext context) {
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression left = expression.getLeft();
        JetTypeReference right = expression.getRight();
        if (right == null) {
            JetTypeInfo leftTypeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
            return JetTypeInfo.create(null, leftTypeInfo.getDataFlowInfo());
        }
        JetType targetType = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, right, context.trace, true);
        IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
        if (ExpressionTypingUtils.isTypeFlexible(left) || operationType == JetTokens.COLON) {
            JetTypeInfo typeInfo = this.facade.getTypeInfo(left, (ExpressionTypingContext)contextWithNoExpectedType.replaceExpectedType(targetType));
            this.checkBinaryWithTypeRHS(expression, context, targetType, typeInfo.getType());
            return DataFlowUtils.checkType(targetType, expression, context, typeInfo.getDataFlowInfo());
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (typeInfo.getType() != null) {
            this.checkBinaryWithTypeRHS(expression, contextWithNoExpectedType, targetType, typeInfo.getType());
            dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == JetTokens.AS_KEYWORD) {
                DataFlowValue value = DataFlowValueFactory.INSTANCE.createDataFlowValue(left, typeInfo.getType(), context.trace.getBindingContext());
                dataFlowInfo = dataFlowInfo.establishSubtyping(value, targetType);
            }
        }
        JetType result = operationType == JetTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        return DataFlowUtils.checkType(result, expression, context, dataFlowInfo);
    }

    private void checkBinaryWithTypeRHS(@NotNull JetBinaryExpressionWithTypeRHS expression, @NotNull ExpressionTypingContext context, @NotNull JetType targetType, @Nullable JetType actualType) {
        if (actualType == null) {
            return;
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.COLON) {
            return;
        }
        if (operationType != JetTokens.AS_KEYWORD && operationType != JetTokens.AS_SAFE) {
            context.trace.report(Errors.UNSUPPORTED.on(operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibility(expression, actualType, targetType, context);
    }

    private void checkForCastImpossibility(JetBinaryExpressionWithTypeRHS expression, JetType actualType, JetType targetType, ExpressionTypingContext context) {
        if (actualType == null || TypeUtils.noExpectedType(targetType)) {
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.platformToKotlinClassMap)) {
            context.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression.getOperationReference()));
        } else {
            JetTypeChecker typeChecker = JetTypeChecker.INSTANCE;
            if (typeChecker.isSubtypeOf(actualType, targetType)) {
                if (!typeChecker.isSubtypeOf(targetType, actualType)) {
                    context.trace.report(Errors.USELESS_CAST_STATIC_ASSERT_IS_FINE.on(expression.getOperationReference()));
                } else {
                    context.trace.report(Errors.USELESS_CAST.on(expression.getOperationReference()));
                }
            } else if (CastDiagnosticsUtil.isCastErased(actualType, targetType, typeChecker)) {
                context.trace.report(Errors.UNCHECKED_CAST.on(expression, actualType, targetType));
            }
        }
    }

    @Override
    public JetTypeInfo visitThisExpression(JetThisExpression expression, ExpressionTypingContext context) {
        JetType result = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = BasicExpressionTypingVisitor.resolveToReceiver(expression, context, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context.trace.report(Errors.NO_THIS.on(expression));
                break;
            }
            case SUCCESS: {
                result = resolutionResult.getReceiverParameterDescriptor().getType();
                context.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result);
            }
        }
        return DataFlowUtils.checkType(result, expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitSuperExpression(JetSuperExpression expression, ExpressionTypingContext context) {
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = BasicExpressionTypingVisitor.resolveToReceiver(expression, context, true);
        if (context.expressionPosition == ExpressionPosition.FREE) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression, expression.getText()));
            return BasicExpressionTypingVisitor.errorInSuper(expression, context);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return BasicExpressionTypingVisitor.errorInSuper(expression, context);
            }
            case NO_THIS: {
                context.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression));
                return BasicExpressionTypingVisitor.errorInSuper(expression, context);
            }
            case SUCCESS: {
                JetType result = BasicExpressionTypingVisitor.checkPossiblyQualifiedSuper(expression, context, resolutionResult.getReceiverParameterDescriptor());
                if (result != null) {
                    context.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result);
                }
                return DataFlowUtils.checkType(result, expression, context, context.dataFlowInfo);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private static JetTypeInfo errorInSuper(JetSuperExpression expression, ExpressionTypingContext context) {
        JetTypeReference superTypeQualifier = expression.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            context.expressionTypingServices.getTypeResolver().resolveType(context.scope, superTypeQualifier, context.trace, true);
        }
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    private static JetType checkPossiblyQualifiedSuper(JetSuperExpression expression, ExpressionTypingContext context, ReceiverParameterDescriptor thisReceiver) {
        JetTypeReference superTypeQualifier;
        JetType thisType;
        JetType result;
        block17: {
            TypeSubstitutor substitutor;
            Collection<JetType> supertypes;
            block14: {
                boolean validType;
                JetTypeArgumentList redundantTypeArguments;
                JetType supertype;
                ClassifierDescriptor classifierCandidate;
                block16: {
                    block15: {
                        result = null;
                        thisType = thisReceiver.getType();
                        supertypes = thisType.getConstructor().getSupertypes();
                        substitutor = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block14;
                        JetTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof JetUserType) {
                            JetUserType userType = (JetUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = context.expressionTypingServices.getTypeResolver().resolveClass(context.scope, userType, context.trace);
                            } else {
                                supertype = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, superTypeQualifier, context.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, superTypeQualifier, context.trace, true);
                        }
                        if (supertype == null) break block15;
                        if (!supertypes.contains(supertype)) break block16;
                        result = supertype;
                        break block16;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassDescriptor superclass = (ClassDescriptor)classifierCandidate;
                        for (JetType declaredSupertype : supertypes) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result = substitutor.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !ErrorUtils.isErrorType(supertype);
                if (result == null && (validClassifier || validType)) {
                    context.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on(redundantTypeArguments));
                }
                break block17;
            }
            if (supertypes.size() > 1) {
                context.trace.report(Errors.AMBIGUOUS_SUPER.on(expression));
            } else {
                JetType type = supertypes.isEmpty() ? KotlinBuiltIns.getInstance().getAnyType() : supertypes.iterator().next();
                result = substitutor.substitute(type, Variance.INVARIANT);
            }
        }
        if (result != null) {
            if (DescriptorUtils.isKindOf(thisType, ClassKind.TRAIT) && DescriptorUtils.isKindOf(result, ClassKind.CLASS)) {
                context.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_TRAIT.on(expression));
            }
            context.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result);
            context.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result.getConstructor().getDeclarationDescriptor());
            if (superTypeQualifier != null) {
                context.trace.record(BindingContext.TYPE_RESOLUTION_SCOPE, superTypeQualifier, context.scope);
            }
        }
        return result;
    }

    @NotNull
    private static LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(JetLabelQualifiedInstanceExpression expression, ExpressionTypingContext context, boolean onlyClassReceivers) {
        String labelName = expression.getLabelName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = context.labelResolver.resolveThisLabel(expression.getInstanceReference(), expression.getTargetLabel(), context, new LabelName(labelName));
            if (onlyClassReceivers && resolutionResult.success() && !BasicExpressionTypingVisitor.isDeclaredInClass(resolutionResult.getReceiverParameterDescriptor())) {
                return LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
            }
            return resolutionResult;
        }
        ReceiverParameterDescriptor result = ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
        List<ReceiverParameterDescriptor> receivers = context.scope.getImplicitReceiversHierarchy();
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result = receivers.get(0);
        }
        if (result != ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER) {
            context.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result.getContainingDeclaration());
        }
        return LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(result);
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public JetTypeInfo visitBlockExpression(JetBlockExpression expression, ExpressionTypingContext context) {
        return BasicExpressionTypingVisitor.visitBlockExpression(expression, context, false);
    }

    public static JetTypeInfo visitBlockExpression(JetBlockExpression expression, ExpressionTypingContext context, boolean isStatement) {
        return context.expressionTypingServices.getBlockReturnedType(expression, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context);
    }

    @Override
    public JetTypeInfo visitCallableReferenceExpression(JetCallableReferenceExpression expression, ExpressionTypingContext context) {
        JetTypeReference typeReference = expression.getTypeReference();
        JetType receiverType = typeReference == null ? null : context.expressionTypingServices.getTypeResolver().resolveType(context.scope, typeReference, context.trace, false);
        JetSimpleNameExpression callableReference = expression.getCallableReference();
        if (callableReference.getReferencedName().isEmpty()) {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(callableReference, callableReference));
            JetType errorType = ErrorUtils.createErrorType("Empty callable reference");
            return DataFlowUtils.checkType(errorType, expression, context, context.dataFlowInfo);
        }
        JetType result = BasicExpressionTypingVisitor.getCallableReferenceType(expression, receiverType, context);
        return DataFlowUtils.checkType(result, expression, context, context.dataFlowInfo);
    }

    @Nullable
    private static JetType getCallableReferenceType(@NotNull JetCallableReferenceExpression expression, @Nullable JetType lhsType, @NotNull ExpressionTypingContext context) {
        JetSimpleNameExpression reference = expression.getCallableReference();
        boolean[] result = new boolean[1];
        FunctionDescriptor descriptor = BasicExpressionTypingVisitor.resolveCallableReferenceTarget(lhsType, context, expression, result);
        if (!result[0]) {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        if (descriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        if (receiverParameter != null && expectedThisObject != null) {
            context.trace.report(Errors.EXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED.on(reference, descriptor));
            return null;
        }
        JetType receiverType = null;
        if (receiverParameter != null) {
            receiverType = receiverParameter.getType();
        } else if (expectedThisObject != null) {
            receiverType = expectedThisObject.getType();
        }
        JetType type = KotlinBuiltIns.getInstance().getKFunctionType(Collections.<AnnotationDescriptor>emptyList(), receiverType, DescriptorUtils.getValueParametersTypes(descriptor.getValueParameters()), descriptor.getReturnType(), receiverParameter != null);
        ExpressionAsFunctionDescriptor functionDescriptor = new ExpressionAsFunctionDescriptor(context.scope.getContainingDeclaration(), Name.special("<callable-reference>"));
        FunctionDescriptorUtil.initializeFromFunctionType(functionDescriptor, type, null, Modality.FINAL, Visibilities.PUBLIC);
        context.trace.record(BindingContext.CALLABLE_REFERENCE, expression, functionDescriptor);
        return type;
    }

    @Nullable
    private static FunctionDescriptor resolveCallableReferenceTarget(@Nullable JetType lhsType, @NotNull ExpressionTypingContext context, @NotNull JetCallableReferenceExpression expression, @NotNull boolean[] result) {
        JetSimpleNameExpression reference = expression.getCallableReference();
        if (lhsType == null) {
            return BasicExpressionTypingVisitor.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, context, result);
        }
        ClassifierDescriptor classifier = lhsType.getConstructor().getDeclarationDescriptor();
        if (!(classifier instanceof ClassDescriptor)) {
            context.trace.report(Errors.CALLABLE_REFERENCE_LHS_NOT_A_CLASS.on(expression));
            return null;
        }
        TransientReceiver receiver = new TransientReceiver(lhsType);
        TemporaryTraceAndCache temporaryWithReceiver = TemporaryTraceAndCache.create(context, "trace to resolve callable reference with receiver", reference);
        FunctionDescriptor descriptor = BasicExpressionTypingVisitor.resolveCallableNotCheckingArguments(reference, receiver, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryWithReceiver), result);
        if (result[0]) {
            temporaryWithReceiver.commit();
            return descriptor;
        }
        JetScope staticScope = DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier);
        TemporaryTraceAndCache temporaryForStatic = TemporaryTraceAndCache.create(context, "trace to resolve callable reference in static scope", reference);
        FunctionDescriptor possibleStaticNestedClassConstructor = BasicExpressionTypingVisitor.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceTraceAndCache(temporaryForStatic)).replaceScope(staticScope), result);
        if (result[0]) {
            temporaryForStatic.commit();
            return possibleStaticNestedClassConstructor;
        }
        return null;
    }

    @Nullable
    private static FunctionDescriptor resolveCallableNotCheckingArguments(@NotNull JetSimpleNameExpression reference, @NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context, @NotNull boolean[] result) {
        Call call = CallMaker.makeCall(reference, receiver, null, reference, ThrowingList.instance());
        TemporaryBindingTrace trace = TemporaryBindingTrace.create(context.trace, "trace to resolve as function", reference);
        ExpressionTypingContext contextForResolve = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(trace)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        ResolvedCallWithTrace<FunctionDescriptor> function = contextForResolve.expressionTypingServices.getCallExpressionResolver().getResolvedCallForFunction(call, reference, contextForResolve, CheckValueArgumentsMode.DISABLED, result);
        if (!result[0]) {
            return null;
        }
        if (function instanceof VariableAsFunctionResolvedCall) {
            context.trace.report(Errors.UNSUPPORTED.on(reference, "References to variables aren't supported yet"));
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
            return null;
        }
        trace.commit();
        return function != null ? (FunctionDescriptor)function.getResultingDescriptor() : null;
    }

    @Override
    public JetTypeInfo visitQualifiedExpression(JetQualifiedExpression expression, ExpressionTypingContext context) {
        CallExpressionResolver callExpressionResolver = context.expressionTypingServices.getCallExpressionResolver();
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression, context);
    }

    @Override
    public JetTypeInfo visitCallExpression(JetCallExpression expression, ExpressionTypingContext context) {
        CallExpressionResolver callExpressionResolver = context.expressionTypingServices.getCallExpressionResolver();
        return callExpressionResolver.getCallExpressionTypeInfo(expression, ReceiverValue.NO_RECEIVER, null, context);
    }

    @Override
    public JetTypeInfo visitUnaryExpression(JetUnaryExpression expression, ExpressionTypingContext context) {
        return this.visitUnaryExpression(expression, context, false);
    }

    public JetTypeInfo visitUnaryExpression(JetUnaryExpression expression, ExpressionTypingContext context, boolean isStatement) {
        JetType result;
        ExpressionReceiver receiver;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (JetTokens.LABELS.contains(operationType)) {
            return this.visitLabeledExpression(expression, context, isStatement);
        }
        if (operationType == JetTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression, context);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(baseExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        JetType type = typeInfo.getType();
        if (type == null) {
            return typeInfo;
        }
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        Name name = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get(operationType);
        if (name == null) {
            context.trace.report(Errors.UNSUPPORTED.on(operationSign, "visitUnaryExpression"));
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        if ((operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) && baseExpression instanceof JetArrayAccessExpression) {
            JetExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "$e", type);
            this.resolveArrayAccessSetMethod((JetArrayAccessExpression)baseExpression, stubExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceBindingTrace(TemporaryBindingTrace.create(context.trace, "trace to resolve array access set method for unary expression", expression)), context.trace);
        }
        if (!(resolutionResults = context.resolveCallWithGivenName(CallMaker.makeCall((ReceiverValue)(receiver = new ExpressionReceiver(baseExpression, type)), expression), expression.getOperationReference(), name)).isSuccess()) {
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        JetType returnType = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) {
            assert (returnType != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (JetTypeChecker.INSTANCE.isSubtypeOf(returnType, KotlinBuiltIns.getInstance().getUnitType())) {
                result = ErrorUtils.createErrorType(KotlinBuiltIns.getInstance().getUnit().getName().asString());
                context.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                JetType receiverType = receiver.getType();
                if (!JetTypeChecker.INSTANCE.isSubtypeOf(returnType, receiverType)) {
                    context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name.asString(), receiverType, returnType));
                } else {
                    context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
                    BasicExpressionTypingVisitor.checkLValue(context.trace, baseExpression);
                }
                result = receiverType;
            }
        } else {
            result = returnType;
        }
        return DataFlowUtils.checkType(result, expression, context, dataFlowInfo);
    }

    private JetTypeInfo visitExclExclExpression(@NotNull JetUnaryExpression expression, @NotNull ExpressionTypingContext context) {
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == JetTokens.EXCLEXCL);
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, Collections.singletonList(baseExpression));
        ControlStructureTypingUtils.resolveSpecialConstructionAsCall(call, "ExclExcl", Collections.singletonList("baseExpr"), Collections.singletonList(true), context, null);
        JetTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context.trace.getBindingContext());
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression;
        JetType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (BasicExpressionTypingVisitor.isKnownToBeNotNull(baseExpression, context) && !ErrorUtils.isErrorType(baseType)) {
            context.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(operationSign, baseType));
        } else {
            DataFlowValue value = DataFlowValueFactory.INSTANCE.createDataFlowValue(baseExpression, baseType, context.trace.getBindingContext());
            dataFlowInfo = dataFlowInfo.disequate(value, DataFlowValue.NULL);
        }
        return JetTypeInfo.create(TypeUtils.makeNotNullable(baseType), dataFlowInfo);
    }

    private JetTypeInfo visitLabeledExpression(@NotNull JetUnaryExpression expression, @NotNull ExpressionTypingContext context, boolean isStatement) {
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        assert (JetTokens.LABELS.contains(operationSign.getReferencedNameElementType()));
        String referencedName = operationSign.getReferencedName();
        context.labelResolver.enterLabeledElement(new LabelName(referencedName.substring(1)), baseExpression);
        JetTypeInfo typeInfo = this.facade.getTypeInfo(baseExpression, context, isStatement);
        context.labelResolver.exitLabeledElement(baseExpression);
        return DataFlowUtils.checkType(typeInfo, (JetExpression)expression, (ResolutionContext)context);
    }

    private static boolean isKnownToBeNotNull(JetExpression expression, ExpressionTypingContext context) {
        JetType type = context.trace.get(BindingContext.EXPRESSION_TYPE, expression);
        assert (type != null) : "This method is only supposed to be called when the type is not null";
        return BasicExpressionTypingVisitor.isKnownToBeNotNull(expression, type, context);
    }

    private static boolean isKnownToBeNotNull(JetExpression expression, JetType jetType, ExpressionTypingContext context) {
        DataFlowValue dataFlowValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(expression, jetType, context.trace.getBindingContext());
        return !context.dataFlowInfo.getNullability(dataFlowValue).canBeNull();
    }

    public static void checkLValue(@NotNull BindingTrace trace, @NotNull JetExpression expression) {
        BasicExpressionTypingVisitor.checkLValue(trace, expression, false);
    }

    private static void checkLValue(@NotNull BindingTrace trace, @NotNull JetExpression expressionWithParenthesis, boolean canBeThis) {
        JetExpression expression = JetPsiUtil.deparenthesize(expressionWithParenthesis);
        if (expression instanceof JetArrayAccessExpression) {
            JetExpression arrayExpression = ((JetArrayAccessExpression)expression).getArrayExpression();
            if (arrayExpression != null) {
                BasicExpressionTypingVisitor.checkLValue(trace, arrayExpression, true);
            }
            return;
        }
        if (canBeThis && expression instanceof JetThisExpression) {
            return;
        }
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression, true);
        if (variable == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(expression != null ? expression : expressionWithParenthesis));
        }
    }

    @Override
    public JetTypeInfo visitBinaryExpression(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        JetTypeInfo result;
        ExpressionTypingContext context = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.IDENTIFIER) {
            Name referencedName = operationSign.getReferencedNameAsName();
            result = this.getTypeInfoForBinaryCall(referencedName, context, expression);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType)) {
            Name referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(operationType);
            result = this.getTypeInfoForBinaryCall(referencedName, context, expression);
        } else {
            if (operationType == JetTokens.ELVIS) {
                return this.visitElvisExpression(expression, context);
            }
            if (operationType == JetTokens.EQ) {
                result = this.visitAssignment(expression, context);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                result = this.visitAssignmentOperation(expression, context);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains(operationType)) {
                result = this.visitComparison(expression, context, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains(operationType)) {
                result = this.visitEquality(expression, context, operationSign, left, right);
            } else if (operationType == JetTokens.EQEQEQ || operationType == JetTokens.EXCLEQEQEQ) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
                result = JetTypeInfo.create(KotlinBuiltIns.getInstance().getBooleanType(), context.dataFlowInfo);
            } else if (OperatorConventions.IN_OPERATIONS.contains(operationType)) {
                result = this.checkInExpression(expression, operationSign, left, right, context);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationType)) {
                result = this.visitBooleanOperationExpression(operationType, left, right, context);
            } else {
                context.trace.report(Errors.UNSUPPORTED.on(operationSign, "Unknown operation"));
                result = JetTypeInfo.create(null, context.dataFlowInfo);
            }
        }
        return DataFlowUtils.checkType(result, (JetExpression)expression, (ResolutionContext)contextWithExpectedType);
    }

    private JetTypeInfo visitEquality(JetBinaryExpression expression, ExpressionTypingContext context, JetSimpleNameExpression operationSign, JetExpression left, JetExpression right) {
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (right != null && left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context);
            JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            dataFlowInfo = leftTypeInfo.getDataFlowInfo();
            ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
            OverloadResolutionResults<FunctionDescriptor> resolutionResults = ExpressionTypingUtils.resolveFakeCall(contextWithDataFlow, receiver, OperatorConventions.EQUALS, KotlinBuiltIns.getInstance().getNullableAnyType());
            dataFlowInfo = this.facade.getTypeInfo(right, contextWithDataFlow).getDataFlowInfo();
            if (resolutionResults.isSuccess()) {
                FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
                context.trace.record(BindingContext.REFERENCE_TARGET, operationSign, equals);
                context.trace.record(BindingContext.RESOLVED_CALL, operationSign, resolutionResults.getResultingCall());
                if (ExpressionTypingUtils.ensureBooleanResult(operationSign, OperatorConventions.EQUALS, equals.getReturnType(), context)) {
                    this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
                }
            } else if (resolutionResults.isAmbiguity()) {
                context.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(operationSign, resolutionResults.getResultingCalls()));
            } else {
                context.trace.report(Errors.EQUALS_MISSING.on(operationSign));
            }
        }
        JetTypeInfo result = JetTypeInfo.create(KotlinBuiltIns.getInstance().getBooleanType(), dataFlowInfo);
        return result;
    }

    @NotNull
    private JetTypeInfo visitComparison(@NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext context, @NotNull JetSimpleNameExpression operationSign) {
        JetTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorConventions.COMPARE_TO, context, expression);
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        JetType compareToReturnType = typeInfo.getType();
        JetType type = null;
        if (compareToReturnType != null && !ErrorUtils.isErrorType(compareToReturnType)) {
            KotlinBuiltIns builtIns;
            TypeConstructor intTypeConstructor;
            TypeConstructor constructor = compareToReturnType.getConstructor();
            if (constructor.equals(intTypeConstructor = (builtIns = KotlinBuiltIns.getInstance()).getInt().getTypeConstructor())) {
                type = builtIns.getBooleanType();
            } else {
                context.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        return JetTypeInfo.create(type, dataFlowInfo);
    }

    @NotNull
    private JetTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable JetExpression left, @Nullable JetExpression right, @NotNull ExpressionTypingContext context) {
        JetType rightType;
        JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
        JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
        JetType leftType = leftTypeInfo.getType();
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        WritableScopeImpl leftScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Left scope of && or ||");
        boolean isAnd = operationType == JetTokens.ANDAND;
        DataFlowInfo flowInfoLeft = DataFlowUtils.extractDataFlowInfoFromCondition(left, isAnd, context).and(dataFlowInfo);
        WritableScopeImpl rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context, "Right scope of && or ||");
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope);
        JetType jetType = rightType = right != null ? this.facade.getTypeInfo(right, contextForRightExpr).getType() : null;
        if (left != null && leftType != null && !ExpressionTypingUtils.isBoolean(leftType)) {
            context.trace.report(Errors.TYPE_MISMATCH.on(left, booleanType, leftType));
        }
        if (rightType != null && !ExpressionTypingUtils.isBoolean(rightType)) {
            context.trace.report(Errors.TYPE_MISMATCH.on(right, booleanType, rightType));
        }
        return JetTypeInfo.create(booleanType, dataFlowInfo);
    }

    @NotNull
    private JetTypeInfo visitElvisExpression(@NotNull JetBinaryExpression expression, @NotNull ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        Call call = ControlStructureTypingUtils.createCallForSpecialConstruction(expression, Lists.newArrayList(left, right));
        ResolvedCall<FunctionDescriptor> resolvedCall = ControlStructureTypingUtils.resolveSpecialConstructionAsCall(call, "Elvis", Lists.newArrayList("left", "right"), Lists.newArrayList(true, false), contextWithExpectedType, null);
        JetTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context.trace.getBindingContext());
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression;
        JetType leftType = leftTypeInfo.getType();
        if (leftType != null && BasicExpressionTypingVisitor.isKnownToBeNotNull(left, leftType, context)) {
            context.trace.report(Errors.USELESS_ELVIS.on(left, leftType));
        }
        JetTypeInfo rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context.trace.getBindingContext());
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression;
        JetType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall.getDataFlowInfoForArguments().getResultInfo();
        JetType type = resolvedCall.getResultingDescriptor().getReturnType();
        if (type == null || rightType == null) {
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        return JetTypeInfo.create(TypeUtils.makeNullableAsSpecified(type, rightType.isNullable()), dataFlowInfo);
    }

    @NotNull
    public JetTypeInfo checkInExpression(@NotNull JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @Nullable JetExpression left, @Nullable JetExpression right, @NotNull ExpressionTypingContext context) {
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        DataFlowInfo dataFlowInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType).getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = contextWithDataFlow.resolveCallWithGivenName(CallMaker.makeCallWithExpressions(callElement, receiver, null, operationSign, Collections.singletonList(left)), operationSign, OperatorConventions.CONTAINS);
        JetType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context.contextDependency);
        ExpressionTypingUtils.ensureBooleanResult(operationSign, OperatorConventions.CONTAINS, containsType, context);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
        }
        return JetTypeInfo.create(resolutionResult.isSuccess() ? KotlinBuiltIns.getInstance().getBooleanType() : null, dataFlowInfo);
    }

    private void ensureNonemptyIntersectionOfOperandTypes(JetBinaryExpression expression, ExpressionTypingContext context) {
        JetType rightType;
        JetExpression left = expression.getLeft();
        if (left == null) {
            return;
        }
        JetExpression right = expression.getRight();
        JetType leftType = this.facade.getTypeInfo(left, context).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context).getType()) != null) {
            if (TypeUtils.isIntersectionEmpty(leftType, rightType)) {
                context.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression, expression.getOperationReference(), leftType, rightType));
            }
            this.checkSenselessComparisonWithNull(expression, left, right, context);
        }
    }

    private void checkSenselessComparisonWithNull(@NotNull JetBinaryExpression expression, @NotNull JetExpression left, @NotNull JetExpression right, @NotNull ExpressionTypingContext context) {
        boolean expressionIsAlways;
        boolean equality;
        JetExpression expr;
        if (JetPsiUtil.isNullConstant(left)) {
            expr = right;
        } else if (JetPsiUtil.isNullConstant(right)) {
            expr = left;
        } else {
            return;
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetType type = this.facade.getTypeInfo(expr, context).getType();
        if (type == null || ErrorUtils.isErrorType(type)) {
            return;
        }
        DataFlowValue value = DataFlowValueFactory.INSTANCE.createDataFlowValue(expr, type, context.trace.getBindingContext());
        Nullability nullability = context.dataFlowInfo.getNullability(value);
        boolean bl = equality = operationSign.getReferencedNameElementType() == JetTokens.EQEQ || operationSign.getReferencedNameElementType() == JetTokens.EQEQEQ;
        if (nullability == Nullability.NULL) {
            expressionIsAlways = equality;
        } else if (nullability == Nullability.NOT_NULL) {
            expressionIsAlways = !equality;
        } else {
            return;
        }
        context.trace.report(Errors.SENSELESS_COMPARISON.on(expression, expression, expressionIsAlways));
    }

    @NotNull
    private JetTypeInfo visitAssignmentOperation(JetBinaryExpression expression, ExpressionTypingContext context) {
        return this.assignmentIsNotAnExpressionError(expression, context);
    }

    @NotNull
    private JetTypeInfo visitAssignment(JetBinaryExpression expression, ExpressionTypingContext context) {
        return this.assignmentIsNotAnExpressionError(expression, context);
    }

    @NotNull
    private JetTypeInfo assignmentIsNotAnExpressionError(JetBinaryExpression expression, ExpressionTypingContext context) {
        this.facade.checkStatementType(expression, context);
        context.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression));
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitArrayAccessExpression(JetArrayAccessExpression expression, ExpressionTypingContext context) {
        JetTypeInfo typeInfo = this.resolveArrayAccessGetMethod(expression, context);
        return DataFlowUtils.checkType(typeInfo, (JetExpression)expression, (ResolutionContext)context);
    }

    @NotNull
    public JetTypeInfo getTypeInfoForBinaryCall(@NotNull Name name, @NotNull ExpressionTypingContext context, @NotNull JetBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        JetExpression left = binaryExpression.getLeft();
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).getDataFlowInfo();
        }
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context);
            resolutionResults = BasicExpressionTypingVisitor.getResolutionResultsForBinaryCall(context.scope, name, contextWithDataFlow, binaryExpression, receiver);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        JetExpression right = binaryExpression.getRight();
        if (right != null) {
            dataFlowInfo = this.facade.getTypeInfo(right, contextWithDataFlow).getDataFlowInfo();
        }
        return JetTypeInfo.create(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context.contextDependency), dataFlowInfo);
    }

    @NotNull
    static OverloadResolutionResults<FunctionDescriptor> getResolutionResultsForBinaryCall(JetScope scope, Name name, ExpressionTypingContext context, JetBinaryExpression binaryExpression, ExpressionReceiver receiver) {
        return ((ExpressionTypingContext)context.replaceScope(scope)).resolveCallWithGivenName(CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
    }

    @Override
    public JetTypeInfo visitDeclaration(JetDeclaration dcl, ExpressionTypingContext context) {
        context.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(dcl));
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitRootNamespaceExpression(JetRootNamespaceExpression expression, ExpressionTypingContext context) {
        if (context.expressionPosition == ExpressionPosition.LHS_OF_DOT) {
            return DataFlowUtils.checkType(JetModuleUtil.getRootNamespaceType(expression), expression, context, context.dataFlowInfo);
        }
        context.trace.report(Errors.NAMESPACE_IS_NOT_AN_EXPRESSION.on(expression));
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitStringTemplateExpression(JetStringTemplateExpression expression, ExpressionTypingContext contextWithExpectedType) {
        final ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        final StringBuilder builder = new StringBuilder();
        final CompileTimeConstant[] value = new CompileTimeConstant[1];
        final DataFlowInfo[] dataFlowInfo = new DataFlowInfo[]{context.dataFlowInfo};
        for (JetStringTemplateEntry entry : expression.getEntries()) {
            entry.accept(new JetVisitorVoid(){

                @Override
                public void visitStringTemplateEntryWithExpression(JetStringTemplateEntryWithExpression entry) {
                    JetExpression entryExpression = entry.getExpression();
                    if (entryExpression != null) {
                        JetTypeInfo typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo[0]));
                        dataFlowInfo[0] = typeInfo.getDataFlowInfo();
                    }
                    value[0] = CompileTimeConstantResolver.OUT_OF_RANGE;
                }

                @Override
                public void visitLiteralStringTemplateEntry(JetLiteralStringTemplateEntry entry) {
                    builder.append(entry.getText());
                }

                @Override
                public void visitEscapeStringTemplateEntry(JetEscapeStringTemplateEntry entry) {
                    String text = entry.getText();
                    CompileTimeConstant<?> character = CompileTimeConstantResolver.escapedStringToCharValue(text);
                    if (character instanceof ErrorValue) {
                        context.trace.report(Errors.ILLEGAL_ESCAPE_SEQUENCE.on(entry));
                        value[0] = CompileTimeConstantResolver.OUT_OF_RANGE;
                    } else {
                        builder.append(((CharValue)character).getValue());
                    }
                }
            });
        }
        if (value[0] != CompileTimeConstantResolver.OUT_OF_RANGE) {
            context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new StringValue(builder.toString()));
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getStringType(), expression, contextWithExpectedType, dataFlowInfo[0]);
    }

    @Override
    public JetTypeInfo visitAnnotatedExpression(JetAnnotatedExpression expression, ExpressionTypingContext data) {
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return JetTypeInfo.create(null, data.dataFlowInfo);
        }
        return this.facade.getTypeInfo(baseExpression, data);
    }

    @Override
    public JetTypeInfo visitJetElement(JetElement element, ExpressionTypingContext context) {
        context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @NotNull
    JetTypeInfo resolveArrayAccessSetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull JetExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false);
    }

    @NotNull
    JetTypeInfo resolveArrayAccessGetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context, context.trace, true);
    }

    @NotNull
    private JetTypeInfo resolveArrayAccessSpecialMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @Nullable JetExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet) {
        JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (arrayExpression == null) {
            return JetTypeInfo.create(null, oldContext.dataFlowInfo);
        }
        JetTypeInfo arrayTypeInfo = this.facade.getTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        JetType arrayType = arrayTypeInfo.getType();
        if (arrayType == null) {
            return arrayTypeInfo;
        }
        DataFlowInfo dataFlowInfo = arrayTypeInfo.getDataFlowInfo();
        ExpressionTypingContext context = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(dataFlowInfo);
        ExpressionReceiver receiver = new ExpressionReceiver(arrayExpression, arrayType);
        if (!isGet) assert (rightHandSide != null);
        OverloadResolutionResults<FunctionDescriptor> functionResults = context.resolveCallWithGivenName(isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD), arrayAccessExpression, Name.identifier(isGet ? "get" : "set"));
        List<JetExpression> indices = arrayAccessExpression.getIndexExpressions();
        if (!indices.isEmpty()) {
            dataFlowInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context).getDataFlowInfo();
        }
        if (!isGet) {
            dataFlowInfo = this.facade.getTypeInfo(rightHandSide, (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo)).getDataFlowInfo();
        }
        if (!functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        return JetTypeInfo.create(functionResults.getResultingDescriptor().getReturnType(), dataFlowInfo);
    }
}

