/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.LazyDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ScopeProvider;
import org.jetbrains.jet.lang.resolve.lazy.data.FilteringClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassInfoUtil;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.NullableLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.ClassObjectMixinScope;
import org.jetbrains.jet.lang.resolve.scopes.InnerClassesScopeWrapper;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptor,
LazyDescriptor {
    private static final Predicate<Object> ONLY_ENUM_ENTRIES = Predicates.instanceOf(JetEnumEntry.class);
    private static final Predicate<JetType> VALID_SUPERTYPE = new Predicate<JetType>(){

        @Override
        public boolean apply(JetType type) {
            assert (!ErrorUtils.isErrorType(type)) : "Error types must be filtered out in DescriptorResolver";
            return TypeUtils.getClassDescriptor(type) != null;
        }
    };
    private final ResolveSession resolveSession;
    private final JetClassLikeInfo originalClassInfo;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final Name name;
    private final DeclarationDescriptor containingDeclaration;
    private final LazyClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final NotNullLazyValue<ReceiverParameterDescriptor> thisAsReceiverParameter;
    private final NotNullLazyValue<List<AnnotationDescriptor>> annotations;
    private final NullableLazyValue<ClassDescriptor> classObjectDescriptor;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final JetScope unsubstitutedInnerClassesScope;
    private final NotNullLazyValue<JetScope> scopeForClassHeaderResolution;
    private final NotNullLazyValue<JetScope> scopeForMemberDeclarationResolution;
    private final NotNullLazyValue<JetScope> scopeForPropertyInitializerResolution;

    public LazyClassDescriptor(@NotNull ResolveSession resolveSession, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull JetClassLikeInfo classLikeInfo) {
        this.resolveSession = resolveSession;
        this.name = name;
        if (classLikeInfo.getCorrespondingClassOrObject() != null) {
            this.resolveSession.getTrace().record(BindingContext.CLASS, classLikeInfo.getCorrespondingClassOrObject(), this);
        }
        this.originalClassInfo = classLikeInfo;
        JetClassLikeInfo classLikeInfoForMembers = classLikeInfo.getClassKind() != ClassKind.ENUM_CLASS ? classLikeInfo : this.noEnumEntries(classLikeInfo);
        this.declarationProvider = resolveSession.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfoForMembers);
        this.containingDeclaration = containingDeclaration;
        this.unsubstitutedMemberScope = new LazyClassMemberScope(resolveSession, this.declarationProvider, this);
        this.unsubstitutedInnerClassesScope = new InnerClassesScopeWrapper(this.unsubstitutedMemberScope);
        this.typeConstructor = new LazyClassTypeConstructor();
        JetModifierList modifierList = classLikeInfo.getModifierList();
        this.kind = classLikeInfo.getClassKind();
        if (this.kind.isObject()) {
            this.modality = Modality.FINAL;
        } else {
            Modality defaultModality = this.kind == ClassKind.TRAIT ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = ModifiersChecker.resolveModalityFromModifiers(modifierList, defaultModality);
        }
        this.visibility = ModifiersChecker.resolveVisibilityFromModifiers(modifierList, ModifiersChecker.getDefaultClassVisibility(this));
        this.isInner = ModifiersChecker.isInnerClass(modifierList);
        StorageManager storageManager = resolveSession.getStorageManager();
        this.thisAsReceiverParameter = storageManager.createLazyValue(new Computable<ReceiverParameterDescriptor>(){

            @Override
            public ReceiverParameterDescriptor compute() {
                return DescriptorResolver.createLazyReceiverParameterDescriptor(LazyClassDescriptor.this);
            }
        });
        this.annotations = storageManager.createLazyValue(new Computable<List<AnnotationDescriptor>>(){

            @Override
            public List<AnnotationDescriptor> compute() {
                return LazyClassDescriptor.this.resolveAnnotations();
            }
        });
        this.classObjectDescriptor = storageManager.createNullableLazyValue(new Computable<ClassDescriptor>(){

            @Override
            public ClassDescriptor compute() {
                return LazyClassDescriptor.this.computeClassObjectDescriptor();
            }
        });
        this.scopeForClassHeaderResolution = storageManager.createLazyValue(new Computable<JetScope>(){

            @Override
            public JetScope compute() {
                return LazyClassDescriptor.this.computeScopeForClassHeaderResolution();
            }
        });
        this.scopeForMemberDeclarationResolution = storageManager.createLazyValue(new Computable<JetScope>(){

            @Override
            public JetScope compute() {
                return LazyClassDescriptor.this.computeScopeForMemberDeclarationResolution();
            }
        });
        this.scopeForPropertyInitializerResolution = storageManager.createLazyValue(new Computable<JetScope>(){

            @Override
            public JetScope compute() {
                return LazyClassDescriptor.this.computeScopeForPropertyInitializerResolution();
            }
        });
    }

    @Override
    protected JetScope getScopeForMemberLookup() {
        return this.unsubstitutedMemberScope;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        return this.unsubstitutedInnerClassesScope;
    }

    @NotNull
    public JetScope getScopeForClassHeaderResolution() {
        return this.scopeForClassHeaderResolution.compute();
    }

    @NotNull
    private JetScope computeScopeForClassHeaderResolution() {
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this, RedeclarationHandler.DO_NOTHING, "Scope with type parameters for " + this.name);
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            scope.addClassifierDescriptor(typeParameterDescriptor);
        }
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        PsiElement scopeAnchor = this.declarationProvider.getOwnerInfo().getScopeAnchor();
        return new ChainedScope((DeclarationDescriptor)this, "ScopeForClassHeaderResolution: " + this.getName(), scope, this.getScopeProvider().getResolutionScopeForDeclaration(scopeAnchor));
    }

    @NotNull
    public JetScope getScopeForMemberDeclarationResolution() {
        return this.scopeForMemberDeclarationResolution.compute();
    }

    @NotNull
    private JetScope computeScopeForMemberDeclarationResolution() {
        WritableScopeImpl thisScope = new WritableScopeImpl(JetScope.EMPTY, this, RedeclarationHandler.DO_NOTHING, "Scope with 'this' for " + this.name);
        thisScope.addLabeledDeclaration(this);
        thisScope.changeLockLevel(WritableScope.LockLevel.READING);
        ClassDescriptor classObject = this.getClassObjectDescriptor();
        JetScope classObjectAdapterScope = classObject != null ? new ClassObjectMixinScope(classObject) : JetScope.EMPTY;
        return new ChainedScope((DeclarationDescriptor)this, "ScopeForMemberDeclarationResolution: " + this.getName(), thisScope, this.getScopeForMemberLookup(), this.getScopeForClassHeaderResolution(), classObjectAdapterScope);
    }

    @NotNull
    public JetScope getScopeForPropertyInitializerResolution() {
        return this.scopeForPropertyInitializerResolution.compute();
    }

    @NotNull
    private JetScope computeScopeForPropertyInitializerResolution() {
        ConstructorDescriptor primaryConstructor = this.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor == null) {
            return this.getScopeForMemberDeclarationResolution();
        }
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this, RedeclarationHandler.DO_NOTHING, "Scope with constructor parameters in " + this.name);
        for (ValueParameterDescriptor valueParameterDescriptor : primaryConstructor.getValueParameters()) {
            scope.addVariableDescriptor(valueParameterDescriptor);
        }
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        return new ChainedScope((DeclarationDescriptor)this, "ScopeForPropertyInitializerResolution: " + this.getName(), scope, this.getScopeForMemberDeclarationResolution());
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        return this.unsubstitutedMemberScope.getConstructors();
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    public JetType getClassObjectType() {
        ClassDescriptor classObjectDescriptor = this.getClassObjectDescriptor();
        return classObjectDescriptor == null ? null : classObjectDescriptor.getDefaultType();
    }

    @Override
    public ClassDescriptor getClassObjectDescriptor() {
        return this.classObjectDescriptor.compute();
    }

    @Nullable
    private ClassDescriptor computeClassObjectDescriptor() {
        JetClassObject classObject = this.declarationProvider.getOwnerInfo().getClassObject();
        JetClassLikeInfo classObjectInfo = this.getClassObjectInfo(classObject);
        if (classObjectInfo != null) {
            return new LazyClassDescriptor(this.resolveSession, this, DescriptorUtils.getClassObjectName(this.getName()), classObjectInfo);
        }
        return null;
    }

    @Nullable
    public JetClassLikeInfo getClassObjectInfo(JetClassObject classObject) {
        if (classObject != null) {
            if (!DescriptorUtils.inStaticContext(this)) {
                return null;
            }
            JetObjectDeclaration objectDeclaration = classObject.getObjectDeclaration();
            if (objectDeclaration != null) {
                return JetClassInfoUtil.createClassLikeInfo(objectDeclaration);
            }
        } else if (this.getKind() == ClassKind.ENUM_CLASS) {
            return this.enumClassObjectInfo(this.originalClassInfo);
        }
        return null;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        return this.thisAsReceiverParameter.compute();
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.annotations.compute();
    }

    @NotNull
    private List<AnnotationDescriptor> resolveAnnotations() {
        JetClassLikeInfo classInfo = this.declarationProvider.getOwnerInfo();
        JetModifierList modifierList = classInfo.getModifierList();
        if (modifierList != null) {
            AnnotationResolver annotationResolver = this.resolveSession.getInjector().getAnnotationResolver();
            JetScope scopeForDeclaration = this.getScopeProvider().getResolutionScopeForDeclaration(classInfo.getScopeAnchor());
            return annotationResolver.resolveAnnotationsWithArguments(scopeForDeclaration, modifierList, this.resolveSession.getTrace());
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    public String toString() {
        return "lazy class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.getAnnotations();
        this.getClassObjectDescriptor();
        this.getClassObjectType();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        ForceResolveUtil.forceResolveAllContents(this.getScopeForMemberLookup());
        this.getScopeForPropertyInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
    }

    private JetClassLikeInfo noEnumEntries(JetClassLikeInfo classLikeInfo) {
        return new FilteringClassLikeInfo(this.resolveSession.getStorageManager(), classLikeInfo, Predicates.not(ONLY_ENUM_ENTRIES));
    }

    private JetClassLikeInfo enumClassObjectInfo(JetClassLikeInfo classLikeInfo) {
        return new FilteringClassLikeInfo(this.resolveSession.getStorageManager(), classLikeInfo, ONLY_ENUM_ENTRIES){

            @Override
            public JetClassOrObject getCorrespondingClassOrObject() {
                return null;
            }

            @Override
            @NotNull
            public ClassKind getClassKind() {
                return ClassKind.CLASS_OBJECT;
            }

            @Override
            @NotNull
            public List<? extends JetParameter> getPrimaryConstructorParameters() {
                return Collections.emptyList();
            }

            @Override
            @NotNull
            public List<JetTypeParameter> getTypeParameters() {
                return Collections.emptyList();
            }
        };
    }

    private ScopeProvider getScopeProvider() {
        return this.resolveSession.getInjector().getScopeProvider();
    }

    private class LazyClassTypeConstructor
    implements LazyDescriptor,
    TypeConstructor {
        private final NotNullLazyValue<Collection<JetType>> supertypes;
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;

        private LazyClassTypeConstructor() {
            this.supertypes = LazyClassDescriptor.this.resolveSession.getStorageManager().createLazyValueWithPostCompute(new Computable<Collection<JetType>>(){

                @Override
                public Collection<JetType> compute() {
                    if (LazyClassDescriptor.this.resolveSession.isClassSpecial(DescriptorUtils.getFQName(LazyClassDescriptor.this))) {
                        return Collections.emptyList();
                    }
                    JetClassOrObject classOrObject = LazyClassDescriptor.this.declarationProvider.getOwnerInfo().getCorrespondingClassOrObject();
                    if (classOrObject == null) {
                        return Collections.emptyList();
                    }
                    List<JetType> allSupertypes = LazyClassDescriptor.this.resolveSession.getInjector().getDescriptorResolver().resolveSupertypes(LazyClassDescriptor.this.getScopeForClassHeaderResolution(), LazyClassDescriptor.this, classOrObject, LazyClassDescriptor.this.resolveSession.getTrace());
                    return Lists.newArrayList(Collections2.filter(allSupertypes, VALID_SUPERTYPE));
                }
            }, new Consumer<Collection<JetType>>(){

                @Override
                public void consume(@NotNull Collection<JetType> supertypes) {
                    LazyClassTypeConstructor.this.findAndDisconnectLoopsInTypeHierarchy(supertypes);
                }
            });
            this.parameters = LazyClassDescriptor.this.resolveSession.getStorageManager().createLazyValue(new Computable<List<TypeParameterDescriptor>>(){

                @Override
                public List<TypeParameterDescriptor> compute() {
                    JetClassLikeInfo classInfo = LazyClassDescriptor.this.declarationProvider.getOwnerInfo();
                    List<JetTypeParameter> typeParameters = classInfo.getTypeParameters();
                    ArrayList<TypeParameterDescriptor> parameters = new ArrayList<TypeParameterDescriptor>(typeParameters.size());
                    for (int i = 0; i < typeParameters.size(); ++i) {
                        parameters.add(new LazyTypeParameterDescriptor(LazyClassDescriptor.this.resolveSession, LazyClassDescriptor.this, typeParameters.get(i), i));
                    }
                    return parameters;
                }
            });
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return this.parameters.compute();
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            return this.supertypes.compute();
        }

        private void findAndDisconnectLoopsInTypeHierarchy(Collection<JetType> supertypes) {
            Iterator<JetType> iterator = supertypes.iterator();
            while (iterator.hasNext()) {
                JetType supertype = iterator.next();
                if (!this.isReachable(supertype.getConstructor(), this, new HashSet<TypeConstructor>())) continue;
                iterator.remove();
            }
        }

        private boolean isReachable(TypeConstructor from, TypeConstructor to, Set<TypeConstructor> visited) {
            if (!visited.add(from)) {
                return false;
            }
            for (JetType supertype : from.getSupertypes()) {
                TypeConstructor supertypeConstructor = supertype.getConstructor();
                if (supertypeConstructor == to) {
                    return true;
                }
                if (!this.isReachable(supertypeConstructor, to, visited)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSealed() {
            return !LazyClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        public ClassifierDescriptor getDeclarationDescriptor() {
            return LazyClassDescriptor.this;
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            return Collections.emptyList();
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }

        @Override
        public void forceResolveAllContents() {
            this.getAnnotations();
            this.getSupertypes();
            this.getParameters();
        }
    }
}

