/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.declarations;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.NavigatablePsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class FileBasedPackageMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements PackageMemberDeclarationProvider {
    private final FqName fqName;
    private final FileBasedDeclarationProviderFactory factory;
    private final Collection<JetFile> packageFiles;
    private final NotNullLazyValue<Collection<FqName>> allDeclaredPackages;

    FileBasedPackageMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull FqName _fqName, @NotNull FileBasedDeclarationProviderFactory _factory, @NotNull Collection<JetFile> packageFiles) {
        super(storageManager);
        this.fqName = _fqName;
        this.factory = _factory;
        this.packageFiles = packageFiles;
        this.allDeclaredPackages = storageManager.createLazyValue(new Computable<Collection<FqName>>(){

            @Override
            public Collection<FqName> compute() {
                return FileBasedPackageMemberDeclarationProvider.this.factory.getAllDeclaredSubPackagesOf(FileBasedPackageMemberDeclarationProvider.this.fqName);
            }
        });
    }

    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index) {
        for (JetFile file : this.packageFiles) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                assert (this.fqName.asString().equals(file.getPackageName())) : "Files declaration utils contains file with invalid namespace";
                index.putToIndex(declaration);
            }
        }
    }

    @Override
    public boolean isPackageDeclared(@NotNull Name name) {
        return this.factory.isPackageDeclared(this.fqName.child(name));
    }

    @Override
    public Collection<FqName> getAllDeclaredPackages() {
        return this.allDeclaredPackages.compute();
    }

    @Override
    @NotNull
    public Collection<NavigatablePsiElement> getPackageDeclarations(FqName fqName) {
        return this.factory.getPackageDeclarations(fqName);
    }

    public String toString() {
        return "Declarations for package " + this.fqName;
    }
}

